/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.bluetooth.BluetoothBeaconData;
import org.eclipse.kura.bluetooth.listener.AdvertisingReportRecord;
import org.eclipse.kura.bluetooth.listener.BluetoothAdvertisementData;
import org.eclipse.kura.linux.bluetooth.util.BTSnoopListener;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcess;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcessListener;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcessUtil;
import org.eclipse.kura.linux.bluetooth.util.BluetoothSafeProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothUtil {
    private static final Logger s_logger = LoggerFactory.getLogger(BluetoothUtil.class);
    private static final ExecutorService s_processExecutor = Executors.newSingleThreadExecutor();
    public static final String HCITOOL = "hcitool";
    public static final String BTDUMP = "/tmp/BluetoothUtil.btsnoopdump.sh";
    private static final String BD_ADDRESS = "BD Address:";
    private static final String HCI_VERSION = "HCI Version:";
    private static final String HCICONFIG = "hciconfig";
    private static final String GATTTOOL = "gatttool";
    private static final String DEFAULT_COMPANY_CODE = "004c";

    static {
        try {
            File f = new File(BTDUMP);
            FileUtils.writeStringToFile((File)f, (String)"#!/bin/bash\nset -e\nADAPTER=$1\n{ hcidump -i $ADAPTER -R -w /dev/fd/3 >/dev/null; } 3>&1", (boolean)false);
            f.setExecutable(true);
        }
        catch (IOException e) {
            s_logger.info("Unable to update", (Throwable)e);
        }
    }

    public static Map<String, String> getConfig(String name) throws KuraException {
        HashMap<String, String> props = new HashMap<String, String>();
        BluetoothSafeProcess proc = null;
        BufferedReader br = null;
        StringBuilder sb = null;
        String[] command = new String[]{HCICONFIG, name, "version"};
        try {
            try {
                proc = BluetoothProcessUtil.exec(command);
                br = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.toLowerCase().contains("command not found")) {
                        throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
                    }
                    if (!line.toLowerCase().contains("no such device")) continue;
                    throw new KuraException(KuraErrorCode.INTERNAL_ERROR);
                }
                if (br != null) {
                    br.close();
                }
                br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                sb = new StringBuilder();
                line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(String.valueOf(line) + "\n");
                }
                String[] results = sb.toString().split("\n");
                props.put("leReady", "false");
                String[] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String result = stringArray[n2];
                    if (result.indexOf(BD_ADDRESS) >= 0) {
                        String[] ss = result.split(" ");
                        String address = "";
                        String[] stringArray2 = ss;
                        int n3 = ss.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String sss = stringArray2[n4];
                            if (sss.matches("^([0-9a-fA-F][0-9a-fA-F]:){5}([0-9a-fA-F][0-9a-fA-F])$")) {
                                address = sss;
                                break;
                            }
                            ++n4;
                        }
                        props.put("address", address);
                        s_logger.trace("Bluetooth adapter address set to: {}", (Object)address);
                    }
                    if (result.indexOf(HCI_VERSION) >= 0 && (result.indexOf("0x6") >= 0 || result.indexOf("0x7") >= 0)) {
                        props.put("leReady", "true");
                        s_logger.trace("Bluetooth adapter is LE ready");
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                s_logger.error("Failed to execute command: {}", (Object)command, (Object)e);
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR);
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (proc != null) {
                    proc.destroy();
                }
            }
            catch (IOException e) {
                s_logger.error("Error closing read buffer", (Throwable)e);
            }
        }
        return props;
    }

    /*
     * Exception decompiling
     */
    public static boolean isEnabled(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static BufferedReader hciconfigCmd(String name, String cmd) {
        String[] command = new String[]{HCICONFIG, name, cmd};
        BluetoothSafeProcess proc = null;
        BufferedReader br = null;
        try {
            try {
                proc = BluetoothProcessUtil.exec(command);
                br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            }
            catch (Exception e) {
                s_logger.error("Error executing command: {}", (Object)command, (Object)e);
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (proc != null) {
                        proc.destroy();
                    }
                }
                catch (IOException e2) {
                    s_logger.error("Error closing read buffer", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (proc != null) {
                    proc.destroy();
                }
            }
            catch (IOException e) {
                s_logger.error("Error closing read buffer", (Throwable)e);
            }
        }
        return br;
    }

    public static void killCmd(String cmd, String signal) {
        String[] commandPidOf = new String[]{"pidof", cmd};
        BluetoothSafeProcess proc = null;
        BufferedReader br = null;
        try {
            try {
                proc = BluetoothProcessUtil.exec(commandPidOf);
                proc.waitFor();
                br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String pid = br.readLine();
                if (pid != null) {
                    String[] commandKill = new String[]{"kill", "-" + signal, pid};
                    proc = BluetoothProcessUtil.exec(commandKill);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                s_logger.error("Error executing command: {}", (Object)commandPidOf, (Object)e);
                if (proc != null) {
                    proc.destroy();
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e2) {
                    s_logger.warn("Error closing process for command: {}", (Object)commandPidOf, (Object)e2);
                }
            }
            catch (IOException e) {
                block22: {
                    s_logger.error("Error executing command: {}", (Object)commandPidOf, (Object)e);
                    if (proc == null) break block22;
                    proc.destroy();
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e3) {
                    s_logger.warn("Error closing process for command: {}", (Object)commandPidOf, (Object)e3);
                }
            }
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                s_logger.warn("Error closing process for command: {}", (Object)commandPidOf, (Object)e);
            }
        }
    }

    public static BluetoothProcess btdumpCmd(String name, BTSnoopListener listener) {
        Object[] command = new String[]{BTDUMP, name};
        BluetoothProcess proc = null;
        try {
            s_logger.debug("Command executed : {}", (Object)Arrays.toString(command));
            proc = BluetoothUtil.execSnoop((String[])command, listener);
        }
        catch (Exception e) {
            s_logger.error("Error executing command: {}", (Object)command, (Object)e);
        }
        return proc;
    }

    public static BluetoothProcess hcitoolCmd(String name, String cmd, BluetoothProcessListener listener) {
        Object[] command = new String[]{HCITOOL, "-i", name, cmd};
        BluetoothProcess proc = null;
        try {
            s_logger.debug("Command executed : {}", (Object)Arrays.toString(command));
            proc = BluetoothUtil.exec((String[])command, listener);
        }
        catch (Exception e) {
            s_logger.error("Error executing command: {}", (Object)command, (Object)e);
        }
        return proc;
    }

    public static BluetoothProcess hcitoolCmd(String name, String[] cmd, BluetoothProcessListener listener) {
        Object[] command = new String[3 + cmd.length];
        command[0] = HCITOOL;
        command[1] = "-i";
        command[2] = name;
        int i = 0;
        while (i < cmd.length) {
            command[i + 3] = cmd[i];
            ++i;
        }
        BluetoothProcess proc = null;
        try {
            s_logger.debug("Command executed : {}", (Object)Arrays.toString(command));
            proc = BluetoothUtil.exec((String[])command, listener);
        }
        catch (Exception e) {
            s_logger.error("Error executing command: {}", (Object)command, (Object)e);
        }
        return proc;
    }

    public static BluetoothProcess startSession(String adapterName, String address, BluetoothProcessListener listener) {
        String[] command = new String[]{GATTTOOL, "-i", adapterName, "-b", address, "-I"};
        BluetoothProcess proc = null;
        try {
            proc = BluetoothUtil.exec(command, listener);
        }
        catch (Exception e) {
            s_logger.error("Error executing command: {}", (Object)command, (Object)e);
        }
        return proc;
    }

    private static BluetoothProcess exec(final String[] cmdArray, final BluetoothProcessListener listener) throws IOException {
        Future<BluetoothProcess> futureSafeProcess = s_processExecutor.submit(new Callable<BluetoothProcess>(){

            @Override
            public BluetoothProcess call() throws Exception {
                Thread.currentThread().setName("BluetoothProcessExecutor");
                BluetoothProcess bluetoothProcess = new BluetoothProcess();
                bluetoothProcess.exec(cmdArray, listener);
                return bluetoothProcess;
            }
        });
        try {
            return futureSafeProcess.get();
        }
        catch (Exception e) {
            s_logger.error("Error waiting from SafeProcess output", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static BluetoothProcess execSnoop(final String[] cmdArray, final BTSnoopListener listener) throws IOException {
        Future<BluetoothProcess> futureSafeProcess = s_processExecutor.submit(new Callable<BluetoothProcess>(){

            @Override
            public BluetoothProcess call() throws Exception {
                Thread.currentThread().setName("BTSnoopProcessExecutor");
                BluetoothProcess bluetoothProcess = new BluetoothProcess();
                bluetoothProcess.execSnoop(cmdArray, listener);
                return bluetoothProcess;
            }
        });
        try {
            return futureSafeProcess.get();
        }
        catch (Exception e) {
            s_logger.error("Error waiting from SafeProcess output", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static BluetoothBeaconData parseEIRData(byte[] b, int payloadPtr, int len, String companyName) {
        int ptr = payloadPtr;
        while (ptr < payloadPtr + len) {
            byte structSize = b[ptr];
            if (structSize == 0) break;
            byte dataType = b[ptr + 1];
            if (dataType == -1) {
                int prefixPtr = ptr + 2;
                byte[] prefix = new byte[4];
                companyName = BluetoothUtil.inSetHex(BluetoothUtil.inSetRange(companyName, 4, DEFAULT_COMPANY_CODE), DEFAULT_COMPANY_CODE);
                prefix[0] = (byte)Integer.parseInt(companyName.substring(2, 4), 16);
                prefix[1] = (byte)Integer.parseInt(companyName.substring(0, 2), 16);
                prefix[2] = 2;
                prefix[3] = 21;
                if (Arrays.equals(prefix, Arrays.copyOfRange(b, prefixPtr, prefixPtr + prefix.length))) {
                    BluetoothBeaconData bi = new BluetoothBeaconData();
                    int uuidPtr = ptr + 2 + prefix.length;
                    int majorPtr = uuidPtr + 16;
                    int minorPtr = uuidPtr + 18;
                    bi.uuid = "";
                    byte[] byArray = Arrays.copyOfRange(b, uuidPtr, majorPtr);
                    int n = byArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte ub = byArray[n2];
                        bi.uuid = String.valueOf(bi.uuid) + String.format("%02X", ub);
                        ++n2;
                    }
                    int majorl = b[majorPtr + 1] & 0xFF;
                    int majorh = b[majorPtr] & 0xFF;
                    int minorl = b[minorPtr + 1] & 0xFF;
                    int minorh = b[minorPtr] & 0xFF;
                    bi.major = majorh << 8 | majorl;
                    bi.minor = minorh << 8 | minorl;
                    bi.txpower = b[minorPtr + 2];
                    bi.address = "";
                    return bi;
                }
            }
            ptr += structSize + 1;
        }
        return null;
    }

    private static String inSetRange(String value, int range, String defaultValue) {
        if (value.length() != range) {
            return defaultValue;
        }
        return value;
    }

    private static String inSetHex(String value, String defaultValue) {
        if (!value.matches("^[0-9a-fA-F]+$")) {
            return defaultValue;
        }
        return value;
    }

    public static BluetoothAdvertisementData parseLEAdvertisement(byte[] b) {
        BluetoothAdvertisementData btAdData = null;
        if (b[0] != 4 || b[1] != 62) {
            return btAdData;
        }
        if (b[3] != 2) {
            return btAdData;
        }
        btAdData = new BluetoothAdvertisementData();
        btAdData.setRawData(b);
        btAdData.setPacketType(b[0]);
        btAdData.setEventType(b[1]);
        btAdData.setParameterLength((int)b[2]);
        btAdData.setSubEventCode(b[3]);
        btAdData.setNumberOfReports((int)b[4]);
        int ptr = 5;
        int nr = 0;
        while (nr < btAdData.getNumberOfReports()) {
            AdvertisingReportRecord arr = new AdvertisingReportRecord();
            arr.setEventType((int)b[ptr++]);
            arr.setAddressType((int)b[ptr++]);
            String address = String.format("%02X:%02X:%02X:%02X:%02X:%02X", b[ptr + 5], b[ptr + 4], b[ptr + 3], b[ptr + 2], b[ptr + 1], b[ptr + 0]);
            arr.setAddress(address);
            ptr += 6;
            byte arrDataLength = b[ptr++];
            arr.setLength((int)b[ptr++]);
            byte[] arrData = new byte[arrDataLength];
            System.arraycopy(b, ptr, arrData, 0, arrDataLength);
            arr.setReportData(arrData);
            btAdData.addReportRecord(arr);
            ptr += arrDataLength;
            ++nr;
        }
        return btAdData;
    }

    public static List<BluetoothBeaconData> parseLEAdvertisingReport(byte[] b, String companyName) {
        LinkedList<BluetoothBeaconData> results = new LinkedList<BluetoothBeaconData>();
        if (b[0] != 4 || b[1] != 62) {
            return results;
        }
        if (b[3] != 2) {
            return results;
        }
        int numReports = b[4];
        int ptr = 5;
        int i = 0;
        while (i < numReports) {
            byte len;
            BluetoothBeaconData bi;
            ++ptr;
            String address = String.format("%02X:%02X:%02X:%02X:%02X:%02X", b[++ptr + 5], b[ptr + 4], b[ptr + 3], b[ptr + 2], b[ptr + 1], b[ptr + 0]);
            ptr += 6;
            if ((bi = BluetoothUtil.parseEIRData(b, ptr, len = b[ptr++], companyName)) != null) {
                bi.address = address;
                bi.rssi = b[ptr + len];
                results.add(bi);
            }
            ptr += len;
            ++i;
        }
        return results;
    }
}

