/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.type;

import java.util.Objects;
import org.eclipse.kura.annotation.Immutable;
import org.eclipse.kura.annotation.ThreadSafe;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.osgi.annotation.versioning.ProviderType;

@Immutable
@ThreadSafe
@ProviderType
public class DoubleValue
implements TypedValue<Double> {
    private final double value;

    public DoubleValue(double value) {
        this.value = value;
    }

    @Override
    public int compareTo(TypedValue<Double> otherTypedValue) {
        Objects.requireNonNull(otherTypedValue, "Typed Value cannot be null");
        return Double.valueOf(this.value).compareTo(otherTypedValue.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleValue other = (DoubleValue)obj;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    @Override
    public DataType getType() {
        return DataType.DOUBLE;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "DoubleValue [value=" + this.value + "]";
    }
}

