/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.identity.provider;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.internal.rest.identity.provider.LegacyIdentityService;
import org.eclipse.kura.internal.rest.identity.provider.dto.PermissionDTO;
import org.eclipse.kura.internal.rest.identity.provider.dto.UserConfigDTO;
import org.eclipse.kura.internal.rest.identity.provider.dto.UserDTO;
import org.eclipse.kura.internal.rest.identity.provider.dto.ValidatorOptionsDTO;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.request.handler.jaxrs.JaxRsRequestHandlerProxy;
import org.eclipse.kura.util.validation.ValidatorOptions;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="identity/v1")
public class IdentityRestServiceV1 {
    private static final Logger logger = LoggerFactory.getLogger(IdentityRestServiceV1.class);
    private static final String MQTT_APP_ID = "IDN-V1";
    private static final String DEBUG_MESSAGE = "Processing request for method '{}'";
    private static final String REST_ROLE_NAME = "identity";
    private static final String KURA_PERMISSION_REST_ROLE = "kura.permission.rest.identity";
    private final RequestHandler requestHandler = new JaxRsRequestHandlerProxy((Object)this);
    private LegacyIdentityService legacyIdentityService;
    private CryptoService cryptoService;
    private UserAdmin userAdmin;
    private ConfigurationService configurationService;

    public void bindCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void bindConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void bindUserAdmin(UserAdmin userAdmin) {
        this.userAdmin = userAdmin;
        this.userAdmin.createRole(KURA_PERMISSION_REST_ROLE, 2);
    }

    public void bindRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.registerRequestHandler(MQTT_APP_ID, this.requestHandler);
        }
        catch (Exception e) {
            logger.warn("Failed to register {} request handler", (Object)MQTT_APP_ID, (Object)e);
        }
    }

    public void unbindRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.unregister(MQTT_APP_ID);
        }
        catch (Exception e) {
            logger.warn("Failed to unregister {} request handler", (Object)MQTT_APP_ID, (Object)e);
        }
    }

    public void bindLegacyIdentityService(LegacyIdentityService legacyIdentityService) {
        this.legacyIdentityService = legacyIdentityService;
    }

    public void activate() {
        if (this.legacyIdentityService == null) {
            this.legacyIdentityService = new LegacyIdentityService(this.cryptoService, this.userAdmin, this.configurationService);
        }
    }

    @POST
    @RolesAllowed(value={"identity"})
    @Path(value="/identities")
    @Consumes(value={"application/json"})
    public Response createUser(UserDTO userName) {
        try {
            logger.debug(DEBUG_MESSAGE, (Object)"createUser");
            this.legacyIdentityService.createUser(userName);
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @PUT
    @RolesAllowed(value={"identity"})
    @Path(value="/identities")
    @Consumes(value={"application/json"})
    public Response updateUser(UserDTO user) {
        try {
            logger.debug(DEBUG_MESSAGE, (Object)"updateUser");
            this.legacyIdentityService.updateUser(user);
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @POST
    @RolesAllowed(value={"identity"})
    @Path(value="/identities/byName")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public UserDTO getUser(UserDTO userName) {
        try {
            logger.debug(DEBUG_MESSAGE, (Object)"getUser");
            return this.legacyIdentityService.getUser(userName.getUserName());
        }
        catch (KuraException e) {
            if (e.getCode().equals((Object)KuraErrorCode.NOT_FOUND)) {
                throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.NOT_FOUND, (String)"Identity does not exist");
            }
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @RolesAllowed(value={"identity"})
    @Path(value="/identities")
    @Consumes(value={"application/json"})
    public Response deleteUser(UserDTO userName) {
        try {
            logger.debug(DEBUG_MESSAGE, (Object)"deleteUser");
            this.legacyIdentityService.deleteUser(userName.getUserName());
        }
        catch (KuraException e) {
            if (e.getCode().equals((Object)KuraErrorCode.NOT_FOUND)) {
                throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.NOT_FOUND, (String)"Identity does not exist");
            }
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/definedPermissions")
    @Produces(value={"application/json"})
    public PermissionDTO getDefinedPermissions() {
        try {
            logger.debug(DEBUG_MESSAGE, (Object)"getDefinedPermissions");
            return new PermissionDTO(this.legacyIdentityService.getDefinedPermissions());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    @GET
    @RolesAllowed(value={"identity"})
    @Path(value="/identities")
    @Produces(value={"application/json"})
    public UserConfigDTO getUserConfig() {
        try {
            logger.debug(DEBUG_MESSAGE, (Object)"getUserConfig");
            UserConfigDTO userConfig = new UserConfigDTO();
            userConfig.setUserConfig(this.legacyIdentityService.getUserConfig());
            return userConfig;
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="/passwordRequirements")
    @Produces(value={"application/json"})
    public ValidatorOptionsDTO getValidatorOptions() {
        try {
            logger.debug(DEBUG_MESSAGE, (Object)"getValidatorOptions");
            ValidatorOptions validatorOptions = this.legacyIdentityService.getValidatorOptions();
            return new ValidatorOptionsDTO(validatorOptions.isPasswordMinimumLength(), validatorOptions.isPasswordRequireDigits(), validatorOptions.isPasswordRequireBothCases(), validatorOptions.isPasswordRequireSpecialChars());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }
}

