/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.identity.provider.util;

import java.util.Objects;
import javax.ws.rs.core.Response;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;

public class StringUtils {
    private StringUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void requireNotEmpty(String value, String message) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void validateField(String propertyName, String inputToValidate) {
        if (Objects.isNull(inputToValidate)) {
            throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.BAD_REQUEST, (String)("Missing '" + propertyName + "' property"));
        }
        if (inputToValidate.trim().isEmpty()) {
            throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.BAD_REQUEST, (String)("`" + propertyName + "` value can't be empty"));
        }
    }
}

