/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.db;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.message.store.StoredMessage;
import org.eclipse.kura.util.jdbc.ConnectionProvider;
import org.eclipse.kura.util.jdbc.JdbcUtil;
import org.eclipse.kura.util.message.store.AbstractJdbcMessageStoreImpl;
import org.eclipse.kura.util.message.store.JdbcMessageStoreQueries;

public class H2DbMessageStoreImpl
extends AbstractJdbcMessageStoreImpl {
    private static final String CREATE_INDEX_IF_NOT_EXISTS = "CREATE INDEX IF NOT EXISTS ";
    private static final String UPDATE = "UPDATE ";
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String SELECT_MESSAGE_METADATA_FROM = "SELECT id, topic, qos, retain, createdOn, publishedOn, publishedMessageId, confirmedOn, priority, sessionId, droppedOn FROM ";
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private static final int PAYLOAD_BYTE_SIZE_THRESHOLD = 200;
    private static final int NUMERIC_VALUE_OUT_OF_RANGE_1 = 22003;
    private static final int NUMERIC_VALUE_OUT_OF_RANGE_2 = 22004;
    private String sqlSetNextId;
    private String sqlGetFreeId;

    public H2DbMessageStoreImpl(ConnectionProvider provider, String table) throws KuraStoreException {
        super(provider, table);
        this.initDb();
    }

    private void initDb() throws KuraStoreException {
        this.sqlSetNextId = ALTER_TABLE + this.escapedTableName + " ALTER COLUMN id RESTART WITH ?;";
        this.sqlGetFreeId = "SELECT A.X FROM SYSTEM_RANGE(1, 2147483647) AS A LEFT OUTER JOIN " + this.escapedTableName + " AS B ON A.X = B.ID WHERE B.ID IS NULL LIMIT 1";
        super.createTable();
        super.createIndexes();
    }

    protected JdbcMessageStoreQueries buildSqlMessageStoreQueries() {
        return JdbcMessageStoreQueries.builder().withSqlCreateTable("CREATE TABLE IF NOT EXISTS " + this.escapedTableName + " (id INTEGER GENERATED ALWAYS AS IDENTITY PRIMARY KEY, topic VARCHAR(32767 CHARACTERS), qos INTEGER, retain BOOLEAN, " + "createdOn TIMESTAMP, publishedOn TIMESTAMP, publishedMessageId INTEGER, confirmedOn TIMESTAMP, " + "smallPayload VARBINARY, largePayload BLOB(16777216), priority INTEGER," + " sessionId VARCHAR(32767 CHARACTERS), droppedOn TIMESTAMP);").withSqlMessageCount("SELECT COUNT(*) FROM " + this.escapedTableName + ";").withSqlStore("INSERT INTO " + this.escapedTableName + " (topic, qos, retain, createdOn, publishedOn, publishedMessageId, confirmedOn, smallPayload, largePayload, priority, " + "sessionId, droppedOn) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);").withSqlGetMessage("SELECT id, topic, qos, retain, createdOn, publishedOn, publishedMessageId, confirmedOn, smallPayload, largePayload, priority, sessionId, droppedOn FROM " + this.escapedTableName + " WHERE id = ?").withSqlGetNextMessage("SELECT a.id, a.topic, a.qos, a.retain, a.createdOn, a.publishedOn, a.publishedMessageId, a.confirmedOn, a.smallPayload, a.largePayload, a.priority, a.sessionId, a.droppedOn FROM " + this.escapedTableName + " AS a JOIN (SELECT id, publishedOn FROM " + this.escapedTableName + " ORDER BY publishedOn ASC NULLS FIRST, priority ASC, createdOn ASC LIMIT 1) AS b " + "WHERE a.id = b.id AND b.publishedOn IS NULL;").withSqlSetPublishedQoS1(UPDATE + this.escapedTableName + " SET publishedOn = ?, publishedMessageId = ?, sessionId = ? WHERE id = ?;").withSqlSetPublishedQoS0(UPDATE + this.escapedTableName + " SET publishedOn = ? WHERE id = ?;").withSqlSetConfirmed(UPDATE + this.escapedTableName + " SET confirmedOn = ? WHERE id = ?;").withSqlAllUnpublishedMessages(SELECT_MESSAGE_METADATA_FROM + this.escapedTableName + " WHERE publishedOn IS NULL ORDER BY priority ASC, createdOn ASC;").withSqlAllInFlightMessages(SELECT_MESSAGE_METADATA_FROM + this.escapedTableName + " WHERE publishedOn IS NOT NULL AND qos > 0 AND confirmedOn IS NULL AND droppedOn IS NULL " + "ORDER BY priority ASC, createdOn ASC").withSqlAllDroppedInFlightMessages(SELECT_MESSAGE_METADATA_FROM + this.escapedTableName + " WHERE droppedOn IS NOT NULL ORDER BY priority ASC, createdOn ASC;").withSqlUnpublishAllInFlightMessages(UPDATE + this.escapedTableName + " SET publishedOn = NULL WHERE publishedOn IS NOT NULL AND qos > 0 AND confirmedOn IS NULL;").withSqlDropAllInFlightMessages(UPDATE + this.escapedTableName + " SET droppedOn = ? WHERE publishedOn IS NOT NULL AND qos > 0 AND confirmedOn IS NULL;").withSqlDeleteDroppedMessages(DELETE_FROM + this.escapedTableName + " WHERE droppedOn <= DATEADD('MILLISECOND', ?, TIMESTAMP '1970-01-01 00:00:00') AND droppedOn IS NOT NULL;").withSqlDeleteConfirmedMessages(DELETE_FROM + this.escapedTableName + " WHERE confirmedOn <= DATEADD('MILLISECOND', ?, TIMESTAMP '1970-01-01 00:00:00') AND confirmedOn IS NOT NULL;").withSqlDeletePublishedMessages(DELETE_FROM + this.escapedTableName + " WHERE qos = 0 AND publishedOn <= DATEADD('MILLISECOND', ?, TIMESTAMP '1970-01-01 00:00:00') AND publishedOn IS NOT NULL;").withSqlCreateNextMessageIndex(CREATE_INDEX_IF_NOT_EXISTS + super.escapeIdentifier(String.valueOf(this.tableName) + "_nextMsg") + " ON " + this.escapedTableName + " (publishedOn ASC, priority ASC, createdOn ASC, qos);").withSqlCreatePublishedOnIndex(CREATE_INDEX_IF_NOT_EXISTS + super.escapeIdentifier(String.valueOf(this.tableName) + "_PUBLISHEDON") + " ON " + this.escapedTableName + " (publishedOn DESC);").withSqlCreateConfirmedOnIndex(CREATE_INDEX_IF_NOT_EXISTS + super.escapeIdentifier(String.valueOf(this.tableName) + "_CONFIRMEDON") + " ON " + this.escapedTableName + " (confirmedOn DESC);").withSqlCreateDroppedOnIndex(CREATE_INDEX_IF_NOT_EXISTS + super.escapeIdentifier(String.valueOf(this.tableName) + "_DROPPEDON") + " ON " + this.escapedTableName + " (droppedOn DESC);").build();
    }

    public synchronized int store(String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraStoreException {
        this.validate(topic);
        try {
            return (int)this.storeInternal(topic, payload, qos, retain, priority);
        }
        catch (KuraStoreException e) {
            this.handleKuraStoreException(e);
            return (int)this.storeInternal(topic, payload, qos, retain, priority);
        }
    }

    private void handleKuraStoreException(KuraStoreException e) throws KuraStoreException {
        Throwable cause = e.getCause();
        if (!(cause instanceof SQLException)) {
            throw e;
        }
        int errorCode = ((SQLException)cause).getErrorCode();
        if (errorCode == 22003 || errorCode == 22004 || errorCode == 90006 || errorCode == 23505) {
            if (super.getMessageCountInternal() >= Integer.MAX_VALUE) {
                throw new KuraStoreException((Object)"Table size is greater or equal than integer max value");
            }
            int freeId = (Integer)this.connectionProvider.withPreparedStatement(this.sqlGetFreeId, (c, stmt) -> (Integer)JdbcUtil.getFirstColumnValue(stmt::executeQuery, ResultSet::getInt), "failed to get free ID");
            super.execute(this.sqlSetNextId, new Object[]{freeId});
            return;
        }
        throw e;
    }

    protected synchronized long storeInternal(String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraStoreException {
        Timestamp now = new Timestamp(new Date().getTime());
        return (Long)this.connectionProvider.withConnection(c -> {
            long result;
            Throwable throwable = null;
            Object var11_10 = null;
            try (PreparedStatement pstmt = c.prepareStatement(this.queries.getSqlStore(), new String[]{"id"});){
                pstmt.setString(1, topic);
                pstmt.setInt(2, qos);
                pstmt.setBoolean(3, retain);
                pstmt.setTimestamp(4, now, this.utcCalendar);
                pstmt.setTimestamp(5, null);
                pstmt.setInt(6, -1);
                pstmt.setTimestamp(7, null);
                if (payload == null || payload.length < 200) {
                    pstmt.setBytes(8, payload);
                    pstmt.setNull(9, 2004);
                } else {
                    pstmt.setNull(8, -3);
                    pstmt.setBinaryStream(9, (InputStream)new ByteArrayInputStream(payload), payload.length);
                }
                pstmt.setInt(10, priority);
                pstmt.setString(11, null);
                pstmt.setTimestamp(12, null);
                pstmt.execute();
                result = ((Integer)JdbcUtil.getFirstColumnValue(pstmt::getGeneratedKeys, ResultSet::getInt)).intValue();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            c.commit();
            return result;
        }, "Cannot store message");
    }

    protected StoredMessage.Builder buildStoredMessageBuilder(ResultSet rs, boolean includePayload) throws SQLException {
        StoredMessage.Builder result = super.buildStoredMessageBuilder(rs, false);
        if (includePayload) {
            byte[] payload = rs.getBytes("smallPayload");
            if (payload == null) {
                payload = rs.getBytes("largePayload");
            }
            result = result.withPayload(payload);
        }
        return result;
    }
}

