/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.download.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.kura.KuraConnectException;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraRuntimeException;
import org.eclipse.kura.core.deployment.DownloadStatus;
import org.eclipse.kura.core.deployment.download.DownloadCountingOutputStream;
import org.eclipse.kura.core.deployment.download.DownloadOptions;
import org.eclipse.kura.core.deployment.download.impl.GenericDownloadCountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDownloadCountingOutputStream
extends GenericDownloadCountingOutputStream
implements DownloadCountingOutputStream {
    private static final Logger logger = LoggerFactory.getLogger(HttpDownloadCountingOutputStream.class);
    private ExecutorService executor;
    private Future<Void> future;

    public HttpDownloadCountingOutputStream(DownloadOptions downloadOptions) {
        super(downloadOptions);
        this.setBufferSize(this.options.getBlockSize());
        this.setResolution(this.options.getNotifyBlockSize());
        this.setBlockDelay(this.options.getBlockDelay());
        this.setConnectTimeout(this.options.getTimeout());
    }

    @Override
    public void cancelDownload() throws Exception {
        if (this.executor != null && this.future != null) {
            this.future.cancel(true);
            this.executor.shutdownNow();
            this.postProgressEvent(this.options.getClientId(), this.getByteCount(), this.totalBytes, DownloadStatus.CANCELLED, "Download cancelled");
        }
    }

    @Override
    public void startWork() throws KuraException {
        this.executor = Executors.newSingleThreadExecutor();
        this.future = this.executor.submit(this::downloadTask);
        try {
            this.future.get();
        }
        catch (ExecutionException ex) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)ex, new Object[0]);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)ex, new Object[0]);
        }
    }

    private Void downloadTask() throws KuraException {
        boolean shouldAuthenticate = false;
        try {
            try {
                int newSize;
                boolean bl = shouldAuthenticate = this.options.getUsername() != null && this.options.getPassword() != null && (!this.options.getUsername().trim().isEmpty() || this.options.getPassword().trim().isEmpty());
                if (shouldAuthenticate) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(HttpDownloadCountingOutputStream.this.options.getUsername(), HttpDownloadCountingOutputStream.this.options.getPassword().toCharArray());
                        }
                    });
                }
                HttpURLConnection.setFollowRedirects(false);
                HttpURLConnection urlConnection = this.openAndConnect(this.downloadURL);
                this.is = urlConnection.getInputStream();
                String s = urlConnection.getHeaderField("Content-Length");
                logger.info("Content-lenght: {}", (Object)s);
                this.setTotalBytes(s != null ? Integer.parseInt(s) : -1);
                this.postProgressEvent(this.options.getClientId(), 0L, this.totalBytes, DownloadStatus.IN_PROGRESS, null);
                int bufferSize = this.getBufferSize();
                if (bufferSize == 0 && this.getTotalBytes() > 0L) {
                    bufferSize = newSize = Math.round((float)this.totalBytes / 100.0f + 1.0f);
                    this.setBufferSize(newSize);
                } else if (bufferSize == 0) {
                    bufferSize = newSize = 4096;
                    this.setBufferSize(newSize);
                }
                long numBytes = IOUtils.copyLarge((InputStream)this.is, (OutputStream)((Object)this), (byte[])new byte[bufferSize]);
                this.postProgressEvent(this.options.getClientId(), numBytes, this.totalBytes, DownloadStatus.COMPLETED, null);
            }
            catch (IOException e) {
                this.postProgressEvent(this.options.getClientId(), this.getByteCount(), this.totalBytes, DownloadStatus.FAILED, e.getMessage());
                throw new KuraConnectException((Object)e);
            }
        }
        catch (Throwable throwable) {
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {}
            }
            try {
                this.close();
            }
            catch (IOException iOException) {}
            if (shouldAuthenticate) {
                Authenticator.setDefault(null);
            }
            throw throwable;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {}
        }
        try {
            this.close();
        }
        catch (IOException iOException) {}
        if (shouldAuthenticate) {
            Authenticator.setDefault(null);
        }
        return null;
    }

    private HttpURLConnection openAndConnect(String downloadUrlString) throws IOException, KuraConnectException {
        URL localUrl = new URL(downloadUrlString);
        HttpURLConnection urlConnection = this.openConnection(localUrl);
        this.checkIsHttpProtocol(urlConnection);
        this.setupConnection(urlConnection);
        urlConnection.connect();
        int responseCode = urlConnection.getResponseCode();
        if (responseCode == 302 || responseCode == 301 || responseCode == 303) {
            String newLocation = urlConnection.getHeaderField("Location");
            if (StringUtils.isNotEmpty((CharSequence)newLocation)) {
                return this.openAndConnect(newLocation);
            }
            throw new KuraRuntimeException(KuraErrorCode.INVALID_PARAMETER);
        }
        return urlConnection;
    }

    private void setupConnection(HttpURLConnection urlConnection) throws IOException, KuraConnectException {
        try {
            if (urlConnection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)urlConnection;
                httpsURLConnection.setSSLSocketFactory(this.sslManagerService.getSSLSocketFactory());
                httpsURLConnection.setHostnameVerifier((hostname, session) -> true);
            }
        }
        catch (GeneralSecurityException e) {
            this.postProgressEvent(this.options.getClientId(), this.getByteCount(), this.totalBytes, DownloadStatus.FAILED, e.getMessage());
            throw new KuraConnectException((Throwable)e, (Object)"Unable to create SSL Socket Factory.");
        }
        int connectTimeout = this.getConnectTimeout();
        int readTimeout = this.getPropReadTimeout();
        urlConnection.setConnectTimeout(connectTimeout);
        urlConnection.setReadTimeout(readTimeout);
    }

    protected HttpURLConnection openConnection(URL localUrl) throws IOException {
        return (HttpURLConnection)localUrl.openConnection();
    }

    private void checkIsHttpProtocol(URLConnection urlConnection) throws KuraConnectException {
        if (!(urlConnection instanceof HttpURLConnection)) {
            this.postProgressEvent(this.options.getClientId(), this.getByteCount(), this.totalBytes, DownloadStatus.FAILED, "The request URL is not supported");
            throw new KuraConnectException((Object)"Unsupported protocol!");
        }
    }
}

