/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.identity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.identity.PasswordStrengthRequirements;
import org.eclipse.kura.identity.PasswordStrengthVerificationService;
import org.eclipse.kura.util.validation.PasswordStrengthValidators;
import org.eclipse.kura.util.validation.Validator;
import org.eclipse.kura.util.validation.ValidatorOptions;

public class PasswordStrengthVerificationServiceImpl
implements PasswordStrengthVerificationService {
    private static final String KURA_WEB_CONSOLE_SERVICE_PID = "org.eclipse.kura.web.Console";
    private ConfigurationService configurationService;

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void checkPasswordStrength(char[] password) throws KuraException {
        ValidatorOptions validatorOptions = this.getValidatorOptions();
        List validators = PasswordStrengthValidators.fromConfig((ValidatorOptions)validatorOptions);
        ArrayList errors = new ArrayList();
        for (Validator validator : validators) {
            validator.validate((Object)new String(password), errors::add);
        }
        if (!errors.isEmpty()) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Password strength requirements not satisfied: " + errors.stream().collect(Collectors.joining("; "))});
        }
    }

    public ValidatorOptions getValidatorOptions() throws KuraException {
        ComponentConfiguration consoleConfig = this.configurationService.getComponentConfiguration(KURA_WEB_CONSOLE_SERVICE_PID);
        if (consoleConfig == null) {
            throw new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE, new Object[]{"Console is not registered"});
        }
        return new ValidatorOptions(consoleConfig.getConfigurationProperties());
    }

    public PasswordStrengthRequirements getPasswordStrengthRequirements() throws KuraException {
        ValidatorOptions validatorOptions = this.getValidatorOptions();
        return new PasswordStrengthRequirements(validatorOptions.isPasswordMinimumLength(), validatorOptions.isPasswordRequireDigits(), validatorOptions.isPasswordRequireSpecialChars(), validatorOptions.isPasswordRequireBothCases());
    }
}

