/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.channel;

import java.util.Objects;
import org.eclipse.kura.annotation.Immutable;
import org.eclipse.kura.annotation.Nullable;
import org.eclipse.kura.annotation.ThreadSafe;
import org.eclipse.kura.channel.ChannelFlag;
import org.osgi.annotation.versioning.ProviderType;

@Immutable
@ThreadSafe
@ProviderType
public class ChannelStatus {
    private final ChannelFlag channelFlag;
    @Nullable
    private final Exception exception;
    @Nullable
    private final String exceptionMessage;

    public ChannelStatus(ChannelFlag channelFlag) {
        Objects.requireNonNull(channelFlag, "Channel Flag cannot be null");
        this.channelFlag = channelFlag;
        this.exceptionMessage = null;
        this.exception = null;
    }

    public ChannelStatus(ChannelFlag channelFlag, @Nullable String exceptionMessage, @Nullable Exception exception) {
        Objects.requireNonNull(channelFlag, "Driver Flag cannot be null");
        this.channelFlag = channelFlag;
        this.exceptionMessage = exceptionMessage;
        this.exception = exception;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelStatus other = (ChannelStatus)obj;
        if (this.channelFlag != other.channelFlag) {
            return false;
        }
        if (this.exception == null ? other.exception != null : !this.exception.equals(other.exception)) {
            return false;
        }
        return !(this.exceptionMessage == null ? other.exceptionMessage != null : !this.exceptionMessage.equals(other.exceptionMessage));
    }

    public ChannelFlag getChannelFlag() {
        return this.channelFlag;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.channelFlag == null ? 0 : this.channelFlag.hashCode());
        result = 31 * result + (this.exception == null ? 0 : this.exception.hashCode());
        result = 31 * result + (this.exceptionMessage == null ? 0 : this.exceptionMessage.hashCode());
        return result;
    }

    public String toString() {
        return "ChannelStatus [channelFlag=" + (Object)((Object)this.channelFlag) + ", exception=" + this.exception + ", exceptionMessage=" + this.exceptionMessage + "]";
    }
}

