/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.identity;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.identity.IdentityConfigurationComponent;
import org.eclipse.kura.identity.PasswordHash;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class PasswordConfiguration
implements IdentityConfigurationComponent {
    private final boolean passwordChangeNeeded;
    private final boolean passwordAuthEnabled;
    private final Optional<char[]> newPassword;
    private final Optional<PasswordHash> passwordHash;

    public PasswordConfiguration(boolean passwordChangeNeeded, boolean passwordAuthEnabled, Optional<char[]> newPassword, Optional<PasswordHash> passwordHash) {
        this.passwordChangeNeeded = passwordChangeNeeded;
        this.passwordAuthEnabled = passwordAuthEnabled;
        this.newPassword = Objects.requireNonNull(newPassword, "newPassword cannot be null");
        this.passwordHash = Objects.requireNonNull(passwordHash, "password hash cannot be null");
    }

    public boolean isPasswordChangeNeeded() {
        return this.passwordChangeNeeded;
    }

    public boolean isPasswordAuthEnabled() {
        return this.passwordAuthEnabled;
    }

    public Optional<PasswordHash> getPasswordHash() {
        return this.passwordHash;
    }

    public Optional<char[]> getNewPassword() {
        return this.newPassword;
    }

    public int hashCode() {
        return Objects.hash(this.newPassword, this.passwordAuthEnabled, this.passwordChangeNeeded, this.passwordHash);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PasswordConfiguration)) {
            return false;
        }
        PasswordConfiguration other = (PasswordConfiguration)obj;
        return Objects.equals(this.newPassword, other.newPassword) && this.passwordAuthEnabled == other.passwordAuthEnabled && this.passwordChangeNeeded == other.passwordChangeNeeded && Objects.equals(this.passwordHash, other.passwordHash);
    }
}

