/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports.netty;

import java.net.URI;
import java.util.Map;
import org.apache.qpid.jms.transports.TransportFactory;
import org.apache.qpid.jms.transports.TransportOptions;
import org.apache.qpid.jms.transports.netty.NettyTcpTransport;
import org.apache.qpid.jms.transports.netty.NettyWsTransport;
import org.apache.qpid.jms.util.PropertyUtil;

public class NettyWsTransportFactory
extends TransportFactory {
    @Override
    protected NettyTcpTransport doCreateTransport(URI remoteURI, TransportOptions transportOptions) throws Exception {
        return new NettyWsTransport(remoteURI, transportOptions, this.isSecure());
    }

    @Override
    public String getName() {
        return "WS";
    }

    @Override
    protected TransportOptions applyTransportConfiguration(TransportOptions transportOptions, Map<String, String> transportURIOptions) {
        Map<String, String> httpHeaders = PropertyUtil.filterProperties(transportURIOptions, "ws.httpHeader.");
        transportOptions.getHttpHeaders().putAll(httpHeaders);
        return super.applyTransportConfiguration(transportOptions, transportURIOptions);
    }
}

