/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.event.publisher.helper;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.kura.cloudconnection.CloudEndpoint;
import org.eclipse.kura.event.publisher.helper.CloudEndpointTrackerListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CloudEndpointServiceTracker
extends ServiceTracker<CloudEndpoint, CloudEndpoint> {
    private Set<CloudEndpointTrackerListener> listeners = new HashSet<CloudEndpointTrackerListener>();

    public CloudEndpointServiceTracker(BundleContext context, String endpointPid) throws InvalidSyntaxException {
        super(context, context.createFilter(String.format("(&(%s=%s)(%s=%s))", "objectClass", CloudEndpoint.class.getName(), "kura.service.pid", endpointPid)), null);
    }

    public void registerCloudStackTrackerListener(CloudEndpointTrackerListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterCloudStackTrackerListener(CloudEndpointTrackerListener listener) {
        this.listeners.remove(listener);
    }

    public CloudEndpoint addingService(ServiceReference<CloudEndpoint> reference) {
        CloudEndpoint endpoint = (CloudEndpoint)super.addingService(reference);
        for (CloudEndpointTrackerListener listener : this.listeners) {
            listener.onCloudEndpointAdded(endpoint);
        }
        return endpoint;
    }

    public void removedService(ServiceReference<CloudEndpoint> reference, CloudEndpoint service) {
        super.removedService(reference, (Object)service);
        for (CloudEndpointTrackerListener listener : this.listeners) {
            listener.onCloudEndpointRemoved(service);
        }
    }
}

