/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.status;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.kura.core.status.GpioLedManager;
import org.eclipse.kura.core.status.StatusNotificationTypeEnum;

public class CloudConnectionStatusURL {
    public static final String NOTIFICATION_TYPE = "notification_type";
    public static final String CCS = "ccs:";
    public static final String LED = "led:";
    public static final String LED_NAME_PREFIX = "name:";
    public static final String LED_TERMINAL_PREFIX = "terminal:";
    public static final String LINUX_LED = "linux_led:";
    public static final String LOG = "log";
    public static final String NONE = "none";
    public static final String INVERTED = ":inverted";
    private static final String CASE_INSENSITIVE_PREFIX = "(?i)";
    private static final String CCS_NOTIFICATION_URLS_SEPARATOR = ";";

    private CloudConnectionStatusURL() {
    }

    public static Properties parseURL(String ccsUrl) {
        Objects.requireNonNull(ccsUrl);
        String urlImage = ccsUrl;
        Properties props = new Properties();
        if (urlImage.toLowerCase(Locale.ENGLISH).startsWith(CCS)) {
            String[] urls;
            urlImage = urlImage.replaceAll("(?i)ccs:", "");
            props.put("url", ccsUrl);
            String[] stringArray = urls = urlImage.split(CCS_NOTIFICATION_URLS_SEPARATOR);
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                props.putAll((Map<?, ?>)CloudConnectionStatusURL.parseUrlType(url));
                ++n2;
            }
        } else {
            props.put(NOTIFICATION_TYPE, (Object)StatusNotificationTypeEnum.NONE);
        }
        return props;
    }

    private static Properties parseUrlType(String urlImage) {
        Properties props = new Properties();
        String urlLowerCase = urlImage.toLowerCase(Locale.ENGLISH);
        if (urlLowerCase.startsWith(LED)) {
            String ledString = urlImage.substring(4);
            try {
                boolean inverted = urlLowerCase.endsWith(INVERTED);
                if (inverted) {
                    ledString = ledString.substring(0, ledString.length() - INVERTED.length());
                }
                props.put("inverted", (Object)inverted);
                GpioLedManager.GpioIdentifier identifier = CloudConnectionStatusURL.parseLedIdentifier(ledString);
                props.put(NOTIFICATION_TYPE, (Object)StatusNotificationTypeEnum.LED);
                props.put("led", identifier);
            }
            catch (Exception exception) {}
        } else if (urlLowerCase.startsWith(LINUX_LED)) {
            String ledPath = urlImage.substring(LINUX_LED.length());
            props.put(NOTIFICATION_TYPE, (Object)StatusNotificationTypeEnum.LED);
            props.put("linux_led", ledPath);
        } else if (urlLowerCase.startsWith(LOG)) {
            props.put(NOTIFICATION_TYPE, (Object)StatusNotificationTypeEnum.LOG);
        } else if (urlLowerCase.startsWith(NONE)) {
            props.put(NOTIFICATION_TYPE, (Object)StatusNotificationTypeEnum.NONE);
        }
        return props;
    }

    private static GpioLedManager.GpioIdentifier parseLedIdentifier(String identifier) {
        if (identifier.toLowerCase().startsWith(LED_NAME_PREFIX)) {
            String name = identifier.substring(LED_NAME_PREFIX.length());
            if (!name.isEmpty()) {
                return new GpioLedManager.GpioName(name);
            }
        } else {
            String number = identifier.toLowerCase().startsWith(LED_TERMINAL_PREFIX) ? identifier.substring(LED_TERMINAL_PREFIX.length()) : identifier;
            return new GpioLedManager.GpioTerminal(Integer.parseInt(number.trim()));
        }
        throw new IllegalArgumentException("invalid GPIO identifier " + identifier);
    }
}

