/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import java.util.List;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class MinimizedFileSystemElement
extends FileSystemElement {
    private boolean populated = false;

    public MinimizedFileSystemElement(String name, FileSystemElement parent, boolean isDirectory) {
        super(name, parent, isDirectory);
    }

    public AdaptableList getFiles(IImportStructureProvider provider) {
        if (!this.populated) {
            this.populate(provider);
        }
        return super.getFiles();
    }

    public AdaptableList getFolders(IImportStructureProvider provider) {
        if (!this.populated) {
            this.populate(provider);
        }
        return super.getFolders();
    }

    public boolean isPopulated() {
        return this.populated;
    }

    private void populate(IImportStructureProvider provider) {
        Object fileSystemObject = this.getFileSystemObject();
        List children = provider.getChildren(fileSystemObject);
        if (children != null) {
            for (Object child : children) {
                String elementLabel = provider.getLabel(child);
                MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, this, provider.isFolder(child));
                result.setFileSystemObject(child);
            }
        }
        this.setPopulated();
    }

    public void setPopulated() {
        this.populated = true;
    }
}

