/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.StringConcatToTextBlockFixCore;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jface.text.BadLocationException;

public class ConvertToMessageFormatFixCore
extends CompilationUnitRewriteOperationsFixCore {
    static final Pattern comment = Pattern.compile("([ ]*\\/\\/\\$NON-NLS-[0-9]\\$) *$");

    public ConvertToMessageFormatFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    public static ConvertToMessageFormatFixCore createConvertToMessageFormatFix(CompilationUnit compilationUnit, ASTNode node) {
        BodyDeclaration parentDecl = ASTResolving.findParentBodyDeclaration(node);
        if (!(parentDecl instanceof MethodDeclaration) && !(parentDecl instanceof Initializer)) {
            return null;
        }
        AST ast = node.getAST();
        ITypeBinding stringBinding = ast.resolveWellKnownType("java.lang.String");
        if (node instanceof Expression && !(node instanceof InfixExpression)) {
            node = node.getParent();
        }
        if (node instanceof VariableDeclarationFragment) {
            node = ((VariableDeclarationFragment)node).getInitializer();
        } else if (node instanceof Assignment) {
            node = ((Assignment)node).getRightHandSide();
        }
        InfixExpression oldInfixExpression = null;
        while (node instanceof InfixExpression) {
            InfixExpression curr = (InfixExpression)node;
            if (curr.resolveTypeBinding() != stringBinding || curr.getOperator() != InfixExpression.Operator.PLUS) break;
            oldInfixExpression = curr;
            node = node.getParent();
        }
        if (oldInfixExpression == null) {
            return null;
        }
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(compilationUnit.getTypeRoot().getJavaProject());
        ArrayList<Expression> operands = new ArrayList<Expression>();
        ConvertToMessageFormatFixCore.collectInfixPlusOperands((Expression)oldInfixExpression, operands);
        boolean foundNoneLiteralOperand = false;
        boolean seenTag = false;
        boolean seenNoTag = false;
        block1: for (Expression operand : operands) {
            if (!(operand instanceof StringLiteral)) {
                ITypeBinding binding;
                if (!is50OrHigher && (binding = operand.resolveTypeBinding()) == null) {
                    return null;
                }
                foundNoneLiteralOperand = true;
                continue;
            }
            ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
            NLSLine nlsLine = ConvertToMessageFormatFixCore.scanCurrentLine(cu, operand);
            if (nlsLine == null) continue;
            NLSElement[] nLSElementArray = nlsLine.getElements();
            int n = nLSElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                NLSElement element = nLSElementArray[n2];
                if (element.getPosition().getOffset() == compilationUnit.getColumnNumber(operand.getStartPosition())) {
                    if (element.hasTag()) {
                        if (seenNoTag) {
                            return null;
                        }
                        seenTag = true;
                        continue block1;
                    }
                    if (seenTag) {
                        return null;
                    }
                    seenNoTag = true;
                    continue block1;
                }
                ++n2;
            }
        }
        if (!foundNoneLiteralOperand) {
            return null;
        }
        return new ConvertToMessageFormatFixCore(CorrectionMessages.QuickAssistProcessor_convert_to_message_format, compilationUnit, new ConvertToMessageFormatProposalOperation(oldInfixExpression));
    }

    private static NLSLine scanCurrentLine(ICompilationUnit cu, Expression exp) {
        CompilationUnit cUnit = (CompilationUnit)exp.getRoot();
        int startLine = cUnit.getLineNumber(exp.getStartPosition());
        int startLinePos = cUnit.getPosition(startLine, 0);
        int endOfLine = cUnit.getPosition(startLine + 1, 0);
        try {
            NLSLine[] lines = NLSScanner.scan(cu.getBuffer().getText(startLinePos, endOfLine - startLinePos));
            if (lines.length > 0) {
                return lines[0];
            }
        }
        catch (IndexOutOfBoundsException | JavaModelException | InvalidInputException | BadLocationException throwable) {
            // empty catch block
        }
        return null;
    }

    private static String indentOf(ICompilationUnit cu, Expression exp) {
        CompilationUnit cUnit = (CompilationUnit)exp.getRoot();
        int startLine = cUnit.getLineNumber(exp.getStartPosition());
        int startLinePos = cUnit.getPosition(startLine, 0);
        int endOfLine = cUnit.getPosition(startLine + 1, 0);
        Object indent = "";
        try {
            IBuffer buffer = cu.getBuffer();
            String line = buffer.getText(startLinePos, endOfLine - startLinePos);
            int i = 0;
            while (i < line.length()) {
                char ch = line.charAt(i);
                if (Character.isSpaceChar(ch)) {
                    indent = (String)indent + ch;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return indent;
    }

    private static void collectInfixPlusOperands(Expression expression, List<Expression> collector) {
        if (expression instanceof InfixExpression && ((InfixExpression)expression).getOperator() == InfixExpression.Operator.PLUS) {
            InfixExpression infixExpression = (InfixExpression)expression;
            ConvertToMessageFormatFixCore.collectInfixPlusOperands(infixExpression.getLeftOperand(), collector);
            ConvertToMessageFormatFixCore.collectInfixPlusOperands(infixExpression.getRightOperand(), collector);
            List extendedOperands = infixExpression.extendedOperands();
            for (Expression expression2 : extendedOperands) {
                ConvertToMessageFormatFixCore.collectInfixPlusOperands(expression2, collector);
            }
        } else {
            collector.add(expression);
        }
    }

    private static class ConvertToMessageFormatProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private InfixExpression infixExpression;

        public ConvertToMessageFormatProposalOperation(InfixExpression infixExpression) {
            this.infixExpression = infixExpression;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            int allEmpty;
            boolean isLessThanThreeLines;
            Expression firstArgumentExpression;
            Expression firstStringLiteral;
            ArrayList<Object> fLiterals = new ArrayList<Object>();
            String fIndent = "";
            ICompilationUnit cu = cuRewrite.getCu();
            boolean is50OrHigher = JavaModelUtil.is50OrHigher(cu.getJavaProject());
            boolean is15OrHigher = JavaModelUtil.is15OrHigher(cu.getJavaProject());
            AST fAst = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            CompilationUnit root = cuRewrite.getRoot();
            String cuContents = cuRewrite.getCu().getBuffer().getContents();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(root, this.infixExpression.getStartPosition(), importRewrite);
            ArrayList<Expression> operands = new ArrayList<Expression>();
            ConvertToMessageFormatFixCore.collectInfixPlusOperands((Expression)this.infixExpression, operands);
            ArrayList<String> formatArguments = new ArrayList<String>();
            StringBuilder formatString = new StringBuilder();
            int i = 0;
            int tagsCount = 0;
            boolean isFirstStringLiteral = true;
            boolean isFirstArgument = true;
            Expression lastStringLiteral = firstStringLiteral = (Expression)operands.get(0);
            Expression lastArgumentExpression = firstArgumentExpression = (Expression)operands.get(0);
            int totalSize = 0;
            for (Expression operand : operands) {
                Object argument;
                if (operand instanceof StringLiteral) {
                    if (isFirstStringLiteral) {
                        fIndent = ConvertToMessageFormatFixCore.indentOf(cu, operand);
                        isFirstStringLiteral = false;
                        firstStringLiteral = operand;
                    }
                    lastStringLiteral = operand;
                    NLSLine nlsLine = ConvertToMessageFormatFixCore.scanCurrentLine(cu, operand);
                    if (nlsLine != null) {
                        NLSElement[] nLSElementArray = nlsLine.getElements();
                        int n = nLSElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            NLSElement element = nLSElementArray[n2];
                            if (element.getPosition().getOffset() == root.getColumnNumber(operand.getStartPosition()) && element.hasTag()) {
                                ++tagsCount;
                            }
                            ++n2;
                        }
                    }
                    String value = ((StringLiteral)operand).getEscapedValue();
                    totalSize += value.length();
                    value = value.replace("'", "''");
                    value = value.replace("{", "'{'");
                    value = value.replace("}", "'}'");
                    value = value.replace("'{''}'", "'{}'");
                    fLiterals.add(value);
                    value = value.substring(1, value.length() - 1);
                    formatString.append(value);
                    continue;
                }
                if (isFirstArgument) {
                    firstArgumentExpression = operand;
                    isFirstArgument = false;
                }
                lastArgumentExpression = operand;
                fLiterals.add("\"{" + Integer.toString(i) + "}\"");
                formatString.append("{").append(i).append("}");
                if (is50OrHigher) {
                    int origStart = root.getExtendedStartPosition((ASTNode)operand);
                    int origLength = root.getExtendedLength((ASTNode)operand);
                    argument = cuContents.substring(origStart, origStart + origLength);
                } else {
                    ITypeBinding boxedBinding;
                    ITypeBinding binding = operand.resolveTypeBinding();
                    int origStart = root.getExtendedStartPosition((ASTNode)operand);
                    int origLength = root.getExtendedLength((ASTNode)operand);
                    argument = cuContents.substring(origStart, origStart + origLength);
                    if (binding.isPrimitive() && (boxedBinding = Bindings.getBoxedTypeBinding(binding, fAst)) != binding) {
                        importRewrite.addImport(boxedBinding, fAst, (ImportRewrite.ImportRewriteContext)importContext);
                        String cic = "new " + boxedBinding.getName() + "(" + (String)argument + ")";
                        argument = cic;
                    }
                }
                formatArguments.add((String)argument);
                ++i;
            }
            importRewrite.addImport("java.text.MessageFormat", (ImportRewrite.ImportRewriteContext)importContext);
            StringBuilder buffer = new StringBuilder();
            buffer.append("MessageFormat.format(");
            int minOffset = firstStringLiteral.getStartPosition() < firstArgumentExpression.getStartPosition() ? firstStringLiteral.getStartPosition() : firstArgumentExpression.getStartPosition();
            int maxOffset = lastStringLiteral.getStartPosition() > lastArgumentExpression.getStartPosition() ? lastStringLiteral.getStartPosition() + lastStringLiteral.getLength() : lastArgumentExpression.getStartPosition() + lastArgumentExpression.getLength();
            boolean bl = isLessThanThreeLines = root.getLineNumber(maxOffset) - root.getLineNumber(minOffset) < 2;
            if (is15OrHigher && !isLessThanThreeLines && totalSize > 80) {
                StringBuilder buf = new StringBuilder();
                ArrayList parts = new ArrayList();
                fLiterals.stream().forEach(t -> parts.addAll(StringConcatToTextBlockFixCore.unescapeBlock(t.substring(1, t.length() - 1))));
                buf.append("\"\"\"\n");
                boolean newLine = false;
                boolean allWhiteSpaceStart = true;
                allEmpty = 1;
                for (String part : parts) {
                    if (buf.length() > 4 && !newLine) {
                        buf.append("\\").append(System.lineSeparator());
                    }
                    newLine = part.endsWith(System.lineSeparator());
                    allWhiteSpaceStart = allWhiteSpaceStart && (part.isEmpty() || Character.isWhitespace(part.charAt(0)));
                    allEmpty = allEmpty != 0 && part.isEmpty() ? 1 : 0;
                    buf.append(fIndent).append(part);
                }
                if (newLine || allEmpty != 0) {
                    buf.append(fIndent);
                } else if (allWhiteSpaceStart) {
                    buf.append("\\").append(System.lineSeparator());
                    buf.append(fIndent);
                } else {
                    int readIndex = buf.length() - 1;
                    int count = 0;
                    while (readIndex >= 0 && buf.charAt(readIndex) == '\"' && count <= 3) {
                        --readIndex;
                        ++count;
                    }
                    if (readIndex >= 0 && buf.charAt(readIndex) == '\\') {
                        --count;
                    }
                    int i1 = count;
                    while (i1 > 0) {
                        buf.deleteCharAt(buf.length() - 1);
                        --i1;
                    }
                    i1 = count;
                    while (i1 > 0) {
                        buf.append("\\\"");
                        --i1;
                    }
                }
                buf.append("\"\"\"");
                buffer.append(buf.toString());
            } else {
                buffer.append("\"" + formatString.toString().replaceAll("\"", "\\\"") + "\"");
            }
            if (is50OrHigher) {
                for (String formatArgument : formatArguments) {
                    buffer.append(", " + formatArgument);
                }
            } else {
                buffer.append(", new Object[]{");
                if (formatArguments.size() > 0) {
                    buffer.append((String)formatArguments.get(0));
                }
                int i1 = 1;
                while (i1 < formatArguments.size()) {
                    buffer.append(", " + (String)formatArguments.get(i1));
                    ++i1;
                }
                buffer.append("}");
            }
            buffer.append(")");
            if (tagsCount > 1) {
                if (is15OrHigher) {
                    Expression lastOperand = (Expression)operands.get(operands.size() - 1);
                    NLSLine nlsLine = ConvertToMessageFormatFixCore.scanCurrentLine(cu, lastOperand);
                    tagsCount = 0;
                    if (nlsLine != null) {
                        NLSElement[] readIndex = nlsLine.getElements();
                        allEmpty = readIndex.length;
                        int allWhiteSpaceStart = 0;
                        while (allWhiteSpaceStart < allEmpty) {
                            NLSElement element = readIndex[allWhiteSpaceStart];
                            if (element.hasTag()) {
                                ++tagsCount;
                            }
                            ++allWhiteSpaceStart;
                        }
                    }
                    if (!(lastOperand instanceof StringLiteral) || tagsCount > 1) {
                        Statement statement = ASTNodes.getFirstAncestorOrNull((ASTNode)this.infixExpression, Statement.class);
                        if (statement == null) {
                            return;
                        }
                        CompilationUnit cUnit = (CompilationUnit)this.infixExpression.getRoot();
                        int extendedStart = cUnit.getExtendedStartPosition((ASTNode)statement);
                        int extendedLength = cUnit.getExtendedLength((ASTNode)statement);
                        String completeStatement = cu.getBuffer().getText(extendedStart, extendedLength);
                        if (tagsCount > 1) {
                            Matcher commentMatcher = comment.matcher(completeStatement);
                            while (tagsCount-- > 0) {
                                completeStatement = commentMatcher.replaceFirst("");
                                commentMatcher = comment.matcher(completeStatement);
                            }
                            extendedLength = completeStatement.length();
                        }
                        StringBuilder newBuffer = new StringBuilder();
                        newBuffer = newBuffer.append(completeStatement.substring(0, this.infixExpression.getStartPosition() - extendedStart));
                        newBuffer = newBuffer.append(buffer.toString());
                        int infixExpressionEnd = this.infixExpression.getStartPosition() + this.infixExpression.getLength();
                        newBuffer = newBuffer.append(cu.getBuffer().getText(infixExpressionEnd, extendedStart + extendedLength - infixExpressionEnd));
                        newBuffer = newBuffer.append(" //$NON-NLS-1$");
                        Statement newStatement = (Statement)rewrite.createStringPlaceholder(newBuffer.toString(), statement.getNodeType());
                        rewrite.replace((ASTNode)statement, (ASTNode)newStatement, null);
                    } else {
                        MethodInvocation formatInvocation = (MethodInvocation)rewrite.createStringPlaceholder(buffer.toString(), 32);
                        rewrite.replace((ASTNode)this.infixExpression, (ASTNode)formatInvocation, null);
                    }
                } else {
                    ASTNodes.replaceAndRemoveNLSByCount(rewrite, (ASTNode)this.infixExpression, buffer.toString(), tagsCount - 1, null, cuRewrite);
                }
            } else {
                MethodInvocation formatInvocation = (MethodInvocation)rewrite.createStringPlaceholder(buffer.toString(), 32);
                rewrite.replace((ASTNode)this.infixExpression, (ASTNode)formatInvocation, null);
            }
        }
    }
}

