/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.string;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractPolyOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.SequenceValue;

public class StringTokenizeOperation
extends AbstractPolyOperation {
    public static final @NonNull StringTokenizeOperation INSTANCE = new StringTokenizeOperation();
    private static final @NonNull String DELIMS = " \t\n\r\f";

    @Override
    public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        String delims = DELIMS;
        boolean returnDelims = false;
        TypeId typeId = callExp.getTypeId();
        List<OCLExpression> arguments = callExp.getOwnedArguments();
        if (arguments.size() > 0) {
            if (arguments.size() > 1) {
                if (arguments.size() > 2) {
                    throw new InvalidValueException(PivotMessages.InvalidArgument, arguments.get(2));
                }
                OCLExpression argument1 = arguments.get(1);
                assert (argument1 != null);
                Object secondArgument = executor.evaluate(argument1);
                returnDelims = StringTokenizeOperation.asBoolean(secondArgument);
            }
            OCLExpression argument0 = arguments.get(0);
            assert (argument0 != null);
            Object firstArgument = executor.evaluate(argument0);
            delims = StringTokenizeOperation.asString(firstArgument);
        }
        return this.evaluate(executor, (CollectionTypeId)typeId, sourceValue, delims, returnDelims);
    }

    @Override
    @Deprecated
    public @Nullable SequenceValue evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        return this.evaluate(StringTokenizeOperation.getExecutor(evaluator), returnTypeId, sourceValue);
    }

    @Override
    public @NonNull SequenceValue evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        return this.evaluate(executor, (CollectionTypeId)returnTypeId, sourceValue, DELIMS, false);
    }

    @Override
    @Deprecated
    public @Nullable SequenceValue evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object argumentValue) {
        return this.evaluate(StringTokenizeOperation.getExecutor(evaluator), returnTypeId, sourceValue, argumentValue);
    }

    @Override
    public @NonNull SequenceValue evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object argumentValue) {
        String delims = StringTokenizeOperation.asString(argumentValue);
        return this.evaluate(executor, (CollectionTypeId)returnTypeId, sourceValue, delims, false);
    }

    @Override
    @Deprecated
    public @Nullable SequenceValue evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        return this.evaluate(StringTokenizeOperation.getExecutor(evaluator), returnTypeId, sourceValue, firstArgumentValue, secondArgumentValue);
    }

    @Override
    public @NonNull SequenceValue evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        String delims = StringTokenizeOperation.asString(firstArgumentValue);
        boolean returnDelims = StringTokenizeOperation.asBoolean(secondArgumentValue);
        return this.evaluate(executor, (CollectionTypeId)returnTypeId, sourceValue, delims, returnDelims);
    }

    private @NonNull SequenceValue evaluate(@NonNull Executor executor, @NonNull CollectionTypeId returnTypeId, @Nullable Object sourceValue, @NonNull String delims, boolean returnDelims) {
        String sourceString = StringTokenizeOperation.asString(sourceValue);
        StringTokenizer tokenizer = new StringTokenizer(sourceString, delims, returnDelims);
        ArrayList<String> results = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            @NonNull String nextToken = tokenizer.nextToken();
            results.add(nextToken);
        }
        return StringTokenizeOperation.createSequenceValue(returnTypeId, results);
    }

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypedElement caller, @Nullable Object @NonNull [] boxedSourceAndArgumentValues) {
        return this.cachedEvaluate(executor, caller, boxedSourceAndArgumentValues);
    }

    @Override
    public @Nullable Object basicEvaluate(@NonNull Executor executor, @NonNull TypedElement caller, @Nullable Object @NonNull [] sourceAndArgumentValues) {
        String delims = DELIMS;
        boolean returnDelims = false;
        if (sourceAndArgumentValues.length > 1) {
            if (sourceAndArgumentValues.length > 2) {
                if (sourceAndArgumentValues.length > 3) {
                    throw new InvalidValueException(PivotMessages.InvalidArgument, sourceAndArgumentValues[3]);
                }
                Object argument1 = sourceAndArgumentValues[2];
                returnDelims = StringTokenizeOperation.asBoolean(argument1);
            }
            Object argument0 = sourceAndArgumentValues[1];
            delims = StringTokenizeOperation.asString(argument0);
        }
        return this.evaluate(executor, (CollectionTypeId)ClassUtil.nonNullPivot(caller.getTypeId()), sourceAndArgumentValues[0], delims, returnDelims);
    }
}

