/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.types;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.Type;

public class TemplateParametersImpl
implements TemplateParameters {
    private final @NonNull Type @NonNull [] typeParameters;
    private final int hashCode;

    public TemplateParametersImpl(TemplateParameter ... typeParameters) {
        this.typeParameters = new Type[typeParameters.length];
        int hash = 0;
        int i = 0;
        while (i < typeParameters.length) {
            TemplateParameter parameter = typeParameters[i];
            hash = 111 * hash + parameter.hashCode();
            this.typeParameters[i] = parameter;
            ++i;
        }
        this.hashCode = hash;
    }

    public TemplateParametersImpl(@NonNull List<@NonNull ? extends Type> parameters) {
        this.typeParameters = new Type[parameters.size()];
        int hash = 0;
        int i = 0;
        while (i < this.typeParameters.length) {
            Type parameter = parameters.get(i);
            hash = 111 * hash + parameter.hashCode();
            this.typeParameters[i] = parameter;
            ++i;
        }
        this.hashCode = hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TemplateParametersImpl)) {
            return false;
        }
        TemplateParametersImpl that = (TemplateParametersImpl)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        int iMax = this.typeParameters.length;
        if (iMax != that.typeParameters.length) {
            return false;
        }
        int i = 0;
        while (i < iMax) {
            Type thisParameter = this.typeParameters[i];
            Type thatParameter = that.typeParameters[i];
            if (!thisParameter.equals(thatParameter)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public @NonNull Type get(int i) {
        return this.typeParameters[i];
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int parametersSize() {
        return this.typeParameters.length;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('(');
        int i = 0;
        while (i < this.typeParameters.length) {
            if (i > 0) {
                s.append(',');
            }
            s.append(String.valueOf(this.typeParameters[i]));
            ++i;
        }
        s.append(')');
        return s.toString();
    }
}

