/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.lsat.common.graph.directed.Aspect;
import org.eclipse.lsat.common.graph.directed.DirectedGraphFactory;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.schedule.Schedule;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriticalPathAnalysis<T extends Task> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CriticalPathAnalysis.class);
    private static final BigDecimal EPSILON = new BigDecimal("1e-10");
    public static final String CRITICAL = "Critical";

    public Schedule<T> transformModel(Schedule<T> input, IProgressMonitor monitor) {
        PathStatistics cp;
        LOGGER.trace("Starting critical path analysis");
        EList tasks = input.allNodesInTopologicalOrder();
        LinkedHashMap stats = new LinkedHashMap();
        tasks.forEach(task -> {
            PathStatistics pathStatistics = stats.put(task, new PathStatistics());
        });
        for (Map.Entry entry : stats.entrySet()) {
            ScheduledTask t = (ScheduledTask)entry.getKey();
            cp = (PathStatistics)entry.getValue();
            BigDecimal resourceStart = t.getSequence().getResource().getStart();
            cp.sMin = t.getIncomingEdges().stream().map(e -> (ScheduledTask)e.getSourceNode()).map(sourceNode -> ((PathStatistics)linkedHashMap.get((Object)sourceNode)).sMin.add(sourceNode.getDuration())).reduce(BigDecimal::max).orElse(resourceStart);
        }
        BigDecimal virtualEndStartTime = tasks.stream().map(ScheduledTask::getEndTime).reduce(BigDecimal::max).orElse(BigDecimal.ZERO);
        for (ScheduledTask t : tasks.reversed()) {
            cp = (PathStatistics)stats.get(t);
            BigDecimal endFirst = t.getOutgoingEdges().stream().map(e -> (ScheduledTask)e.getTargetNode()).map(targetNode -> ((PathStatistics)linkedHashMap.get((Object)targetNode)).sMax).reduce(BigDecimal::min).orElse(virtualEndStartTime);
            cp.sMax = endFirst.subtract(t.getDuration());
        }
        List<ScheduledTask> criticalPathTasks = stats.entrySet().stream().filter(e -> CriticalPathAnalysis.almostEqual(((PathStatistics)e.getValue()).sMin, ((PathStatistics)e.getValue()).sMax)).map(Map.Entry::getKey).toList();
        Aspect criticalAspect = DirectedGraphFactory.eINSTANCE.createAspect();
        criticalAspect.setName(CRITICAL);
        criticalAspect.getNodes().addAll(criticalPathTasks);
        input.getAspects().add((Object)criticalAspect);
        input.getEdges().forEach(e -> {
            LinkedHashSet edgeAspects = new LinkedHashSet(e.getSourceNode().getAspects());
            edgeAspects.retainAll((Collection<?>)e.getTargetNode().getAspects());
            e.getAspects().addAll(edgeAspects);
        });
        LOGGER.trace("Finished critical path analysis");
        return input;
    }

    public static boolean almostEqual(BigDecimal a, BigDecimal b) {
        return a.subtract(b).abs().compareTo(EPSILON) < 0;
    }

    private static class PathStatistics {
        BigDecimal sMin;
        BigDecimal sMax;

        private PathStatistics() {
        }
    }
}

