/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.view;

import activity.Move;
import distributions.Distribution;
import expressions.Declaration;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsat.timing.view.DistributionViewJob;
import org.eclipse.lsat.timing.view.MotionViewJob;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class XYPlotViewXtextHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject context = this.getContext();
        if (context instanceof Declaration) {
            Declaration d = (Declaration)context;
            context = d.getExpression();
        }
        if (!(context instanceof Move) && !(context instanceof Distribution)) {
            return null;
        }
        if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
            return null;
        }
        Job job = context instanceof Move ? new MotionViewJob((Move)context) : new DistributionViewJob((Distribution)context);
        job.setUser(true);
        job.schedule();
        return null;
    }

    private EObject getContext() {
        XtextEditor xtextEditor = EditorUtils.getActiveXtextEditor();
        ISelection selection = xtextEditor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            final int offset = ((ITextSelection)selection).getOffset();
            return (EObject)xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<EObject, XtextResource>(){

                public EObject exec(XtextResource state) throws Exception {
                    return new EObjectAtOffsetHelper().resolveElementAt(state, offset);
                }
            });
        }
        return null;
    }
}

