/**
 */
package distributions;

import distributions.math.ModeDistribution;

import expressions.Expression;

import java.math.BigDecimal;

import org.apache.commons.math3.random.RandomGenerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Pert Distribution</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link distributions.PertDistribution#getMode <em>Mode</em>}</li>
 *   <li>{@link distributions.PertDistribution#getMin <em>Min</em>}</li>
 *   <li>{@link distributions.PertDistribution#getMax <em>Max</em>}</li>
 *   <li>{@link distributions.PertDistribution#getModeExp <em>Mode Exp</em>}</li>
 *   <li>{@link distributions.PertDistribution#getMinExp <em>Min Exp</em>}</li>
 *   <li>{@link distributions.PertDistribution#getMaxExp <em>Max Exp</em>}</li>
 *   <li>{@link distributions.PertDistribution#getGamma <em>Gamma</em>}</li>
 *   <li>{@link distributions.PertDistribution#getGammaExp <em>Gamma Exp</em>}</li>
 * </ul>
 *
 * @see distributions.DistributionsPackage#getPertDistribution()
 * @model
 * @generated
 */
public interface PertDistribution extends Distribution
{
    /**
     * Returns the value of the '<em><b>Mode</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Mode</em>' attribute.
     * @see distributions.DistributionsPackage#getPertDistribution_Mode()
     * @model transient="true" changeable="false" volatile="true" derived="true"
     * @generated
     */
    BigDecimal getMode();

    /**
     * Returns the value of the '<em><b>Min</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Min</em>' attribute.
     * @see distributions.DistributionsPackage#getPertDistribution_Min()
     * @model transient="true" changeable="false" volatile="true" derived="true"
     * @generated
     */
    BigDecimal getMin();

    /**
     * Returns the value of the '<em><b>Max</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Max</em>' attribute.
     * @see distributions.DistributionsPackage#getPertDistribution_Max()
     * @model transient="true" changeable="false" volatile="true" derived="true"
     * @generated
     */
    BigDecimal getMax();

    /**
     * Returns the value of the '<em><b>Mode Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Mode Exp</em>' containment reference.
     * @see #setModeExp(Expression)
     * @see distributions.DistributionsPackage#getPertDistribution_ModeExp()
     * @model containment="true" required="true"
     * @generated
     */
    Expression getModeExp();

    /**
     * Sets the value of the '{@link distributions.PertDistribution#getModeExp <em>Mode Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Mode Exp</em>' containment reference.
     * @see #getModeExp()
     * @generated
     */
    void setModeExp(Expression value);

    /**
     * Returns the value of the '<em><b>Min Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Min Exp</em>' containment reference.
     * @see #setMinExp(Expression)
     * @see distributions.DistributionsPackage#getPertDistribution_MinExp()
     * @model containment="true" required="true"
     * @generated
     */
    Expression getMinExp();

    /**
     * Sets the value of the '{@link distributions.PertDistribution#getMinExp <em>Min Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Min Exp</em>' containment reference.
     * @see #getMinExp()
     * @generated
     */
    void setMinExp(Expression value);

    /**
     * Returns the value of the '<em><b>Max Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Max Exp</em>' containment reference.
     * @see #setMaxExp(Expression)
     * @see distributions.DistributionsPackage#getPertDistribution_MaxExp()
     * @model containment="true" required="true"
     * @generated
     */
    Expression getMaxExp();

    /**
     * Sets the value of the '{@link distributions.PertDistribution#getMaxExp <em>Max Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Max Exp</em>' containment reference.
     * @see #getMaxExp()
     * @generated
     */
    void setMaxExp(Expression value);

    /**
     * Returns the value of the '<em><b>Gamma</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Gamma</em>' attribute.
     * @see distributions.DistributionsPackage#getPertDistribution_Gamma()
     * @model transient="true" changeable="false" volatile="true" derived="true"
     * @generated
     */
    BigDecimal getGamma();

    /**
     * Returns the value of the '<em><b>Gamma Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Gamma Exp</em>' containment reference.
     * @see #setGammaExp(Expression)
     * @see distributions.DistributionsPackage#getPertDistribution_GammaExp()
     * @model containment="true" required="true"
     * @generated
     */
    Expression getGammaExp();

    /**
     * Sets the value of the '{@link distributions.PertDistribution#getGammaExp <em>Gamma Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Gamma Exp</em>' containment reference.
     * @see #getGammaExp()
     * @generated
     */
    void setGammaExp(Expression value);

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @model dataType="distributions.ModeDistribution" required="true" generatorDataType="distributions.RandomGenerator"
     * @generated
     */
    ModeDistribution createModeDistribution(RandomGenerator generator);

} // PertDistribution
