/**
 */
package product;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see product.ProductFactory
 * @model kind="package"
 * @generated
 */
public interface ProductPackage extends EPackage
{
    /**
     * The package name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNAME = "product";

    /**
     * The package namespace URI.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_URI = "http://www.eclipse.org/lsat/product";

    /**
     * The package namespace name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_PREFIX = "product";

    /**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    ProductPackage eINSTANCE = product.impl.ProductPackageImpl.init();

    /**
     * The meta object id for the '{@link product.IProductDefinition <em>IProduct Definition</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see product.IProductDefinition
     * @see product.impl.ProductPackageImpl#getIProductDefinition()
     * @generated
     */
    int IPRODUCT_DEFINITION = 7;

    /**
     * The number of structural features of the '<em>IProduct Definition</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IPRODUCT_DEFINITION_FEATURE_COUNT = 0;

    /**
     * The operation id for the '<em>Get Property Definitions</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IPRODUCT_DEFINITION___GET_PROPERTY_DEFINITIONS = 0;

    /**
     * The operation id for the '<em>Get Name</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IPRODUCT_DEFINITION___GET_NAME = 1;

    /**
     * The number of operations of the '<em>IProduct Definition</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IPRODUCT_DEFINITION_OPERATION_COUNT = 2;

    /**
     * The meta object id for the '{@link product.impl.ProductDefinitionImpl <em>Definition</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see product.impl.ProductDefinitionImpl
     * @see product.impl.ProductPackageImpl#getProductDefinition()
     * @generated
     */
    int PRODUCT_DEFINITION = 0;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRODUCT_DEFINITION__NAME = IPRODUCT_DEFINITION_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Property Definitions</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRODUCT_DEFINITION__PROPERTY_DEFINITIONS = IPRODUCT_DEFINITION_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Definition</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRODUCT_DEFINITION_FEATURE_COUNT = IPRODUCT_DEFINITION_FEATURE_COUNT + 2;

    /**
     * The operation id for the '<em>Get Property Definitions</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRODUCT_DEFINITION___GET_PROPERTY_DEFINITIONS = IPRODUCT_DEFINITION___GET_PROPERTY_DEFINITIONS;

    /**
     * The operation id for the '<em>Get Name</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRODUCT_DEFINITION___GET_NAME = IPRODUCT_DEFINITION___GET_NAME;

    /**
     * The operation id for the '<em>Fqn</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRODUCT_DEFINITION___FQN = IPRODUCT_DEFINITION_OPERATION_COUNT + 0;

    /**
     * The number of operations of the '<em>Definition</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRODUCT_DEFINITION_OPERATION_COUNT = IPRODUCT_DEFINITION_OPERATION_COUNT + 1;

    /**
     * The meta object id for the '{@link product.impl.PropertyDefinitionImpl <em>Property Definition</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see product.impl.PropertyDefinitionImpl
     * @see product.impl.ProductPackageImpl#getPropertyDefinition()
     * @generated
     */
    int PROPERTY_DEFINITION = 1;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PROPERTY_DEFINITION__NAME = 0;

    /**
     * The feature id for the '<em><b>Value Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PROPERTY_DEFINITION__VALUE_TYPE = 1;

    /**
     * The number of structural features of the '<em>Property Definition</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PROPERTY_DEFINITION_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Property Definition</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PROPERTY_DEFINITION_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link product.impl.PropertyImpl <em>Property</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see product.impl.PropertyImpl
     * @see product.impl.ProductPackageImpl#getProperty()
     * @generated
     */
    int PROPERTY = 2;

    /**
     * The feature id for the '<em><b>Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PROPERTY__VALUE = 0;

    /**
     * The feature id for the '<em><b>Definition</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PROPERTY__DEFINITION = 1;

    /**
     * The number of structural features of the '<em>Property</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PROPERTY_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Property</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PROPERTY_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link product.ProductValue <em>Value</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see product.ProductValue
     * @see product.impl.ProductPackageImpl#getProductValue()
     * @generated
     */
    int PRODUCT_VALUE = 3;

    /**
     * The number of structural features of the '<em>Value</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRODUCT_VALUE_FEATURE_COUNT = 0;

    /**
     * The operation id for the '<em>Is Equal Type</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRODUCT_VALUE___IS_EQUAL_TYPE__VALUETYPE = 0;

    /**
     * The operation id for the '<em>Get Value As Serializable</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRODUCT_VALUE___GET_VALUE_AS_SERIALIZABLE = 1;

    /**
     * The number of operations of the '<em>Value</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRODUCT_VALUE_OPERATION_COUNT = 2;

    /**
     * The meta object id for the '{@link product.impl.StringValueImpl <em>String Value</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see product.impl.StringValueImpl
     * @see product.impl.ProductPackageImpl#getStringValue()
     * @generated
     */
    int STRING_VALUE = 4;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int STRING_VALUE__VALUE = PRODUCT_VALUE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>String Value</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int STRING_VALUE_FEATURE_COUNT = PRODUCT_VALUE_FEATURE_COUNT + 1;

    /**
     * The operation id for the '<em>Get Value As Serializable</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int STRING_VALUE___GET_VALUE_AS_SERIALIZABLE = PRODUCT_VALUE___GET_VALUE_AS_SERIALIZABLE;

    /**
     * The operation id for the '<em>Is Equal Type</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int STRING_VALUE___IS_EQUAL_TYPE__VALUETYPE = PRODUCT_VALUE_OPERATION_COUNT + 0;

    /**
     * The number of operations of the '<em>String Value</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int STRING_VALUE_OPERATION_COUNT = PRODUCT_VALUE_OPERATION_COUNT + 1;

    /**
     * The meta object id for the '{@link product.impl.BooleanValueImpl <em>Boolean Value</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see product.impl.BooleanValueImpl
     * @see product.impl.ProductPackageImpl#getBooleanValue()
     * @generated
     */
    int BOOLEAN_VALUE = 5;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_VALUE__VALUE = PRODUCT_VALUE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Boolean Value</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_VALUE_FEATURE_COUNT = PRODUCT_VALUE_FEATURE_COUNT + 1;

    /**
     * The operation id for the '<em>Get Value As Serializable</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_VALUE___GET_VALUE_AS_SERIALIZABLE = PRODUCT_VALUE___GET_VALUE_AS_SERIALIZABLE;

    /**
     * The operation id for the '<em>Is Equal Type</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_VALUE___IS_EQUAL_TYPE__VALUETYPE = PRODUCT_VALUE_OPERATION_COUNT + 0;

    /**
     * The number of operations of the '<em>Boolean Value</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_VALUE_OPERATION_COUNT = PRODUCT_VALUE_OPERATION_COUNT + 1;

    /**
     * The meta object id for the '{@link product.impl.IntegerValueImpl <em>Integer Value</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see product.impl.IntegerValueImpl
     * @see product.impl.ProductPackageImpl#getIntegerValue()
     * @generated
     */
    int INTEGER_VALUE = 6;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INTEGER_VALUE__VALUE = PRODUCT_VALUE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Integer Value</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INTEGER_VALUE_FEATURE_COUNT = PRODUCT_VALUE_FEATURE_COUNT + 1;

    /**
     * The operation id for the '<em>Get Value As Serializable</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INTEGER_VALUE___GET_VALUE_AS_SERIALIZABLE = PRODUCT_VALUE___GET_VALUE_AS_SERIALIZABLE;

    /**
     * The operation id for the '<em>Is Equal Type</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INTEGER_VALUE___IS_EQUAL_TYPE__VALUETYPE = PRODUCT_VALUE_OPERATION_COUNT + 0;

    /**
     * The number of operations of the '<em>Integer Value</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INTEGER_VALUE_OPERATION_COUNT = PRODUCT_VALUE_OPERATION_COUNT + 1;

    /**
     * The meta object id for the '{@link product.ValueType <em>Value Type</em>}' enum.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see product.ValueType
     * @see product.impl.ProductPackageImpl#getValueType()
     * @generated
     */
    int VALUE_TYPE = 8;

    /**
     * The meta object id for the '{@link product.TransferType <em>Transfer Type</em>}' enum.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see product.TransferType
     * @see product.impl.ProductPackageImpl#getTransferType()
     * @generated
     */
    int TRANSFER_TYPE = 9;


    /**
     * The meta object id for the '<em>Serializable</em>' data type.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see java.io.Serializable
     * @see product.impl.ProductPackageImpl#getSerializable()
     * @generated
     */
    int SERIALIZABLE = 10;


    /**
     * Returns the meta object for class '{@link product.ProductDefinition <em>Definition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Definition</em>'.
     * @see product.ProductDefinition
     * @generated
     */
    EClass getProductDefinition();

    /**
     * Returns the meta object for the containment reference list '{@link product.ProductDefinition#getPropertyDefinitions <em>Property Definitions</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Property Definitions</em>'.
     * @see product.ProductDefinition#getPropertyDefinitions()
     * @see #getProductDefinition()
     * @generated
     */
    EReference getProductDefinition_PropertyDefinitions();

    /**
     * Returns the meta object for class '{@link product.PropertyDefinition <em>Property Definition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Property Definition</em>'.
     * @see product.PropertyDefinition
     * @generated
     */
    EClass getPropertyDefinition();

    /**
     * Returns the meta object for the attribute '{@link product.PropertyDefinition#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Name</em>'.
     * @see product.PropertyDefinition#getName()
     * @see #getPropertyDefinition()
     * @generated
     */
    EAttribute getPropertyDefinition_Name();

    /**
     * Returns the meta object for the attribute '{@link product.PropertyDefinition#getValueType <em>Value Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Value Type</em>'.
     * @see product.PropertyDefinition#getValueType()
     * @see #getPropertyDefinition()
     * @generated
     */
    EAttribute getPropertyDefinition_ValueType();

    /**
     * Returns the meta object for class '{@link product.Property <em>Property</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Property</em>'.
     * @see product.Property
     * @generated
     */
    EClass getProperty();

    /**
     * Returns the meta object for the containment reference '{@link product.Property#getValue <em>Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Value</em>'.
     * @see product.Property#getValue()
     * @see #getProperty()
     * @generated
     */
    EReference getProperty_Value();

    /**
     * Returns the meta object for the reference '{@link product.Property#getDefinition <em>Definition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Definition</em>'.
     * @see product.Property#getDefinition()
     * @see #getProperty()
     * @generated
     */
    EReference getProperty_Definition();

    /**
     * Returns the meta object for class '{@link product.ProductValue <em>Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Value</em>'.
     * @see product.ProductValue
     * @generated
     */
    EClass getProductValue();

    /**
     * Returns the meta object for the '{@link product.ProductValue#isEqualType(product.ValueType) <em>Is Equal Type</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Is Equal Type</em>' operation.
     * @see product.ProductValue#isEqualType(product.ValueType)
     * @generated
     */
    EOperation getProductValue__IsEqualType__ValueType();

    /**
     * Returns the meta object for the '{@link product.ProductValue#getValueAsSerializable() <em>Get Value As Serializable</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Get Value As Serializable</em>' operation.
     * @see product.ProductValue#getValueAsSerializable()
     * @generated
     */
    EOperation getProductValue__GetValueAsSerializable();

    /**
     * Returns the meta object for class '{@link product.StringValue <em>String Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>String Value</em>'.
     * @see product.StringValue
     * @generated
     */
    EClass getStringValue();

    /**
     * Returns the meta object for the attribute '{@link product.StringValue#getValue <em>Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Value</em>'.
     * @see product.StringValue#getValue()
     * @see #getStringValue()
     * @generated
     */
    EAttribute getStringValue_Value();

    /**
     * Returns the meta object for the '{@link product.StringValue#isEqualType(product.ValueType) <em>Is Equal Type</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Is Equal Type</em>' operation.
     * @see product.StringValue#isEqualType(product.ValueType)
     * @generated
     */
    EOperation getStringValue__IsEqualType__ValueType();

    /**
     * Returns the meta object for class '{@link product.BooleanValue <em>Boolean Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Boolean Value</em>'.
     * @see product.BooleanValue
     * @generated
     */
    EClass getBooleanValue();

    /**
     * Returns the meta object for the attribute '{@link product.BooleanValue#getValue <em>Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Value</em>'.
     * @see product.BooleanValue#getValue()
     * @see #getBooleanValue()
     * @generated
     */
    EAttribute getBooleanValue_Value();

    /**
     * Returns the meta object for the '{@link product.BooleanValue#isEqualType(product.ValueType) <em>Is Equal Type</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Is Equal Type</em>' operation.
     * @see product.BooleanValue#isEqualType(product.ValueType)
     * @generated
     */
    EOperation getBooleanValue__IsEqualType__ValueType();

    /**
     * Returns the meta object for class '{@link product.IntegerValue <em>Integer Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Integer Value</em>'.
     * @see product.IntegerValue
     * @generated
     */
    EClass getIntegerValue();

    /**
     * Returns the meta object for the attribute '{@link product.IntegerValue#getValue <em>Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Value</em>'.
     * @see product.IntegerValue#getValue()
     * @see #getIntegerValue()
     * @generated
     */
    EAttribute getIntegerValue_Value();

    /**
     * Returns the meta object for the '{@link product.IntegerValue#isEqualType(product.ValueType) <em>Is Equal Type</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Is Equal Type</em>' operation.
     * @see product.IntegerValue#isEqualType(product.ValueType)
     * @generated
     */
    EOperation getIntegerValue__IsEqualType__ValueType();

    /**
     * Returns the meta object for class '{@link product.IProductDefinition <em>IProduct Definition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>IProduct Definition</em>'.
     * @see product.IProductDefinition
     * @generated
     */
    EClass getIProductDefinition();

    /**
     * Returns the meta object for the '{@link product.IProductDefinition#getPropertyDefinitions() <em>Get Property Definitions</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Get Property Definitions</em>' operation.
     * @see product.IProductDefinition#getPropertyDefinitions()
     * @generated
     */
    EOperation getIProductDefinition__GetPropertyDefinitions();

    /**
     * Returns the meta object for the '{@link product.IProductDefinition#getName() <em>Get Name</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Get Name</em>' operation.
     * @see product.IProductDefinition#getName()
     * @generated
     */
    EOperation getIProductDefinition__GetName();

    /**
     * Returns the meta object for enum '{@link product.ValueType <em>Value Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for enum '<em>Value Type</em>'.
     * @see product.ValueType
     * @generated
     */
    EEnum getValueType();

    /**
     * Returns the meta object for enum '{@link product.TransferType <em>Transfer Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for enum '<em>Transfer Type</em>'.
     * @see product.TransferType
     * @generated
     */
    EEnum getTransferType();

    /**
     * Returns the meta object for data type '{@link java.io.Serializable <em>Serializable</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for data type '<em>Serializable</em>'.
     * @see java.io.Serializable
     * @model instanceClass="java.io.Serializable"
     * @generated
     */
    EDataType getSerializable();

    /**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
    ProductFactory getProductFactory();

    /**
     * <!-- begin-user-doc -->
     * Defines literals for the meta objects that represent
     * <ul>
     *   <li>each class,</li>
     *   <li>each feature of each class,</li>
     *   <li>each operation of each class,</li>
     *   <li>each enum,</li>
     *   <li>and each data type</li>
     * </ul>
     * <!-- end-user-doc -->
     * @generated
     */
    interface Literals
    {
        /**
         * The meta object literal for the '{@link product.impl.ProductDefinitionImpl <em>Definition</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see product.impl.ProductDefinitionImpl
         * @see product.impl.ProductPackageImpl#getProductDefinition()
         * @generated
         */
        EClass PRODUCT_DEFINITION = eINSTANCE.getProductDefinition();

        /**
         * The meta object literal for the '<em><b>Property Definitions</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference PRODUCT_DEFINITION__PROPERTY_DEFINITIONS = eINSTANCE.getProductDefinition_PropertyDefinitions();

        /**
         * The meta object literal for the '{@link product.impl.PropertyDefinitionImpl <em>Property Definition</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see product.impl.PropertyDefinitionImpl
         * @see product.impl.ProductPackageImpl#getPropertyDefinition()
         * @generated
         */
        EClass PROPERTY_DEFINITION = eINSTANCE.getPropertyDefinition();

        /**
         * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute PROPERTY_DEFINITION__NAME = eINSTANCE.getPropertyDefinition_Name();

        /**
         * The meta object literal for the '<em><b>Value Type</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute PROPERTY_DEFINITION__VALUE_TYPE = eINSTANCE.getPropertyDefinition_ValueType();

        /**
         * The meta object literal for the '{@link product.impl.PropertyImpl <em>Property</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see product.impl.PropertyImpl
         * @see product.impl.ProductPackageImpl#getProperty()
         * @generated
         */
        EClass PROPERTY = eINSTANCE.getProperty();

        /**
         * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference PROPERTY__VALUE = eINSTANCE.getProperty_Value();

        /**
         * The meta object literal for the '<em><b>Definition</b></em>' reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference PROPERTY__DEFINITION = eINSTANCE.getProperty_Definition();

        /**
         * The meta object literal for the '{@link product.ProductValue <em>Value</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see product.ProductValue
         * @see product.impl.ProductPackageImpl#getProductValue()
         * @generated
         */
        EClass PRODUCT_VALUE = eINSTANCE.getProductValue();

        /**
         * The meta object literal for the '<em><b>Is Equal Type</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation PRODUCT_VALUE___IS_EQUAL_TYPE__VALUETYPE = eINSTANCE.getProductValue__IsEqualType__ValueType();

        /**
         * The meta object literal for the '<em><b>Get Value As Serializable</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation PRODUCT_VALUE___GET_VALUE_AS_SERIALIZABLE = eINSTANCE.getProductValue__GetValueAsSerializable();

        /**
         * The meta object literal for the '{@link product.impl.StringValueImpl <em>String Value</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see product.impl.StringValueImpl
         * @see product.impl.ProductPackageImpl#getStringValue()
         * @generated
         */
        EClass STRING_VALUE = eINSTANCE.getStringValue();

        /**
         * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute STRING_VALUE__VALUE = eINSTANCE.getStringValue_Value();

        /**
         * The meta object literal for the '<em><b>Is Equal Type</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation STRING_VALUE___IS_EQUAL_TYPE__VALUETYPE = eINSTANCE.getStringValue__IsEqualType__ValueType();

        /**
         * The meta object literal for the '{@link product.impl.BooleanValueImpl <em>Boolean Value</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see product.impl.BooleanValueImpl
         * @see product.impl.ProductPackageImpl#getBooleanValue()
         * @generated
         */
        EClass BOOLEAN_VALUE = eINSTANCE.getBooleanValue();

        /**
         * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute BOOLEAN_VALUE__VALUE = eINSTANCE.getBooleanValue_Value();

        /**
         * The meta object literal for the '<em><b>Is Equal Type</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation BOOLEAN_VALUE___IS_EQUAL_TYPE__VALUETYPE = eINSTANCE.getBooleanValue__IsEqualType__ValueType();

        /**
         * The meta object literal for the '{@link product.impl.IntegerValueImpl <em>Integer Value</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see product.impl.IntegerValueImpl
         * @see product.impl.ProductPackageImpl#getIntegerValue()
         * @generated
         */
        EClass INTEGER_VALUE = eINSTANCE.getIntegerValue();

        /**
         * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute INTEGER_VALUE__VALUE = eINSTANCE.getIntegerValue_Value();

        /**
         * The meta object literal for the '<em><b>Is Equal Type</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation INTEGER_VALUE___IS_EQUAL_TYPE__VALUETYPE = eINSTANCE.getIntegerValue__IsEqualType__ValueType();

        /**
         * The meta object literal for the '{@link product.IProductDefinition <em>IProduct Definition</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see product.IProductDefinition
         * @see product.impl.ProductPackageImpl#getIProductDefinition()
         * @generated
         */
        EClass IPRODUCT_DEFINITION = eINSTANCE.getIProductDefinition();

        /**
         * The meta object literal for the '<em><b>Get Property Definitions</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation IPRODUCT_DEFINITION___GET_PROPERTY_DEFINITIONS = eINSTANCE.getIProductDefinition__GetPropertyDefinitions();

        /**
         * The meta object literal for the '<em><b>Get Name</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation IPRODUCT_DEFINITION___GET_NAME = eINSTANCE.getIProductDefinition__GetName();

        /**
         * The meta object literal for the '{@link product.ValueType <em>Value Type</em>}' enum.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see product.ValueType
         * @see product.impl.ProductPackageImpl#getValueType()
         * @generated
         */
        EEnum VALUE_TYPE = eINSTANCE.getValueType();

        /**
         * The meta object literal for the '{@link product.TransferType <em>Transfer Type</em>}' enum.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see product.TransferType
         * @see product.impl.ProductPackageImpl#getTransferType()
         * @generated
         */
        EEnum TRANSFER_TYPE = eINSTANCE.getTransferType();

        /**
         * The meta object literal for the '<em>Serializable</em>' data type.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see java.io.Serializable
         * @see product.impl.ProductPackageImpl#getSerializable()
         * @generated
         */
        EDataType SERIALIZABLE = eINSTANCE.getSerializable();

    }

} //ProductPackage
