/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.product.productdata;

import java.util.ArrayList;
import java.util.List;

public class ProductInstance {
    private final String productID;

    private final ArrayList<LifeCycleEvent> lifeCycle = new ArrayList<LifeCycleEvent>();

    private final ArrayList<ProductProperty> properties = new ArrayList<ProductProperty>();

    public ProductInstance(String productID, LifeCycleEvent lifeCycle, List<ProductProperty> properties) {
        this.productID = productID;
        this.lifeCycle.add(lifeCycle);
        this.properties.addAll(properties);
    }

    public String getProductID() {
        return productID;
    }

    public List<LifeCycleEvent> getLifeCycle() {
        return lifeCycle;
    }

    public List<ProductProperty> getProperties() {
        return properties;
    }

    public void addProductLocationToLifeCycle(LifeCycleEvent location) {
        this.lifeCycle.add(location);
    }

    public void addPropertiesToList(List<ProductProperty> propertyList) {
        this.properties.addAll(propertyList);
    }
}
