/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.project;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.project.IConfigSourceProvider;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProject;
import org.eclipse.lsp4mp.jdt.internal.core.ConfigSourceProviderRegistry;
import org.eclipse.lsp4mp.jdt.internal.core.FakeJavaProject;

public class JDTMicroProfileProjectManager {
    private static final Logger LOGGER = Logger.getLogger(JDTMicroProfileProjectManager.class.getName());
    private static final JDTMicroProfileProjectManager INSTANCE = new JDTMicroProfileProjectManager();
    private final Map<IJavaProject, JDTMicroProfileProject> projects = new HashMap<IJavaProject, JDTMicroProfileProject>();
    private MicroProfileProjectListener microprofileProjectListener;

    public static JDTMicroProfileProjectManager getInstance() {
        return INSTANCE;
    }

    private JDTMicroProfileProjectManager() {
    }

    public JDTMicroProfileProject getJDTMicroProfileProject(IJavaProject project) throws JavaModelException {
        return this.getJDTMicroProfileProject(project, true);
    }

    private JDTMicroProfileProject getJDTMicroProfileProject(IJavaProject project, boolean create) throws JavaModelException {
        IJavaProject javaProject = FakeJavaProject.getRealJavaProject(project);
        JDTMicroProfileProject info = this.projects.get(javaProject);
        if (info == null) {
            if (!create) {
                return null;
            }
            info = new JDTMicroProfileProject(javaProject);
            this.projects.put(javaProject, info);
        }
        return info;
    }

    public boolean isConfigSource(IFile file) {
        String fileName = file.getName();
        for (IConfigSourceProvider provider : ConfigSourceProviderRegistry.getInstance().getProviders()) {
            if (!provider.isConfigSource(fileName)) continue;
            return true;
        }
        return false;
    }

    public JDTMicroProfileProject getJDTMicroProfileProject(IFile file) {
        IJavaProject project = JavaCore.create((IProject)file.getProject());
        if (project == null) {
            return null;
        }
        try {
            return this.getJDTMicroProfileProject(project, false);
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting MicroProfile project", e);
            return null;
        }
    }

    public void initialize() {
        if (this.microprofileProjectListener != null) {
            return;
        }
        this.microprofileProjectListener = new MicroProfileProjectListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.microprofileProjectListener);
    }

    public void destroy() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.microprofileProjectListener);
    }

    private class MicroProfileProjectListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private MicroProfileProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 4: {
                    IResource resource = event.getResource();
                    if (resource == null) break;
                    switch (resource.getType()) {
                        case 4: {
                            this.evict((IProject)resource);
                        }
                    }
                    break;
                }
                case 2: {
                    IResource resource = event.getResource();
                    if (resource == null) break;
                    switch (resource.getType()) {
                        case 4: {
                            this.evict((IProject)resource);
                        }
                    }
                    break;
                }
                case 1: {
                    IResourceDelta resourceDelta = event.getDelta();
                    if (resourceDelta == null) break;
                    try {
                        resourceDelta.accept((IResourceDeltaVisitor)this);
                        break;
                    }
                    catch (CoreException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break;
                        LOGGER.log(Level.SEVERE, "Error while tracking MicroProfile properties file", e);
                    }
                }
            }
        }

        private void evict(IProject project) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                JDTMicroProfileProjectManager.this.projects.remove(javaProject);
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource == null) {
                return false;
            }
            switch (resource.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    return resource.isAccessible();
                }
                case 1: {
                    JDTMicroProfileProject mpProject;
                    IFile file = (IFile)resource;
                    if (!this.isFileDeleted(delta) && !this.isFileContentChanged(delta) && !this.isFileAdded(delta) || !JDTMicroProfileProjectManager.this.isConfigSource(file) || (mpProject = JDTMicroProfileProjectManager.this.getJDTMicroProfileProject(file)) == null) break;
                    mpProject.evictConfigSourcesCache();
                }
            }
            return false;
        }

        private boolean isFileDeleted(IResourceDelta delta) {
            return delta.getKind() == 2;
        }

        private boolean isFileAdded(IResourceDelta delta) {
            return delta.getKind() == 1;
        }

        private boolean isFileContentChanged(IResourceDelta delta) {
            return delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0;
        }
    }
}

