/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.config.properties;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.AbstractAnnotationTypeReferencePropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class MicroProfileConfigPropertyProvider
extends AbstractAnnotationTypeReferencePropertiesProvider {
    private static final String[] ANNOTATION_NAMES = new String[]{"org.eclipse.microprofile.config.inject.ConfigProperty"};

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation configPropertyAnnotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        IType classType;
        boolean hasConfigPropertiesAnnotation;
        if (!(javaElement.getElementType() != 8 && javaElement.getElementType() != 14 || (hasConfigPropertiesAnnotation = AnnotationUtils.hasAnnotation((IAnnotatable)(classType = (IType)javaElement.getAncestor(7)), "org.eclipse.microprofile.config.inject.ConfigProperties")))) {
            this.collectProperty(javaElement, configPropertyAnnotation, null, false, context.getCollector());
        }
    }

    protected void collectProperty(IJavaElement javaElement, IAnnotation configPropertyAnnotation, String prefix, boolean useFieldNameIfAnnotationIsNotPresent, IPropertiesCollector collector) throws JavaModelException {
        String propertyName = this.getPropertyName(javaElement, configPropertyAnnotation, prefix, useFieldNameIfAnnotationIsNotPresent);
        if (propertyName != null && !propertyName.isEmpty()) {
            String defaultValue = configPropertyAnnotation != null ? AnnotationUtils.getAnnotationMemberValue(configPropertyAnnotation, "defaultValue") : null;
            this.collectProperty(javaElement, propertyName, defaultValue, collector);
        }
    }

    protected String getPropertyName(IJavaElement javaElement, IAnnotation configPropertyAnnotation, String prefix, boolean useFieldNameIfAnnotationIsNotPresent) throws JavaModelException {
        if (configPropertyAnnotation != null) {
            return MicroProfileConfigPropertyProvider.getPropertyName(AnnotationUtils.getAnnotationMemberValue(configPropertyAnnotation, "name"), prefix);
        }
        if (useFieldNameIfAnnotationIsNotPresent) {
            return MicroProfileConfigPropertyProvider.getPropertyName(javaElement.getElementName(), prefix);
        }
        return null;
    }

    public static String getPropertyName(String propertyName, String prefix) {
        return StringUtils.isNotEmpty((CharSequence)prefix) ? prefix + "." + propertyName : propertyName;
    }

    private void collectProperty(IJavaElement javaElement, String name, String defaultValue, IPropertiesCollector collector) throws JavaModelException {
        IJavaProject javaProject = javaElement.getJavaProject();
        String varTypeName = JDTTypeUtils.getResolvedTypeName(javaElement);
        IType varType = JDTTypeUtils.findType(javaProject, varTypeName);
        String type = JDTTypeUtils.getPropertyType(varType, varTypeName);
        String description = null;
        String sourceType = JDTTypeUtils.getSourceType(javaElement);
        String sourceField = null;
        String sourceMethod = null;
        String extensionName = null;
        if (javaElement.getElementType() == 8) {
            sourceField = JDTTypeUtils.getSourceField(javaElement);
        } else if (javaElement.getElementType() == 14) {
            ILocalVariable localVariable = (ILocalVariable)javaElement;
            IMethod method = (IMethod)localVariable.getDeclaringMember();
            sourceMethod = JDTTypeUtils.getSourceMethod(method);
        }
        IType enclosedType = JDTTypeUtils.getEnclosedType(varType, type, javaProject);
        super.updateHint(collector, enclosedType);
        boolean binary = JDTTypeUtils.isBinary(javaElement);
        super.addItemMetadata(collector, name, type, description, sourceType, sourceField, sourceMethod, defaultValue, extensionName, binary);
    }
}

