/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.runtime;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ProjectClassLoader
extends ClassLoader {
    private final URLClassLoader jarClassLoader;
    private final List<Path> classesDirectories;
    private final Map<String, Class<?>> projectClassCache = new ConcurrentHashMap();

    public ProjectClassLoader(Set<String> classpath, ClassLoader parent) {
        super(parent);
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        ArrayList<Path> dirPaths = new ArrayList<Path>();
        for (String entry : classpath) {
            try {
                Path path = Paths.get(entry, new String[0]);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    dirPaths.add(path);
                    continue;
                }
                jarUrls.add(path.toUri().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        this.jarClassLoader = new URLClassLoader(jarUrls.toArray(new URL[0]), null);
        this.classesDirectories = dirPaths;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cached = this.projectClassCache.get(name);
        if (cached != null) {
            if (resolve) {
                this.resolveClass(cached);
            }
            return cached;
        }
        try {
            Class<?> cls = this.findClass(name);
            if (resolve) {
                this.resolveClass(cls);
            }
            return cls;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class<?> cls = this.jarClassLoader.loadClass(name);
                if (resolve) {
                    this.resolveClass(cls);
                }
                this.projectClassCache.put(name, cls);
                return cls;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return super.loadClass(name, resolve);
            }
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cached = this.projectClassCache.get(name);
        if (cached != null) {
            return cached;
        }
        String relPath = name.replace('.', '/') + ".class";
        for (Path dir : this.classesDirectories) {
            Path classFile = dir.resolve(relPath);
            if (!Files.exists(classFile, new LinkOption[0])) continue;
            try {
                byte[] bytes = Files.readAllBytes(classFile);
                Class<?> cls = this.defineClass(name, bytes, 0, bytes.length);
                this.projectClassCache.put(name, cls);
                return cls;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read class file: " + String.valueOf(classFile), e);
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        for (Path dir : this.classesDirectories) {
            Path resourceFile = dir.resolve(name);
            if (!Files.exists(resourceFile, new LinkOption[0])) continue;
            try {
                return resourceFile.toUri().toURL();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        URL resource = this.jarClassLoader.findResource(name);
        if (resource != null) {
            return resource;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Path dir : this.classesDirectories) {
            Path resourceFile = dir.resolve(name);
            if (!Files.exists(resourceFile, new LinkOption[0])) continue;
            result.add(resourceFile.toUri().toURL());
        }
        Enumeration<URL> jarResources = this.jarClassLoader.findResources(name);
        while (jarResources.hasMoreElements()) {
            result.add(jarResources.nextElement());
        }
        Enumeration<URL> parentResources = this.getParent().getResources(name);
        while (parentResources.hasMoreElements()) {
            result.add(parentResources.nextElement());
        }
        return Collections.enumeration(result);
    }

    public void clearProjectClassCache() {
        this.projectClassCache.clear();
    }

    public URL[] getJarURLs() {
        if (this.jarClassLoader instanceof URLClassLoader) {
            return this.jarClassLoader.getURLs();
        }
        return new URL[0];
    }
}

