/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client;

import jakarta.ws.rs.client.ClientBuilder;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.eclipse.lyo.client.IOslcClient;
import org.eclipse.lyo.client.OslcOAuthClient;
import org.eclipse.lyo.client.RootServicesHelper;
import org.eclipse.lyo.client.UnderlyingHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OslcOAuthClientBuilder {
    private String requestTokenURL = "";
    private String authorizationTokenURL = "";
    private String accessTokenURL = "";
    private String callback = "";
    private String consumerKey = "";
    private String consumerSecret = "";
    private String oauthRealmName = "";
    private ClientBuilder clientBuilder = null;
    private UnderlyingHttpClient underlyingHttpClient = null;
    private static final Logger log = LoggerFactory.getLogger(OslcOAuthClientBuilder.class);

    public OslcOAuthClientBuilder setFromRootService(RootServicesHelper rootService) {
        this.setOAuthServiceProvider(rootService.getRequestTokenUrl(), rootService.getAuthorizationTokenUrl(), rootService.getAccessTokenUrl());
        this.setOauthRealmName(rootService.getAuthorizationRealm());
        return this;
    }

    public OslcOAuthClientBuilder setOAuthServiceProvider(String requestTokenURL, String authorizationTokenURL, String accessTokenURL) {
        this.requestTokenURL = requestTokenURL;
        this.authorizationTokenURL = authorizationTokenURL;
        this.accessTokenURL = accessTokenURL;
        return this;
    }

    public OslcOAuthClientBuilder setOAuthConsumer(String callback, String consumerKey, String consumerSecret) {
        this.callback = callback;
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        return this;
    }

    public OslcOAuthClientBuilder setOauthRealmName(String oauthRealmName) {
        this.oauthRealmName = oauthRealmName;
        return this;
    }

    public OslcOAuthClientBuilder setCallback(String callback) {
        this.callback = callback;
        return this;
    }

    public OslcOAuthClientBuilder setClientBuilder(ClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
        return this;
    }

    public OslcOAuthClientBuilder setUnderlyingHttpClient(UnderlyingHttpClient underlyingHttpClient) {
        this.underlyingHttpClient = underlyingHttpClient;
        return this;
    }

    public IOslcClient build() {
        OAuthServiceProvider oAuthServiceProvider = new OAuthServiceProvider(this.requestTokenURL, this.authorizationTokenURL, this.accessTokenURL);
        OAuthConsumer oAuthConsumer = new OAuthConsumer(this.callback, this.consumerKey, this.consumerSecret, oAuthServiceProvider);
        OAuthAccessor oauthAccessor = new OAuthAccessor(oAuthConsumer);
        return new OslcOAuthClient(oauthAccessor, this.oauthRealmName, this.clientBuilder, this.underlyingHttpClient);
    }
}

