/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.Partitioner;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class SpeculatedPartition
extends AbstractPartition {
    private final @NonNull Set<@NonNull Node> tracedInputNodes = new HashSet<Node>();

    public SpeculatedPartition(@NonNull Partitioner partitioner) {
        super(partitioner);
        this.resolveRealizedMiddleNodes();
        this.resolvePredicatedMiddleNodes();
        this.resolvePredicatedOutputNodes();
        this.resolveRealizedOutputNodes();
        this.resolveMatchedPredicatedEdges();
        this.resolveRealizedEdges();
        this.resolveComputations();
        this.resolvePredicates();
        this.resolveEdgeRoles();
    }

    private boolean isCorrolary(@NonNull Node node) {
        assert (node.isPredicated());
        for (Edge outgoingEdge : RegionUtil.getOutgoingEdges((Node)node)) {
            if (outgoingEdge.isRealized() || outgoingEdge.isSecondary()) continue;
            return false;
        }
        Property corrolaryProperty = null;
        for (Edge incomingEdge : RegionUtil.getIncomingEdges((Node)node)) {
            if (incomingEdge.isRealized() || incomingEdge.isComputation()) continue;
            if (incomingEdge.isNavigation() && !incomingEdge.isSecondary() && incomingEdge.isPredicated()) {
                NavigableEdge parentEdge;
                NavigableEdge navigationEdge = (NavigableEdge)incomingEdge;
                Property middle2outputProperty = navigationEdge.getProperty();
                if (!this.partitioner.isCorrolary(incomingEdge)) continue;
                assert (corrolaryProperty == null);
                Node sourceNode = navigationEdge.getEdgeSource();
                while ((parentEdge = this.getParentEdge(sourceNode)) != null) {
                    if (parentEdge.getEdgeTarget() != sourceNode && (parentEdge = parentEdge.getOppositeEdge()) == null) {
                        return false;
                    }
                    sourceNode = parentEdge.getEdgeSource();
                }
                corrolaryProperty = middle2outputProperty;
                continue;
            }
            assert (false);
        }
        return corrolaryProperty != null;
    }

    private void gatherSourceNavigations(@NonNull Node targetNode, @NonNull Role targetNodeRole) {
        if (!this.hasNode(targetNode)) {
            this.addNode(targetNode, targetNodeRole);
            if (!this.tracedInputNodes.contains(targetNode)) {
                boolean hasPredecessor = false;
                for (Node sourceNode : this.getPredecessors(targetNode)) {
                    hasPredecessor = true;
                    this.gatherSourceNavigations(sourceNode, RegionUtil.getNodeRole((Node)sourceNode));
                }
                if (!hasPredecessor && targetNode.isPredicated()) {
                    for (NavigableEdge edge : targetNode.getNavigationEdges()) {
                        if (!edge.isPredicated() || edge.getOppositeEdge() != null) continue;
                        Node nonUnitSourceNode = edge.getEdgeTarget();
                        this.gatherSourceNavigations(nonUnitSourceNode, RegionUtil.getNodeRole((Node)nonUnitSourceNode));
                    }
                }
            }
        }
    }

    @Override
    protected boolean isComputable(@NonNull Set<@NonNull Node> sourceNodes, @NonNull Edge edge) {
        Node sourceNode = edge.getEdgeSource();
        if (this.tracedInputNodes.contains(sourceNode)) {
            sourceNodes.add(sourceNode);
            return true;
        }
        return super.isComputable(sourceNodes, edge);
    }

    @Override
    protected boolean resolveComputations(@NonNull Node targetNode) {
        if (this.tracedInputNodes.contains(targetNode)) {
            return true;
        }
        return super.resolveComputations(targetNode);
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Object edgeRole = RegionUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED && this.partitioner.hasRealizedEdge(edge)) {
            edgeRole = edge.getEdgeTarget().isConstant() ? null : Role.PREDICATED;
        }
        return edgeRole;
    }

    protected void resolveMatchedPredicatedEdges() {
        for (Edge edge : this.partitioner.getPredicatedEdges()) {
            Node targetNode;
            Node sourceNode;
            if (!edge.isMatched() || this.partitioner.hasPredicatedEdge(edge) || this.partitioner.isCorrolary(edge) || (sourceNode = edge.getEdgeSource()).isRealized() || (targetNode = edge.getEdgeTarget()).isRealized()) continue;
            if (!this.hasNode(sourceNode)) {
                this.addNode(sourceNode, RegionUtil.getNodeRole((Node)sourceNode));
            }
            if (this.hasNode(targetNode)) continue;
            this.addNode(targetNode, RegionUtil.getNodeRole((Node)targetNode));
        }
    }

    @Override
    protected void resolveNavigations(@NonNull Node node) {
        if (!node.isConstant() && !node.isLoaded()) {
            super.resolveNavigations(node);
        }
    }

    protected void resolvePredicatedMiddleNodes() {
        for (Node node : this.partitioner.getPredicatedMiddleNodes()) {
            if (!node.isMatched()) continue;
            Role nodeRole = RegionUtil.getNodeRole((Node)node);
            if (node.isPattern() && node.isClass()) {
                nodeRole = QVTscheduleUtil.asSpeculated((Role)nodeRole);
            }
            this.gatherSourceNavigations(node, QVTscheduleUtil.asSpeculated((Role)nodeRole));
        }
    }

    protected void resolvePredicatedOutputNodes() {
        for (Node node : this.partitioner.getPredicatedOutputNodes()) {
            if (this.isCorrolary(node)) continue;
            Role nodeRole = RegionUtil.getNodeRole((Node)node);
            this.gatherSourceNavigations(node, nodeRole);
        }
    }

    protected void resolveRealizedEdges() {
        for (Edge edge : this.partitioner.getRealizedEdges()) {
            Node targetNode;
            Node sourceNode;
            if (this.partitioner.hasRealizedEdge(edge) || this.partitioner.isCorrolary(edge) || (sourceNode = edge.getEdgeSource()).isRealized() || (targetNode = edge.getEdgeTarget()).isRealized()) continue;
            if (!this.hasNode(sourceNode)) {
                this.addNode(sourceNode, RegionUtil.getNodeRole((Node)sourceNode));
            }
            if (this.hasNode(targetNode)) continue;
            this.addNode(targetNode, RegionUtil.getNodeRole((Node)targetNode));
        }
    }

    protected void resolveRealizedMiddleNodes() {
        Node traceNode = this.partitioner.getTraceNode();
        if (traceNode != null && traceNode.isMatched() && traceNode.isClass()) {
            Role nodeRole = RegionUtil.getNodeRole((Node)traceNode);
            assert (traceNode.isPattern());
            nodeRole = QVTscheduleUtil.asSpeculated((Role)nodeRole);
            if (!this.hasNode(traceNode)) {
                this.addNode(traceNode, nodeRole);
            }
            for (NavigableEdge edge : traceNode.getNavigationEdges()) {
                if (!this.partitioner.hasRealizedEdge((Edge)edge)) continue;
                this.tracedInputNodes.add(edge.getEdgeTarget());
            }
        }
        for (Node node : this.partitioner.getRealizedMiddleNodes()) {
            if (node == traceNode || !node.isMatched() || !node.isClass()) continue;
            Role nodeRole = RegionUtil.getNodeRole((Node)node);
            assert (node.isPattern());
            if (!this.hasNode(node)) {
                this.addNode(node, nodeRole);
            }
            for (NavigableEdge edge : node.getNavigationEdges()) {
                if (!this.partitioner.hasRealizedEdge((Edge)edge)) continue;
                this.tracedInputNodes.add(edge.getEdgeTarget());
            }
        }
    }

    protected void resolveRealizedOutputNodes() {
        for (Node node : this.partitioner.getRealizedOutputNodes()) {
            this.gatherSourceNavigations(node, RegionUtil.getNodeRole((Node)node));
            for (NavigableEdge navigationEdge : node.getNavigationEdges()) {
                Node targetNode;
                if (!navigationEdge.isRealized() || (targetNode = navigationEdge.getEdgeTarget()).isPredicated() || targetNode.isRealized()) continue;
                this.gatherSourceNavigations(targetNode, RegionUtil.getNodeRole((Node)targetNode));
            }
        }
    }
}

