/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.DependencyAnalyzer;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edges;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Nodes;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.OperationDatum;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Role;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SuperRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Visitor;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.DOTStringBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphMLStringBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;

public class OperationRegion
extends AbstractRegion
implements SimpleRegion {
    protected final @NonNull Operation operation;
    protected final @NonNull ExpressionInOCL specification;
    protected final @NonNull String name;
    private final @NonNull List<@NonNull Node> headNodes = new ArrayList<Node>();
    private final @NonNull SimpleNode resultNode;
    private final @NonNull List<@NonNull Node> extraNodes = new ArrayList<Node>();

    protected OperationRegion(@NonNull SuperRegion superRegion, @NonNull OperationDatum operationDatum, @NonNull ExpressionInOCL specification, @NonNull OperationCallExp operationCallExp) {
        super(superRegion);
        SimpleNode selfNode;
        this.operation = (Operation)ClassUtil.nonNullState((Object)operationCallExp.getReferredOperation());
        this.specification = specification;
        String name = operationDatum.toString();
        assert (name != null);
        this.name = name;
        Variable selfVariable = specification.getOwnedContext();
        OCLExpression source = operationCallExp.getOwnedSource();
        assert (source != null);
        SimpleNode extraNode = selfNode = this.createParameterNode(selfVariable, (String)ClassUtil.nonNullState((Object)selfVariable.getName()), source);
        this.resultNode = Nodes.UNNAVIGABLE_STEP.createSimpleNode(this, "result", (CallExp)operationCallExp, extraNode);
        Edges.RESULT.createSimpleEdge(this, extraNode, null, this.resultNode);
        List ownedParameters = specification.getOwnedParameters();
        List ownedArguments = operationCallExp.getOwnedArguments();
        int iSize = Math.min(ownedArguments.size(), ownedParameters.size());
        int i = 0;
        while (i < iSize) {
            Variable parameter = (Variable)ownedParameters.get(i);
            this.createParameterNode(parameter, (String)ClassUtil.nonNullState((Object)parameter.getName()), (OCLExpression)ClassUtil.nonNullState((Object)((OCLExpression)ownedArguments.get(i))));
            ++i;
        }
        SchedulerConstants schedulerConstants = this.getSchedulerConstants();
        DependencyAnalyzer dependencyAnalyzer = schedulerConstants.getDependencyAnalyzer();
        DependencyAnalyzer.DependencyPaths path = dependencyAnalyzer.analyze(operationCallExp);
        Iterable<List<DependencyAnalyzer.DependencyStep>> hiddenPaths = path.getHiddenPaths();
        Iterable<List<DependencyAnalyzer.DependencyStep>> returnPaths = path.getReturnPaths();
        HashMap<ClassDatumAnalysis, SimpleNode> classDatumAnalysis2node = new HashMap<ClassDatumAnalysis, SimpleNode>();
        for (List steps : Iterables.concat(returnPaths, hiddenPaths)) {
            DependencyAnalyzer.DependencyStep classStep;
            DomainUsage stepUsage;
            if (steps.size() <= 0 || !(stepUsage = (classStep = (DependencyAnalyzer.DependencyStep)steps.get(0)).getUsage()).isOutput() || stepUsage.isInput()) continue;
            Class stepType = ((DependencyAnalyzer.DependencyStep)steps.get(0)).getElementalType();
            TypedModel typedModel = stepUsage.getTypedModel(classStep.getElement());
            assert (typedModel != null);
            ClassDatumAnalysis classDatumAnalysis = schedulerConstants.getClassDatumAnalysis(stepType, typedModel);
            if (classDatumAnalysis.getCompleteClass().getPrimaryClass() instanceof DataType) continue;
            SimpleNode extraNode2 = (SimpleNode)classDatumAnalysis2node.get(classDatumAnalysis);
            if (extraNode2 == null) {
                extraNode2 = this.createParameterNode(classDatumAnalysis, "extra2_" + stepType.getName());
                classDatumAnalysis2node.put(classDatumAnalysis, extraNode2);
                this.extraNodes.add(extraNode2);
            }
            int i2 = 1;
            while (i2 < steps.size()) {
                DependencyAnalyzer.NavigationDependencyStep propertyStep = (DependencyAnalyzer.NavigationDependencyStep)steps.get(i2);
                NavigationCallExp navigationCallExp = propertyStep.getNavigationCallExp();
                CompleteClass completeClass = extraNode2.getCompleteClass();
                Class primaryClass = completeClass.getPrimaryClass();
                if (primaryClass instanceof CollectionType) {
                    Property iterateProperty = schedulerConstants.getIterateProperty((Type)primaryClass);
                    Type elementType = ((CollectionType)primaryClass).getElementType();
                    TypedModel typedModel2 = extraNode2.getClassDatumAnalysis().getTypedModel();
                    ClassDatumAnalysis elementClassDatumAnalysis = schedulerConstants.getClassDatumAnalysis((Class)elementType, typedModel2);
                    SimpleNode elementNode = Nodes.ELEMENT.createSimpleNode(this, name, elementClassDatumAnalysis, extraNode2);
                    Edges.NAVIGATION.createSimpleEdge(this, extraNode2, iterateProperty, elementNode);
                    extraNode2 = elementNode;
                }
                SimpleNode nextNode = Nodes.UNNAVIGABLE_ATTRIBUTE.createSimpleNode(this, extraNode2, navigationCallExp);
                Edges.NAVIGATION.createSimpleEdge(this, extraNode2, propertyStep.getProperty(), nextNode);
                extraNode2 = nextNode;
                ++i2;
            }
        }
        this.toGraph((GraphStringBuilder)new DOTStringBuilder());
        this.toGraph((GraphStringBuilder)new GraphMLStringBuilder());
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitOperationRegion(this);
    }

    @Override
    protected @NonNull SymbolNameBuilder computeSymbolName() {
        SymbolNameBuilder s = new SymbolNameBuilder();
        s.appendString("o_");
        s.appendName(this.name);
        return s;
    }

    private @NonNull SimpleNode createParameterNode(@NonNull Variable variable, @NonNull String name, @NonNull OCLExpression expression) {
        SchedulerConstants schedulerConstants = this.getSchedulerConstants();
        Class type = (Class)expression.getType();
        assert (type != null);
        TypedModel typedModel = schedulerConstants.getDomainUsage((Element)expression).getTypedModel((Element)expression);
        assert (typedModel != null);
        ClassDatumAnalysis classDatumAnalysis = schedulerConstants.getClassDatumAnalysis(type, typedModel);
        SimpleNode parameterNode = Nodes.PARAMETER.createSimpleNode(this, name, classDatumAnalysis);
        this.headNodes.add(parameterNode);
        return parameterNode;
    }

    private @NonNull SimpleNode createParameterNode(@NonNull ClassDatumAnalysis classDatumAnalysis, @NonNull String name) {
        SimpleNode parameterNode = Nodes.PARAMETER.createSimpleNode(this, name, classDatumAnalysis);
        this.headNodes.add(parameterNode);
        return parameterNode;
    }

    public @NonNull List<@NonNull Node> getExtraNodes() {
        return this.extraNodes;
    }

    @Override
    public @NonNull List<@NonNull Node> getHeadNodes() {
        return this.headNodes;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull SimpleNode getResultNode() {
        return this.resultNode;
    }

    @Override
    public boolean isOperationRegion() {
        return true;
    }

    @Override
    public void toGraph(@NonNull GraphStringBuilder s) {
        s.setColor("magenta");
        s.setPenwidth(Role.LINE_WIDTH);
        super.toGraph(s);
    }
}

