/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.app;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.app.SocketUtil;
import org.eclipse.m2m.qvt.oml.debug.core.app.VMInitializer;
import org.eclipse.m2m.qvt.oml.debug.core.app.VMRequestProcessor;

public class VMServer {
    private final int fEventPort;
    private final int fRequestPort;
    private final VMInitializer fVMProvider;

    public VMServer(int requestPort, VMInitializer vmProvider) throws IOException {
        if (vmProvider == null) {
            throw new IllegalArgumentException();
        }
        this.fVMProvider = vmProvider;
        this.fRequestPort = requestPort;
        this.fEventPort = SocketUtil.findFreePort();
        if (this.fEventPort == -1) {
            throw new SocketException("Could find free port for the debugger");
        }
    }

    public int run() {
        block11: {
            QVTODebugCore.TRACE.trace("Starting VM Server...");
            ServerSocket fServerSocket = null;
            Socket requestSocket = null;
            try {
                try {
                    ServerSocketChannel serveChannel = ServerSocketChannel.open();
                    fServerSocket = serveChannel.socket();
                    fServerSocket.bind(new InetSocketAddress(this.fRequestPort));
                    QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/vm", "VM Server starts listening, port:" + this.fRequestPort);
                    requestSocket = fServerSocket.accept();
                    QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/vm", "VM Server accepted debug client connection");
                    VMRequestProcessor processor = new VMRequestProcessor(requestSocket, this.fVMProvider);
                    processor.run();
                }
                catch (Throwable e) {
                    System.err.println("QVTO Debugger terminated unexpectedly...");
                    e.printStackTrace();
                    if (requestSocket != null) {
                        SocketUtil.close(requestSocket);
                    }
                    if (fServerSocket != null) {
                        SocketUtil.close(fServerSocket);
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (requestSocket != null) {
                    SocketUtil.close(requestSocket);
                }
                if (fServerSocket != null) {
                    SocketUtil.close(fServerSocket);
                }
                throw throwable;
            }
            if (requestSocket != null) {
                SocketUtil.close(requestSocket);
            }
            if (fServerSocket != null) {
                SocketUtil.close(fServerSocket);
            }
        }
        QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/vm", "VM Server terminated");
        return 0;
    }
}

