/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.collection.Closeable;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static void close(Object ... closeables) {
        if (closeables != null) {
            Object[] objectArray = closeables;
            int n = closeables.length;
            int n2 = 0;
            while (n2 < n) {
                Object closeable = objectArray[n2];
                if (closeable instanceof Closeable) {
                    ((Closeable)closeable).close();
                }
                ++n2;
            }
        }
    }

    public static <T> Iterator<T> dump(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        System.out.println(list);
        return list.iterator();
    }

    public static <NODE> List<NODE> topologicalSort(Collection<NODE> nodes, Function<NODE, Collection<NODE>> edgeProvider) {
        return CollectionUtil.topologicalSort(nodes, edgeProvider, false);
    }

    public static <NODE> List<NODE> topologicalSort(Collection<NODE> nodes, Function<NODE, Collection<NODE>> edgeProvider, boolean reverse) {
        final class NodeInfo<N> {
            N node;
            List<NodeInfo<N>> edgeInfos = new ArrayList<NodeInfo<N>>();
            int indegree;

            NodeInfo(N node) {
                this.node = node;
            }
        }
        HashMap<NODE, NodeInfo<NODE>> infos = new HashMap<NODE, NodeInfo<NODE>>();
        for (NODE node : nodes) {
            infos.put(node, new NodeInfo<NODE>(node));
        }
        for (NODE node : nodes) {
            NodeInfo info = (NodeInfo)infos.get(node);
            Collection<NODE> edges = edgeProvider.apply(node);
            if (edges == null) continue;
            for (NODE NODE : edges) {
                NodeInfo edgeInfo = (NodeInfo)infos.get(NODE);
                if (edgeInfo == null) {
                    throw new IllegalStateException("Edge is not a node: " + NODE);
                }
                info.edgeInfos.add(edgeInfo);
                ++edgeInfo.indegree;
            }
        }
        LinkedList<NodeInfo> queue = new LinkedList<NodeInfo>();
        for (NodeInfo info : infos.values()) {
            if (info.indegree != 0) continue;
            queue.add(info);
        }
        int size = nodes.size();
        ArrayList result = new ArrayList(size);
        while (!queue.isEmpty()) {
            NodeInfo info = (NodeInfo)queue.poll();
            if (reverse) {
                result.add(0, info.node);
            } else {
                result.add(info.node);
            }
            for (NodeInfo nodeInfo : info.edgeInfos) {
                if (--nodeInfo.indegree != 0) continue;
                queue.add(nodeInfo);
            }
        }
        if (result.size() != size) {
            throw new IllegalStateException("Cycle detected");
        }
        return result;
    }

    public static <T> boolean addNotNull(Collection<? super T> c, T e) {
        if (e != null) {
            return c.add(e);
        }
        return false;
    }

    public static <T> Set<T> setOf(Collection<? extends T> c) {
        if (c instanceof Set) {
            return (Set)c;
        }
        return new HashSet<T>(c);
    }

    public static <T> T first(Collection<? extends T> c) {
        Iterator<T> it = c.iterator();
        return it.hasNext() ? (T)it.next() : null;
    }

    public static <K, V> List<K> removeAll(Map<K, V> map, BiPredicate<K, V> predicate) {
        ArrayList<K> keys = new ArrayList<K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V value;
            K key = entry.getKey();
            if (!predicate.test(key, value = entry.getValue())) continue;
            keys.add(key);
        }
        for (Object key : keys) {
            map.remove(key);
        }
        return keys;
    }

    public static <K, V> V compute(Map<K, V> map, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        try {
            return map.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        }
        catch (KeepMappedValue ex) {
            return (V)ex.mappedValue();
        }
    }

    public static <SUBTYPE, TYPE extends SUBTYPE> Function<? super SUBTYPE, ? extends Stream<? extends TYPE>> subclasses(Class<TYPE> clazz) {
        return obj -> clazz.isInstance(obj) ? Stream.of(clazz.cast(obj)) : Stream.empty();
    }

    public static <T> Stream<T> stream(Iterator<T> it) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Stream<T> ... streams) {
        return CollectionUtil.concat(Arrays.asList(streams));
    }

    public static <T> Stream<T> concat(Collection<Stream<T>> streams) {
        if (ObjectUtil.isEmpty(streams)) {
            return Stream.empty();
        }
        int size = streams.size();
        if (size == 1) {
            return streams.iterator().next();
        }
        Spliterator[] splits = new Spliterator[size];
        boolean parallel = false;
        int i = 0;
        for (Stream<T> stream : streams) {
            splits[i++] = stream.spliterator();
            parallel |= stream.isParallel();
        }
        return (Stream)StreamSupport.stream(new ConcatSplit(splits), parallel).onClose(() -> {
            RuntimeException exception = null;
            for (Stream stream : streams) {
                try {
                    stream.close();
                }
                catch (RuntimeException ex) {
                    if (exception == null) {
                        exception = ex;
                        continue;
                    }
                    exception.addSuppressed(ex);
                }
            }
            if (exception != null) {
                throw exception;
            }
        });
    }

    private static final class ConcatSplit<T>
    implements Spliterator<T> {
        private static final int EMPTY_CHARACTERISTICS = Spliterators.emptySpliterator().characteristics();
        private final Spliterator<T>[] splits;
        private final int high;
        private int low;
        private int index;

        private ConcatSplit(Spliterator<T>[] splits, int from, int to) {
            this.splits = splits;
            this.high = to;
            this.low = from;
            this.index = from;
        }

        public ConcatSplit(Spliterator<T>[] splits) {
            this(splits, 0, splits.length);
        }

        @Override
        public int characteristics() {
            int i = this.low;
            if (i >= this.high) {
                return EMPTY_CHARACTERISTICS;
            }
            if (i == this.high - 1) {
                return this.splits[i].characteristics();
            }
            long size = 0L;
            int characteristics = 21840;
            do {
                Spliterator<T> split;
                if (((characteristics &= (split = this.splits[i]).characteristics()) & 0x40) != 64 || (size += split.estimateSize()) >= 0L) continue;
                characteristics &= 0xFFFFBFBF;
            } while (++i < this.high);
            return characteristics;
        }

        @Override
        public long estimateSize() {
            long size = 0L;
            int i = this.index;
            while (i < this.high) {
                if ((size += this.splits[i].estimateSize()) < 0L) {
                    return Long.MAX_VALUE;
                }
                ++i;
            }
            return size;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            int i = this.index;
            if (i < this.high) {
                do {
                    this.splits[i].forEachRemaining(action);
                } while (++i < this.high);
                this.index = this.high;
            }
        }

        @Override
        public Comparator<? super T> getComparator() {
            int i = this.low;
            if (i == this.high - 1) {
                return this.splits[i].getComparator();
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            int i = this.index;
            if (i < this.high) {
                do {
                    if (!this.splits[i].tryAdvance(action)) continue;
                    this.index = i;
                    return true;
                } while (++i < this.high);
                this.index = this.high;
            }
            return false;
        }

        @Override
        public Spliterator<T> trySplit() {
            int mid;
            int i = this.index;
            if (i >= this.high) {
                return null;
            }
            if (i == this.high - 1) {
                return this.splits[i].trySplit();
            }
            this.low = this.index = (mid = i + this.high >>> 1);
            if (mid == i + 1) {
                return this.splits[i];
            }
            return new ConcatSplit<T>(this.splits, i, mid);
        }
    }

    public static final class KeepMappedValue
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final transient Object mappedValue;

        public KeepMappedValue(Object mappedValue) {
            this.mappedValue = mappedValue;
        }

        public <T> T mappedValue() {
            return (T)this.mappedValue;
        }
    }
}

