/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.util.UTF8Util;
import org.apache.derby.impl.jdbc.ClobUtf8Writer;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.StandardException;

final class TemporaryClob
implements InternalClob {
    private ConnectionChild conChild;
    private final LOBStreamControl bytes;
    private boolean released = false;
    private long cachedCharLength;
    private UTF8Reader internalReader;
    private FilterReader unclosableInternalReader;
    private final CharToBytePositionCache posCache = new CharToBytePositionCache();

    static InternalClob cloneClobContent(String dbName, ConnectionChild conChild, InternalClob clob) throws IOException, SQLException {
        TemporaryClob newClob = new TemporaryClob(conChild);
        newClob.copyClobContent(clob);
        return newClob;
    }

    static InternalClob cloneClobContent(String dbName, ConnectionChild conChild, InternalClob clob, long length) throws IOException, SQLException {
        TemporaryClob newClob = new TemporaryClob(conChild);
        newClob.copyClobContent(clob, length);
        return newClob;
    }

    TemporaryClob(ConnectionChild conChild) {
        if (conChild == null) {
            throw new NullPointerException("conChild cannot be <null>");
        }
        this.conChild = conChild;
        this.bytes = new LOBStreamControl(conChild.getEmbedConnection());
    }

    @Override
    public synchronized void release() throws IOException {
        if (!this.released) {
            this.released = true;
            this.bytes.free();
            if (this.internalReader != null) {
                this.internalReader.close();
                this.internalReader = null;
                this.unclosableInternalReader = null;
            }
        }
    }

    @Override
    public synchronized InputStream getRawByteStream() throws IOException {
        this.checkIfValid();
        return this.bytes.getInputStream(0L);
    }

    TemporaryClob(String data, ConnectionChild conChild) throws IOException, StandardException {
        if (conChild == null) {
            throw new NullPointerException("conChild cannot be <null>");
        }
        this.conChild = conChild;
        this.bytes = new LOBStreamControl(conChild.getEmbedConnection(), this.getByteFromString(data));
        this.cachedCharLength = data.length();
    }

    private long getBytePosition(long charPos) throws IOException {
        long bytePos;
        if (charPos == this.posCache.getCharPos()) {
            bytePos = this.posCache.getBytePos();
        } else {
            long startingBytePosition = 0L;
            long charsToSkip = charPos - 1L;
            if (charPos > this.posCache.getCharPos()) {
                startingBytePosition = this.posCache.getBytePos();
                charsToSkip -= this.posCache.getCharPos() - 1L;
            }
            InputStream utf8Bytes = this.bytes.getInputStream(startingBytePosition);
            bytePos = startingBytePosition + UTF8Util.skipFully(new BufferedInputStream(utf8Bytes), charsToSkip);
            this.posCache.updateCachedPos(charPos, bytePos);
        }
        return bytePos;
    }

    @Override
    public long getUpdateCount() {
        return this.bytes.getUpdateCount();
    }

    @Override
    public synchronized Writer getWriter(long pos) throws IOException, SQLException {
        this.checkIfValid();
        if (pos < this.posCache.getCharPos()) {
            this.posCache.reset();
        }
        return new ClobUtf8Writer(this, pos);
    }

    @Override
    public synchronized Reader getReader(long pos) throws IOException, SQLException {
        long skipped;
        this.checkIfValid();
        if (pos < 1L) {
            throw new IllegalArgumentException("Position must be positive: " + pos);
        }
        UTF8Reader isr = new UTF8Reader(this.getCSD(), this.conChild, this.conChild.getConnectionSynchronization());
        for (long leftToSkip = pos - 1L; leftToSkip > 0L; leftToSkip -= skipped) {
            skipped = ((Reader)isr).skip(leftToSkip);
            if (skipped > 0L) continue;
            throw new EOFException("Reached end-of-stream prematurely");
        }
        return isr;
    }

    @Override
    public Reader getInternalReader(long characterPosition) throws IOException, SQLException {
        if (this.internalReader == null) {
            this.internalReader = new UTF8Reader(this.getCSD(), this.conChild, this.conChild.getConnectionSynchronization());
            this.unclosableInternalReader = new FilterReader(this.internalReader){

                @Override
                public void close() {
                }
            };
        }
        try {
            this.internalReader.reposition(characterPosition);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        return this.unclosableInternalReader;
    }

    @Override
    public synchronized long getCharLength() throws IOException {
        this.checkIfValid();
        if (this.cachedCharLength == 0L) {
            this.cachedCharLength = UTF8Util.skipUntilEOF(new BufferedInputStream(this.getRawByteStream()));
        }
        return this.cachedCharLength;
    }

    @Override
    public synchronized long getCharLengthIfKnown() {
        this.checkIfValid();
        return this.cachedCharLength == 0L ? -1L : this.cachedCharLength;
    }

    public synchronized long getByteLength() throws IOException {
        this.checkIfValid();
        return this.bytes.getLength();
    }

    @Override
    public synchronized long insertString(String str, long insertionPoint) throws IOException, SQLException {
        long endPos;
        this.checkIfValid();
        if (insertionPoint < 1L) {
            throw new IllegalArgumentException("Position must be positive: " + insertionPoint);
        }
        long prevLength = this.cachedCharLength;
        this.updateInternalState(insertionPoint);
        long byteInsertionPoint = this.getBytePosition(insertionPoint);
        long curByteLength = this.bytes.getLength();
        byte[] newBytes = this.getByteFromString(str);
        if (byteInsertionPoint == curByteLength) {
            try {
                this.bytes.write(newBytes, 0, newBytes.length, byteInsertionPoint);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        try {
            endPos = this.getBytePosition(insertionPoint + (long)str.length());
            this.posCache.updateCachedPos(insertionPoint, byteInsertionPoint);
        }
        catch (EOFException eofe) {
            endPos = curByteLength;
        }
        try {
            this.bytes.replaceBytes(newBytes, byteInsertionPoint, endPos);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        if (prevLength != 0L) {
            long newLength = insertionPoint - 1L + (long)str.length();
            this.cachedCharLength = newLength > prevLength ? newLength : prevLength;
        }
        return str.length();
    }

    @Override
    public synchronized boolean isReleased() {
        return this.released;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public synchronized void truncate(long newCharLength) throws IOException, SQLException {
        this.checkIfValid();
        try {
            long byteLength = UTF8Util.skipFully(new BufferedInputStream(this.getRawByteStream()), newCharLength);
            this.bytes.truncate(byteLength);
            this.updateInternalState(newCharLength);
            this.cachedCharLength = newCharLength;
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    private byte[] getByteFromString(String str) {
        byte[] buffer = new byte[3 * str.length()];
        int len = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                buffer[len++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                buffer[len++] = (byte)(0xE0 | c >> 12 & 0xF);
                buffer[len++] = (byte)(0x80 | c >> 6 & 0x3F);
                buffer[len++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            buffer[len++] = (byte)(0xC0 | c >> 6 & 0x1F);
            buffer[len++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        byte[] buff = new byte[len];
        System.arraycopy(buffer, 0, buff, 0, len);
        return buff;
    }

    private void copyClobContent(InternalClob clob) throws IOException, SQLException {
        try {
            long knownLength = clob.getCharLengthIfKnown();
            if (knownLength == -1L) {
                this.cachedCharLength = this.bytes.copyUtf8Data(clob.getRawByteStream(), Long.MAX_VALUE);
            } else {
                this.cachedCharLength = knownLength;
                this.bytes.copyData(clob.getRawByteStream(), Long.MAX_VALUE);
            }
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    private void copyClobContent(InternalClob clob, long charLength) throws IOException, SQLException {
        block4: {
            try {
                long knownLength = clob.getCharLengthIfKnown();
                if (knownLength > charLength || knownLength == -1L) {
                    this.cachedCharLength = this.bytes.copyUtf8Data(clob.getRawByteStream(), charLength);
                    break block4;
                }
                if (knownLength == charLength) {
                    this.cachedCharLength = knownLength;
                    this.bytes.copyData(clob.getRawByteStream(), Long.MAX_VALUE);
                    break block4;
                }
                throw new EOFException();
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
    }

    private final void checkIfValid() {
        if (this.released) {
            throw new IllegalStateException("The Clob has been released and is not valid");
        }
    }

    private final void updateInternalState(long charChangePosition) {
        if (this.internalReader != null) {
            this.internalReader.close();
            this.internalReader = null;
            this.unclosableInternalReader = null;
        }
        if (charChangePosition < this.posCache.getCharPos()) {
            this.posCache.reset();
        }
        this.cachedCharLength = 0L;
    }

    private final CharacterStreamDescriptor getCSD() throws IOException {
        return new CharacterStreamDescriptor.Builder().positionAware(true).maxCharLength(Integer.MAX_VALUE).stream(this.bytes.getInputStream(0L)).bufferable(this.bytes.getLength() > 4096L).byteLength(this.bytes.getLength()).charLength(this.cachedCharLength).build();
    }

    private static class CharToBytePositionCache {
        private long charPos = 1L;
        private long bytePos = 0L;

        CharToBytePositionCache() {
        }

        long getBytePos() {
            return this.bytePos;
        }

        long getCharPos() {
            return this.charPos;
        }

        void updateCachedPos(long charPos, long bytePos) {
            if (charPos - 1L > bytePos) {
                throw new IllegalArgumentException("(charPos -1) cannot be greater than bytePos; " + (charPos - 1L) + " > " + bytePos);
            }
            this.charPos = charPos;
            this.bytePos = bytePos;
        }

        void reset() {
            this.charPos = 1L;
            this.bytePos = 0L;
        }
    }
}

