/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.derby.impl.drda.CcsidManager;
import org.apache.derby.shared.common.sanity.SanityManager;

public class Utf8CcsidManager
extends CcsidManager {
    public Utf8CcsidManager() {
        super((byte)32, (byte)46, new byte[]{-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41});
    }

    @Override
    public byte[] convertFromJavaString(String sourceString) {
        try {
            return sourceString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            SanityManager.THROWASSERT("Could not convert Java String to byte[] in UTF-8", e);
            return null;
        }
    }

    @Override
    public String convertToJavaString(byte[] sourceBytes) {
        try {
            return new String(sourceBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            SanityManager.THROWASSERT("Could not convert byte[] to Java String using UTF-8 encoding", e);
            return null;
        }
    }

    @Override
    public String convertToJavaString(byte[] sourceBytes, int offset, int numToConvert) {
        try {
            return new String(sourceBytes, offset, numToConvert, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            SanityManager.THROWASSERT("Could not convert byte[] to Java String using UTF-8 encoding with offset", e);
            return null;
        }
    }

    @Override
    public void convertFromJavaString(String sourceString, ByteBuffer buffer) {
        buffer.put(this.convertFromJavaString(sourceString));
    }

    @Override
    int getByteLength(String str) {
        try {
            return str.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            SanityManager.THROWASSERT("Could not obtain byte length of Java String in Utf8CcsidManager", e);
            return -1;
        }
    }
}

