/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jms.util;

import java.io.IOException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.eclipse.net4j.internal.jms.DestinationImpl;
import org.eclipse.net4j.internal.jms.QueueImpl;
import org.eclipse.net4j.internal.jms.TopicImpl;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public final class DestinationUtil {
    private DestinationUtil() {
    }

    public static byte getType(Destination destination) {
        if (destination instanceof Queue) {
            return 1;
        }
        if (destination instanceof Topic) {
            return 2;
        }
        if (destination == null) {
            return 0;
        }
        throw new IllegalArgumentException("destination: " + String.valueOf(destination));
    }

    public static String getTypeName(byte type) {
        switch (type) {
            case 0: {
                return "NULL_DESTINATION";
            }
            case 1: {
                return "QUEUE_DESTINATION";
            }
            case 2: {
                return "TOPIC_DESTINATION";
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }

    public static String getName(Destination destination) throws JMSException {
        byte type = DestinationUtil.getType(destination);
        switch (type) {
            case 1: {
                return ((Queue)destination).getQueueName();
            }
            case 2: {
                return ((Topic)destination).getTopicName();
            }
        }
        return null;
    }

    public static DestinationImpl create(byte type, String name) {
        switch (type) {
            case 1: {
                return new QueueImpl(name);
            }
            case 2: {
                return new TopicImpl(name);
            }
        }
        return null;
    }

    public static DestinationImpl copy(Destination source) throws JMSException {
        byte type = DestinationUtil.getType(source);
        switch (type) {
            case 1: {
                return new QueueImpl(((Queue)source).getQueueName());
            }
            case 2: {
                return new TopicImpl(((Topic)source).getTopicName());
            }
        }
        return null;
    }

    public static DestinationImpl convert(Destination source) throws JMSException {
        if (source instanceof DestinationImpl) {
            return (DestinationImpl)source;
        }
        return DestinationUtil.copy(source);
    }

    public static void write(ExtendedDataOutputStream out, DestinationImpl destination) throws IOException {
        byte type = DestinationUtil.getType(destination);
        out.writeByte((int)type);
        if (type != 0) {
            out.writeString(destination.getName());
        }
    }

    public static DestinationImpl read(ExtendedDataInputStream in) throws IOException {
        byte type = in.readByte();
        String name = null;
        if (type != 0) {
            name = in.readString();
        }
        return DestinationUtil.create(type, name);
    }
}

