/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.ui.actions;

import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.net4j.buddies.IBuddySession;
import org.eclipse.net4j.buddies.ISessionManager;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.internal.ui.messages.Messages;
import org.eclipse.net4j.internal.buddies.Self;
import org.eclipse.net4j.ui.shared.SharedIcons;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class StateAction
extends SafeAction {
    private IBuddy.State state;

    public StateAction(String text, IBuddy.State state, String key) {
        super(text, 8);
        this.setToolTipText(MessageFormat.format(Messages.getString("StateAction_0"), text.toLowerCase()));
        this.setImageDescriptor(SharedIcons.getDescriptor((String)key));
        this.state = state;
    }

    public void updateState() {
        IBuddySession session = ISessionManager.INSTANCE.getSession();
        this.setEnabled(session != null);
        this.setChecked(session != null && session.getSelf().getState() == this.state);
    }

    protected void safeRun() throws Exception {
        IBuddySession session = ISessionManager.INSTANCE.getSession();
        if (session != null && this.isChecked()) {
            Self self = (Self)session.getSelf();
            self.setState(this.state);
        }
    }

    public static final class AvailableAction
    extends StateAction {
        public AvailableAction() {
            super(Messages.getString("StateAction_3"), IBuddy.State.AVAILABLE, "obj16/buddy");
        }
    }

    public static final class AwayAction
    extends StateAction {
        public AwayAction() {
            super(Messages.getString("StateAction_5"), IBuddy.State.AWAY, "obj16/buddy_away");
        }
    }

    public static final class DoNotDisturbAction
    extends StateAction {
        public DoNotDisturbAction() {
            super(Messages.getString("StateAction_6"), IBuddy.State.DO_NOT_DISTURB, "obj16/buddy_do_not_disturb");
        }
    }

    public static class DropDownAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;
        private StateAction availableAction = new AvailableAction();
        private StateAction lonesomeAction = new LonesomeAction();
        private StateAction awayAction = new AwayAction();
        private StateAction doNotDisturbAction = new DoNotDisturbAction();

        public DropDownAction() {
            this.setText(Messages.getString("StateAction_2"));
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public void updateState() {
            this.availableAction.updateState();
            this.lonesomeAction.updateState();
            this.awayAction.updateState();
            this.doNotDisturbAction.updateState();
            IBuddySession session = ISessionManager.INSTANCE.getSession();
            if (session != null) {
                this.setEnabled(true);
                IBuddy.State state = session.getSelf().getState();
                switch (state) {
                    case AVAILABLE: {
                        this.setImageDescriptor(this.availableAction.getImageDescriptor());
                        break;
                    }
                    case LONESOME: {
                        this.setImageDescriptor(this.lonesomeAction.getImageDescriptor());
                        break;
                    }
                    case AWAY: {
                        this.setImageDescriptor(this.awayAction.getImageDescriptor());
                        break;
                    }
                    case DO_NOT_DISTURB: {
                        this.setImageDescriptor(this.doNotDisturbAction.getImageDescriptor());
                    }
                }
            } else {
                this.setImageDescriptor(this.awayAction.getImageDescriptor());
                this.setEnabled(false);
            }
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            this.addActionToMenu(this.fMenu, (Action)this.availableAction);
            this.addActionToMenu(this.fMenu, (Action)this.lonesomeAction);
            this.addActionToMenu(this.fMenu, (Action)this.awayAction);
            this.addActionToMenu(this.fMenu, (Action)this.doNotDisturbAction);
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void run() {
        }

        protected void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }
    }

    public static final class LonesomeAction
    extends StateAction {
        public LonesomeAction() {
            super(Messages.getString("StateAction_4"), IBuddy.State.LONESOME, "obj16/buddy_lonesome");
        }
    }
}

