/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerLock;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.raw.xact.ContainerLocking3;
import org.apache.derby.impl.store.raw.xact.EscalateContainerKey;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class RowLocking3Escalate
extends ContainerLocking3 {
    protected RowLocking3Escalate(LockFactory lf) {
        super(lf);
    }

    @Override
    public boolean lockContainer(Transaction t, ContainerHandle container, boolean waitForLock, boolean forUpdate) throws StandardException {
        boolean gotLock;
        forUpdate = false;
        if (this.lf.isLockHeld(t.getCompatibilitySpace(), t, container.getId(), ContainerLock.CIX)) {
            forUpdate = true;
        }
        if (!(gotLock = super.lockContainer(t, container, waitForLock, forUpdate))) {
            return false;
        }
        this.lf.unlockGroup(t.getCompatibilitySpace(), t, new EscalateContainerKey(container.getId()));
        SanityManager.ASSERT(this.lf.isLockHeld(t.getCompatibilitySpace(), t, container.getId(), forUpdate ? ContainerLock.CX : ContainerLock.CS), "Covering table lock (" + (forUpdate ? ContainerLock.CX : ContainerLock.CS) + " is not held after lock escalation.");
        return true;
    }
}

