/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class TimeTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (otherType.isStringTypeId() && !otherType.isLOBTypeId() && !otherType.isLongVarcharTypeId()) {
            return true;
        }
        if (otherType.isTimestampId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == otherType.getTypeFormatId();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        int otherJDBCTypeId = otherType.getJDBCTypeId();
        if (otherJDBCTypeId == 92 || otherJDBCTypeId == 1 || otherJDBCTypeId == 12) {
            return true;
        }
        return cf.getClassInspector().assignableTo(otherType.getCorrespondingJavaTypeName(), "java.sql.Time");
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.DateTimeDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "java.sql.Time";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return 8;
    }

    public double estimatedMemoryUsage(DataTypeDescriptor dtd) {
        return 12.0;
    }

    @Override
    String nullMethodName() {
        return "getNullTime";
    }
}

