/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.services.classfile.AttributeEntry;
import org.apache.derby.iapi.services.classfile.Attributes;
import org.apache.derby.iapi.services.classfile.CONSTANT_Double_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Float_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Index_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Integer_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Long_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Utf8_info;
import org.apache.derby.iapi.services.classfile.ClassEnumeration;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassInput;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.classfile.ConstantPoolEntry;
import org.apache.derby.iapi.services.classfile.MemberTable;
import org.apache.derby.iapi.services.io.DataInputUtil;

public class ClassInvestigator
extends ClassHolder {
    public static ClassInvestigator load(InputStream is) throws IOException {
        int attributeCount;
        int methodCount;
        int fieldCount;
        ConstantPoolEntry item;
        ClassInput classInput = new ClassInput(is);
        int magic = classInput.getU4();
        int minor_version = classInput.getU2();
        int major_version = classInput.getU2();
        if (magic != -889275714) {
            throw new ClassFormatError();
        }
        int constantPoolCount = classInput.getU2();
        ClassInvestigator ci = new ClassInvestigator(constantPoolCount);
        ci.minor_version = minor_version;
        ci.major_version = major_version;
        for (int i = 1; i < constantPoolCount; i += ci.addEntry(item.getKey(), item)) {
            item = ClassInvestigator.getConstant(classInput);
        }
        ci.access_flags = classInput.getU2();
        ci.this_class = classInput.getU2();
        ci.super_class = classInput.getU2();
        int interfaceCount = classInput.getU2();
        if (interfaceCount != 0) {
            ci.interfaces = new int[interfaceCount];
            for (int i = 0; i < interfaceCount; ++i) {
                ci.interfaces[i] = classInput.getU2();
            }
        }
        if ((fieldCount = classInput.getU2()) != 0) {
            ci.field_info = new MemberTable(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                ci.field_info.addEntry(ClassInvestigator.readClassMember(ci, classInput));
            }
        }
        if ((methodCount = classInput.getU2()) != 0) {
            ci.method_info = new MemberTable(methodCount);
            for (int i = 0; i < methodCount; ++i) {
                ci.method_info.addEntry(ClassInvestigator.readClassMember(ci, classInput));
            }
        }
        if ((attributeCount = classInput.getU2()) != 0) {
            ci.attribute_info = new Attributes(attributeCount);
            for (int i = 0; i < attributeCount; ++i) {
                ci.attribute_info.addEntry(new AttributeEntry(classInput));
            }
        }
        return ci;
    }

    private static ClassMember readClassMember(ClassInvestigator ci, ClassInput in) throws IOException {
        ClassMember member = new ClassMember(ci, in.getU2(), in.getU2(), in.getU2());
        int attributeCount = in.getU2();
        if (attributeCount != 0) {
            member.attribute_info = new Attributes(attributeCount);
            for (int i = 0; i < attributeCount; ++i) {
                member.attribute_info.addEntry(new AttributeEntry(in));
            }
        }
        return member;
    }

    private ClassInvestigator(int constantPoolCount) {
        super(constantPoolCount);
    }

    public Enumeration implementedInterfaces() {
        int interfaceCount = this.interfaces == null ? 0 : this.interfaces.length;
        Vector<String> implemented = new Vector<String>(interfaceCount);
        for (int i = 0; i < interfaceCount; ++i) {
            implemented.add(this.className(this.interfaces[i]));
        }
        return implemented.elements();
    }

    public Enumeration<ClassMember> getFields() {
        if (this.field_info == null) {
            return Collections.enumeration(new Vector());
        }
        return this.field_info.entries.elements();
    }

    public Enumeration<ClassMember> getMethods() {
        if (this.method_info == null) {
            return Collections.enumeration(new Vector());
        }
        return this.method_info.entries.elements();
    }

    public Enumeration referencedClasses() {
        return this.getClasses(this.getMethods(), this.getFields());
    }

    private Enumeration getClasses(Enumeration<ClassMember> methods, Enumeration<ClassMember> fields) {
        return new ClassEnumeration(this, this.cptEntries.elements(), methods, fields);
    }

    public Enumeration getStrings() {
        HashSet<String> strings = new HashSet<String>(30, 0.8f);
        int size = this.cptEntries.size();
        for (int i = 1; i < size; ++i) {
            ConstantPoolEntry cpe = this.getEntry(i);
            if (cpe == null || cpe.getTag() != 8) continue;
            CONSTANT_Index_info cii = (CONSTANT_Index_info)cpe;
            strings.add(this.nameIndexToString(cii.getI1()));
        }
        return Collections.enumeration(strings);
    }

    public ClassMember getMember(String simpleName, String descriptor) {
        if (descriptor.startsWith("(")) {
            if (this.method_info == null) {
                return null;
            }
            return this.method_info.find(simpleName, descriptor);
        }
        if (this.field_info == null) {
            return null;
        }
        return this.field_info.find(simpleName, descriptor);
    }

    public void removeAttributes() throws IOException {
        String name;
        AttributeEntry ae;
        int i;
        Attributes attrs;
        ClassMember member;
        if (this.attribute_info != null) {
            for (int i2 = this.attribute_info.size() - 1; i2 >= 0; --i2) {
                AttributeEntry ae2 = (AttributeEntry)this.attribute_info.elementAt(i2);
                String name2 = this.nameIndexToString(ae2.getNameIndex());
                if (name2.equals("SourceFile")) {
                    this.attribute_info.removeElementAt(i2);
                    continue;
                }
                if (name2.equals("InnerClasses")) continue;
                System.err.println("WARNING - Unknown Class File attribute " + name2);
            }
            if (this.attribute_info.size() == 0) {
                this.attribute_info = null;
            }
        }
        this.attribute_info = null;
        Enumeration<ClassMember> e = this.getFields();
        while (e.hasMoreElements()) {
            member = e.nextElement();
            attrs = member.attribute_info;
            if (attrs == null) continue;
            for (i = attrs.size() - 1; i >= 0; --i) {
                ae = (AttributeEntry)attrs.elementAt(i);
                name = this.nameIndexToString(ae.getNameIndex());
                if (name.equals("ConstantValue") || name.equals("Synthetic")) continue;
                System.err.println("WARNING - Unknown Field attribute " + name);
            }
            if (attrs.size() != 0) continue;
            member.attribute_info = null;
        }
        e = this.getMethods();
        while (e.hasMoreElements()) {
            member = e.nextElement();
            attrs = member.attribute_info;
            if (attrs == null) continue;
            for (i = attrs.size() - 1; i >= 0; --i) {
                ae = (AttributeEntry)attrs.elementAt(i);
                name = this.nameIndexToString(ae.getNameIndex());
                if (name.equals("Code")) {
                    this.processCodeAttribute(member, ae);
                    continue;
                }
                if (name.equals("Exceptions") || name.equals("Deprecated") || name.equals("Synthetic")) continue;
                System.err.println("WARNING - Unknown method attribute " + name);
            }
            if (attrs.size() != 0) continue;
            member.attribute_info = null;
        }
    }

    private void processCodeAttribute(ClassMember member, AttributeEntry ae) throws IOException {
        ClassInput ci = new ClassInput(new ByteArrayInputStream(ae.infoIn));
        DataInputUtil.skipFully(ci, 4);
        int len = ci.getU4();
        DataInputUtil.skipFully(ci, len);
        int count = ci.getU2();
        if (count != 0) {
            DataInputUtil.skipFully(ci, 8 * count);
        }
        int nonAttrLength = 8 + len + 2 + 8 * count;
        count = ci.getU2();
        if (count == 0) {
            return;
        }
        int newCount = count;
        for (int i = 0; i < count; ++i) {
            int nameIndex = ci.getU2();
            String name = this.nameIndexToString(nameIndex);
            if (name.equals("LineNumberTable") || name.equals("LocalVariableTable")) {
                --newCount;
            } else {
                System.err.println("ERROR - Unknown code attribute " + name);
            }
            len = ci.getU4();
            DataInputUtil.skipFully(ci, len);
        }
        if (newCount != 0) {
            System.err.println("ERROR - expecting all code attributes to be removed");
            System.exit(1);
        }
        byte[] newInfo = new byte[nonAttrLength + 2];
        System.arraycopy(ae.infoIn, 0, newInfo, 0, nonAttrLength);
        ae.infoIn = newInfo;
    }

    public void renameClassElements(Hashtable classNameMap, Hashtable memberNameMap) {
        this.renameString(classNameMap, (CONSTANT_Index_info)this.getEntry(this.this_class));
        this.renameString(classNameMap, (CONSTANT_Index_info)this.getEntry(this.super_class));
        int size = this.cptEntries.size();
        block4: for (int i = 1; i < size; ++i) {
            ConstantPoolEntry cpe = this.getEntry(i);
            if (cpe == null) continue;
            switch (cpe.getTag()) {
                case 7: 
                case 8: {
                    CONSTANT_Index_info cii = (CONSTANT_Index_info)cpe;
                    this.renameString(classNameMap, cii);
                    continue block4;
                }
                case 12: {
                    CONSTANT_Index_info cii = (CONSTANT_Index_info)cpe;
                    String newDescriptor = ClassInvestigator.newDescriptor(classNameMap, this.nameIndexToString(cii.getI2()));
                    if (newDescriptor == null) continue block4;
                    this.doRenameString(cii.getI2(), newDescriptor);
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        this.renameMembers(this.getFields(), classNameMap, memberNameMap);
        this.renameMembers(this.getMethods(), classNameMap, memberNameMap);
    }

    private void renameMembers(Enumeration<ClassMember> e, Hashtable classNameMap, Hashtable memberNameMap) {
        while (e.hasMoreElements()) {
            String newDescriptor;
            ClassMember member = e.nextElement();
            String oldMemberName = this.nameIndexToString(member.name_index);
            String newMemberName = (String)memberNameMap.get(oldMemberName);
            if (newMemberName != null) {
                this.doRenameString(member.name_index, newMemberName);
            }
            if ((newDescriptor = ClassInvestigator.newDescriptor(classNameMap, this.nameIndexToString(member.descriptor_index))) == null) continue;
            this.doRenameString(member.descriptor_index, newDescriptor);
        }
    }

    private void renameString(Hashtable classNameMap, CONSTANT_Index_info cii) {
        int classOffset;
        String baseClassName;
        int index = cii.getI1();
        String name = this.nameIndexToString(index);
        String newName = (String)classNameMap.get(name);
        if (newName != null) {
            this.doRenameString(index, newName);
            return;
        }
        if (cii.getTag() == 7 && name.charAt(0) == '[' && (newName = (String)classNameMap.get(baseClassName = name.substring(classOffset = name.indexOf(76) + 1, name.length() - 1))) != null) {
            String newArrayClassName = name.substring(0, classOffset) + newName + ";";
            this.doRenameString(index, newArrayClassName);
        }
    }

    private void doRenameString(int index, String newName) {
        ConstantPoolEntry cpe = this.getEntry(index);
        if (cpe.getTag() != 1) {
            throw new RuntimeException("unexpected type " + cpe);
        }
        CONSTANT_Utf8_info newCpe = new CONSTANT_Utf8_info(newName);
        this.cptHashTable.remove(cpe.getKey());
        this.cptHashTable.put(newCpe.getKey(), newCpe);
        newCpe.index = index;
        this.cptEntries.set(index, newCpe);
    }

    private static ConstantPoolEntry getConstant(ClassInput in) throws IOException {
        int tag = in.getU1();
        return switch (tag) {
            case 7, 8, 16 -> new CONSTANT_Index_info(tag, in.getU2(), 0);
            case 9, 10, 11, 12, 18 -> new CONSTANT_Index_info(tag, in.getU2(), in.getU2());
            case 3 -> new CONSTANT_Integer_info(in.getU4());
            case 4 -> new CONSTANT_Float_info(in.readFloat());
            case 5 -> new CONSTANT_Long_info(in.readLong());
            case 6 -> new CONSTANT_Double_info(in.readDouble());
            case 1 -> new CONSTANT_Utf8_info(in.readUTF());
            case 15 -> new CONSTANT_Index_info(tag, in.getU1(), in.getU2());
            default -> throw new ClassFormatError("Unknown tag: " + tag);
        };
    }

    public static String newDescriptor(Hashtable classNameMap, String descriptor) {
        Object newDescriptor = null;
        int dlen = descriptor.length();
        int offset = 0;
        block3: while (offset < dlen) {
            int startPos;
            char c = descriptor.charAt(offset);
            switch (c) {
                default: {
                    ++offset;
                    continue block3;
                }
                case 'L': 
            }
            int startOffset = offset;
            while (descriptor.charAt(offset++) != ';') {
            }
            int endOffset = offset;
            String name = descriptor.substring(startOffset, endOffset);
            String newName = (String)classNameMap.get(name);
            if (newName == null) continue;
            if (newDescriptor == null) {
                newDescriptor = descriptor;
            }
            Object tmp = (startPos = ((String)newDescriptor).indexOf(name)) == 0 ? newName : ((String)newDescriptor).substring(0, startPos) + newName;
            int endPos = startPos + name.length();
            if (endPos < ((String)newDescriptor).length()) {
                tmp = (String)tmp + ((String)newDescriptor).substring(endPos, ((String)newDescriptor).length());
            }
            newDescriptor = tmp;
        }
        return newDescriptor;
    }
}

