/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.cdo.etypes.impl.ModelElementImpl;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.LMPackage;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.Process;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;

public class SystemImpl
extends ModelElementImpl
implements System {
    protected static final String NAME_EDEFAULT = null;

    protected SystemImpl() {
    }

    protected EClass eStaticClass() {
        return LMPackage.Literals.SYSTEM;
    }

    @Override
    public String getName() {
        return (String)this.eDynamicGet(1, (EStructuralFeature)LMPackage.Literals.SYSTEM__NAME, true, true);
    }

    @Override
    public void setName(String newName) {
        this.eDynamicSet(1, (EStructuralFeature)LMPackage.Literals.SYSTEM__NAME, newName);
    }

    @Override
    public Process getProcess() {
        return (Process)this.eDynamicGet(2, (EStructuralFeature)LMPackage.Literals.SYSTEM__PROCESS, true, true);
    }

    public NotificationChain basicSetProcess(Process newProcess, NotificationChain msgs) {
        msgs = this.eDynamicInverseAdd((InternalEObject)newProcess, 2, msgs);
        return msgs;
    }

    @Override
    public void setProcess(Process newProcess) {
        this.eDynamicSet(2, (EStructuralFeature)LMPackage.Literals.SYSTEM__PROCESS, newProcess);
    }

    @Override
    public EList<Module> getModules() {
        return (EList)this.eDynamicGet(3, (EStructuralFeature)LMPackage.Literals.SYSTEM__MODULES, true, true);
    }

    @Override
    public Module getModule(String name) {
        if (name != null) {
            for (Module module : this.getModules()) {
                if (!name.equals(module.getName())) continue;
                return module;
            }
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                Process process = this.getProcess();
                if (process != null) {
                    msgs = ((InternalEObject)process).eInverseRemove((InternalEObject)this, -3, null, msgs);
                }
                return this.basicSetProcess((Process)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getModules()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetProcess(null, msgs);
            }
            case 3: {
                return ((InternalEList)this.getModules()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getProcess();
            }
            case 3: {
                return this.getModules();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setProcess((Process)newValue);
                return;
            }
            case 3: {
                this.getModules().clear();
                this.getModules().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setProcess(null);
                return;
            }
            case 3: {
                this.getModules().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return NAME_EDEFAULT == null ? this.getName() != null : !NAME_EDEFAULT.equals(this.getName());
            }
            case 2: {
                return this.getProcess() != null;
            }
            case 3: {
                return !this.getModules().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.getModule((String)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public Stream<Baseline> getAllBaselines() {
        Stream<Baseline> result = null;
        for (Module module : this.getModules()) {
            Stream<Baseline> element = module.getAllBaselines();
            result = result == null ? element : Stream.concat(result, element);
        }
        return result;
    }

    @Override
    public void forEachBaseline(Consumer<Baseline> consumer) {
        for (Module module : this.getModules()) {
            module.forEachBaseline(consumer);
        }
    }

    @Override
    public boolean forEachBaseline(Predicate<Baseline> predicate) {
        for (Module module : this.getModules()) {
            if (!module.forEachBaseline(predicate)) continue;
            return true;
        }
        return false;
    }

    public static void checkName(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        String trimmed = name.trim();
        if (!Objects.equals(trimmed, name)) {
            throw new IllegalArgumentException("Name contains leading or trailing whitespace: " + name);
        }
        if (trimmed.length() == 0) {
            throw new IllegalArgumentException("Name is empty");
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Name contains a slash character: " + name);
        }
        if (name.indexOf(":") != -1) {
            throw new IllegalArgumentException("Name contains a colon character: " + name);
        }
    }

    public static boolean isValidName(String name) {
        try {
            SystemImpl.checkName(name);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return true;
    }
}

