/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalTopic;
import org.eclipse.emf.cdo.spi.server.InternalTopicManager;
import org.eclipse.net4j.util.container.Container;

public class Topic
extends Container<ISession>
implements InternalTopic {
    private final InternalTopicManager manager;
    private final Set<InternalSession> sessions = new HashSet<InternalSession>();
    private final String id;

    public Topic(InternalTopicManager manager, String id) {
        this.manager = manager;
        this.id = id;
    }

    @Override
    public InternalTopicManager getManager() {
        return this.manager;
    }

    @Override
    public String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsSession(InternalSession session) {
        Set<InternalSession> set = this.sessions;
        synchronized (set) {
            return this.sessions.contains(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalSession[] getSessions() {
        Set<InternalSession> set = this.sessions;
        synchronized (set) {
            return this.sessions.toArray(new InternalSession[this.sessions.size()]);
        }
    }

    public InternalSession[] getElements() {
        return this.getSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Set<InternalSession> set = this.sessions;
        synchronized (set) {
            return this.sessions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalSession[] addSession(InternalSession session) {
        boolean added;
        InternalSession[] otherSessions;
        Set<InternalSession> set = this.sessions;
        synchronized (set) {
            otherSessions = this.sessions.toArray(new InternalSession[this.sessions.size()]);
            added = this.sessions.add(session);
        }
        if (added) {
            this.fireElementAddedEvent(session);
        }
        return otherSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSession(InternalSession session) {
        boolean lastSession;
        boolean removed;
        Set<InternalSession> set = this.sessions;
        synchronized (set) {
            removed = this.sessions.remove(session);
            lastSession = this.sessions.isEmpty();
        }
        if (removed) {
            this.fireElementRemovedEvent(session);
        }
        if (lastSession) {
            this.manager.removeTopic(this);
        }
        return removed;
    }

    public String toString() {
        return "Topic[" + this.id + "]";
    }
}

