/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.BlobLocatorOutputStream;
import org.apache.derby.client.am.BlobOutputStream;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.UpdateSensitiveBlobLocatorInputStream;

public class ClientBlob
extends Lob
implements Blob {
    byte[] binaryString_ = null;
    InputStream binaryStream_ = null;
    int dataOffset_;

    public ClientBlob(byte[] binaryString, Agent agent, int dataOffset) {
        super(agent, false);
        this.binaryString_ = binaryString;
        this.dataType_ |= 0x40;
        this.setSqlLength(binaryString.length - dataOffset);
        this.dataOffset_ = dataOffset;
    }

    ClientBlob(Agent agent, InputStream binaryStream, int length) {
        super(agent, false);
        this.binaryStream_ = binaryStream;
        this.dataType_ |= 0x20;
        this.setSqlLength(length);
    }

    ClientBlob(Agent agent, InputStream binaryStream) {
        super(agent, ClientBlob.isLayerBStreamingPossible(agent));
        this.binaryStream_ = binaryStream;
        this.dataType_ |= 0x20;
    }

    public ClientBlob(Agent agent, int locator) {
        super(agent, false);
        this.locator_ = locator;
        this.dataType_ |= 0x80;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "length", new Object[0]);
                }
                this.checkForClosedConnection();
                long retVal = super.sqlLength();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "length", retVal);
                }
                return retVal;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    long getLocatorLength() throws SqlException {
        return this.agent_.connection_.locatorProcedureCall().blobGetLength(this.locator_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBytes", (int)pos, length);
                }
                if (pos <= 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), pos);
                }
                if (pos > this.sqlLength() + 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), pos);
                }
                if (length < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), length);
                }
                byte[] retVal = this.getBytesX(pos, length);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBytes", retVal);
                }
                return retVal;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private byte[] getBytesX(long pos, int length) throws SqlException {
        byte[] retVal;
        this.checkForClosedConnection();
        long actualLength = Math.min(this.sqlLength() - pos + 1L, (long)length);
        if (this.isLocator()) {
            retVal = this.agent_.connection_.locatorProcedureCall().blobGetBytes(this.locator_, pos, (int)actualLength);
        } else {
            retVal = new byte[(int)actualLength];
            System.arraycopy(this.binaryString_, (int)pos + this.dataOffset_ - 1, retVal, 0, (int)actualLength);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBinaryStream", new Object[0]);
                }
                InputStream retVal = this.getBinaryStreamX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBinaryStream", retVal);
                }
                return retVal;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    InputStream getBinaryStreamX() throws SqlException {
        this.checkForClosedConnection();
        if (this.isBinaryStream()) {
            return this.binaryStream_;
        }
        if (this.isLocator()) {
            return new UpdateSensitiveBlobLocatorInputStream(this.agent_.connection_, this);
        }
        return new ByteArrayInputStream(this.binaryString_, this.dataOffset_, this.binaryString_.length - this.dataOffset_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "position(byte[], long)", pattern, start);
                }
                if (pattern == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"), new Object[0]);
                }
                if (start < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), start);
                }
                long pos = this.positionX(pattern, start);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(byte[], long)", pos);
                }
                return pos;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private long positionX(byte[] pattern, long start) throws SqlException {
        this.checkForClosedConnection();
        if (this.isLocator()) {
            return this.agent_.connection_.locatorProcedureCall().blobGetPositionFromBytes(this.locator_, pattern, start);
        }
        return this.binaryStringPosition(pattern, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(Blob pattern, long start) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "position(Blob, long)", pattern, start);
                }
                if (pattern == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"), new Object[0]);
                }
                if (start < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), start);
                }
                long pos = this.positionX(pattern, start);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(Blob, long)", pos);
                }
                return pos;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private long positionX(Blob pattern, long start) throws SqlException {
        this.checkForClosedConnection();
        try {
            if (this.isLocator()) {
                if (pattern instanceof ClientBlob && ((ClientBlob)pattern).isLocator()) {
                    return this.agent_.connection_.locatorProcedureCall().blobGetPositionFromLocator(this.locator_, ((ClientBlob)pattern).getLocator(), start);
                }
                return this.agent_.connection_.locatorProcedureCall().blobGetPositionFromBytes(this.locator_, pattern.getBytes(1L, (int)pattern.length()), start);
            }
            return this.binaryStringPosition(pattern.getBytes(1L, (int)pattern.length()), start);
        }
        catch (SQLException e) {
            throw new SqlException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setBytes", (int)pos, bytes);
                }
                int length = this.setBytesX(pos, bytes, 0, bytes.length);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setBytes", length);
                }
                return length;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setBytes", (int)pos, bytes, offset, len);
                }
                int length = this.setBytesX(pos, bytes, offset, len);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setBytes", length);
                }
                return length;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    int setBytesX(long pos, byte[] bytes, int offset, int len) throws SqlException {
        if (pos <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), pos);
        }
        if (pos >= Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), pos);
        }
        if (pos - 1L > this.sqlLength()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), pos);
        }
        if (offset < 0 || offset > bytes.length) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ078.S"), offset);
        }
        if (len < 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), len);
        }
        if (len == 0) {
            return 0;
        }
        if (len > bytes.length - offset) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ079.S"), len);
        }
        int length = Math.min(bytes.length - offset, len);
        if (this.isLocator()) {
            byte[] ba = bytes;
            if (offset > 0 || length < bytes.length) {
                ba = new byte[length];
                System.arraycopy(bytes, offset, ba, 0, length);
            }
            this.agent_.connection_.locatorProcedureCall().blobSetBytes(this.locator_, pos, length, ba);
            if (pos + (long)length - 1L > this.sqlLength()) {
                this.setSqlLength(pos + (long)length - 1L);
            }
            this.incrementUpdateCount();
        } else {
            if (this.binaryString_.length - this.dataOffset_ - (int)pos + 1 < length) {
                byte[] newbuf = new byte[(int)pos + length + this.dataOffset_ - 1];
                System.arraycopy(this.binaryString_, 0, newbuf, 0, this.binaryString_.length);
                this.binaryString_ = newbuf;
            }
            System.arraycopy(bytes, offset, this.binaryString_, (int)pos + this.dataOffset_ - 1, length);
            this.binaryStream_ = new ByteArrayInputStream(this.binaryString_);
            this.setSqlLength(this.binaryString_.length - this.dataOffset_);
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setBinaryStream", (int)pos);
                }
                if (pos < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), pos);
                }
                OutputStream outStream = this.isLocator() ? new BlobLocatorOutputStream(this.agent_.connection_, this, pos) : new BlobOutputStream(this, pos);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setBinaryStream", outStream);
                }
                return outStream;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long len) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, " truncate", (int)len);
                }
                if (len < 0L || len > this.sqlLength()) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), len, "len", "Blob.truncate()");
                }
                if (len == this.sqlLength()) {
                    return;
                }
                if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().blobTruncate(this.locator_, len);
                    this.setSqlLength(len);
                    this.incrementUpdateCount();
                } else {
                    long newLength = (int)len + this.dataOffset_;
                    byte[] newbuf = new byte[(int)len + this.dataOffset_];
                    System.arraycopy(this.binaryString_, 0, newbuf, 0, (int)newLength);
                    this.binaryString_ = newbuf;
                    this.binaryStream_ = new ByteArrayInputStream(this.binaryString_);
                    this.setSqlLength(this.binaryString_.length - this.dataOffset_);
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws SQLException {
        if (!this.isValid_) {
            return;
        }
        this.isValid_ = false;
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "free", new Object[0]);
                }
                if (this.isBinaryStream()) {
                    try {
                        this.binaryStream_.close();
                    }
                    catch (IOException ioe) {
                        throw new SqlException(null, new ClientMessageId("XJ214.S"), new Object[0]);
                    }
                } else if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().blobReleaseLocator(this.locator_);
                } else {
                    this.binaryString_ = null;
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBinaryStream", (int)pos, length);
                }
                this.checkPosAndLength(pos, length);
                InputStream retVal = this.isLocator() ? new UpdateSensitiveBlobLocatorInputStream(this.agent_.connection_, this, pos, length) : new ByteArrayInputStream(this.binaryString_, (int)((long)this.dataOffset_ + pos - 1L), (int)length);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBinaryStream", retVal);
                }
                return retVal;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public boolean isBinaryString() {
        return (this.dataType_ & 0x40) == 64;
    }

    public boolean isBinaryStream() {
        return (this.dataType_ & 0x20) == 32;
    }

    private long binaryStringPosition(byte[] pattern, long start) {
        int index = (int)start + this.dataOffset_ - 1;
        while (index + pattern.length <= this.binaryString_.length) {
            if (this.isSubString(pattern, index)) {
                return index - this.dataOffset_ + 1;
            }
            ++index;
        }
        return -1L;
    }

    private boolean isSubString(byte[] pattern, int index) {
        int i = 0;
        while (i < pattern.length) {
            if (pattern[i] != this.binaryString_[index]) {
                return false;
            }
            ++i;
            ++index;
        }
        return true;
    }

    @Override
    protected void materializeStream() throws SqlException {
        this.binaryStream_ = super.materializeStream(this.binaryStream_, "java.sql.Blob");
    }
}

