/*
 * Copyright (c) 2009-2012, 2015, 2019 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.spi.common.model;

import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry.PackageLoader;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;

import java.io.IOException;

/**
 * If the meaning of this type isn't clear, there really should be more of a description here...
 *
 * @author Eike Stepper
 * @since 2.0
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface InternalCDOPackageUnit extends CDOPackageUnit
{
  @Override
  public InternalCDOPackageRegistry getPackageRegistry();

  public void setPackageRegistry(InternalCDOPackageRegistry packageRegistry);

  public void setState(State state);

  public void setOriginalType(Type originalType);

  public void setTimeStamp(long timeStamp);

  @Override
  public InternalCDOPackageInfo getTopLevelPackageInfo();

  @Override
  public InternalCDOPackageInfo getPackageInfo(String packageURI);

  @Override
  public InternalCDOPackageInfo[] getPackageInfos();

  public void setPackageInfos(InternalCDOPackageInfo[] packageInfos);

  /**
   * @since 4.0
   */
  public void load(boolean resolve);

  /**
   * @since 4.0
   */
  public void load(PackageLoader packageLoader, boolean resolve);

  /**
   * @since 3.0
   */
  public void write(CDODataOutput out, boolean withPackages) throws IOException;

  /**
   * @since 3.0
   */
  public void read(CDODataInput in, ResourceSet resourceSet) throws IOException;

  /**
   * @since 4.4
   */
  public InternalCDOPackageUnit copy();

  public void init(EPackage ePackage);

  public void dispose();
}
