/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.debug.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.mwe.internal.core.debug.model.VarValueTO;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugElement;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugTarget;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugVariable;
import org.eclipse.emf.mwe.internal.ui.debug.model.ui.VariableSorter;

public class DebugValue
extends DebugElement
implements IValue {
    private VarValueTO varTO;
    private boolean dirty;
    private List<DebugVariable> variables = new ArrayList<DebugVariable>();

    public DebugValue(DebugTarget target, VarValueTO varTO) {
        super(target);
        this.varTO = varTO;
    }

    public void setVarTO(VarValueTO varTO) {
        this.varTO = varTO;
    }

    public int getVarTOId() {
        return this.varTO.valueId;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String getReferenceTypeName() {
        return "";
    }

    public String getValueString() {
        return this.varTO.simpleRep + (String)(this.varTO.valueId > 0 ? " (id=" + this.varTO.valueId + ")" : "");
    }

    public String getDetailRep() {
        return this.varTO.stringRep;
    }

    public boolean isAllocated() {
        return true;
    }

    public boolean hasVariables() {
        return this.varTO.hasMembers;
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (this.varTO.hasMembers && this.variables.isEmpty() || this.dirty) {
            List<VarValueTO> vars = this.getDebugModelManager().requireSubVariables(this.varTO.valueId);
            if (this.dirty) {
                ArrayList<DebugVariable> oldVars = new ArrayList<DebugVariable>();
                oldVars.addAll(this.variables);
                for (VarValueTO varTO : vars) {
                    DebugVariable var2;
                    boolean varFound = false;
                    for (DebugVariable var2 : this.variables) {
                        if (!var2.getName().equals(varTO.name)) continue;
                        varFound = true;
                        if (varTO.valueId == 0) {
                            var2.getValue0().setVarTO(varTO);
                            break;
                        }
                        if (var2.getValue0().getVarTOId() != varTO.valueId) {
                            var2.setValue(varTO);
                            break;
                        }
                        oldVars.remove((Object)var2);
                        break;
                    }
                    if (varFound) continue;
                    var2 = new DebugVariable(this.getDebugTarget0(), varTO);
                    this.variables.add(var2);
                }
                for (DebugVariable var : oldVars) {
                    this.variables.remove((Object)var);
                }
            } else {
                for (VarValueTO varTO : vars) {
                    DebugVariable var = new DebugVariable(this.getDebugTarget0(), varTO);
                    this.variables.add(var);
                }
            }
            this.dirty = false;
            VariableSorter.sort(this.variables);
        }
        return this.variables.toArray(new IVariable[0]);
    }
}

