/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.views;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.modisco.facet.common.ui.internal.controls.PersistableColumn;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.modisco.infra.discovery.ui.Messages;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class DiscoverersView
extends ViewPart {
    private TableViewer discoverersViewer;
    private TableViewer parametersViewer;
    private Composite parentComposite;
    private Composite mainComposite;
    private static final String NAME_COLUMN = "DiscoverersView_NameColumn";
    private static final String TYPE_COLUMN = "DiscoverersView_DescriptionColumn";
    private static final String INPUT_TYPE_COLUMN = "DiscoverersView_InputTypeColumn";
    private static final String DECLARING_BUNDLE_COLUMN = "DiscoverersView_DeclaringBundleColumn";
    private static final String PARAM_NAME_COLUMN = "DiscoverersView_ParamName";
    private static final String PARAM_TYPE_COLUMN = "DiscoverersView_ParamType";
    private static final String PARAM_DIRECTION_COLUMN = "DiscoverersView_ParamDirection";
    private static final String PARAM_REQUIRED_COLUMN = "DiscoverersView_ParamRequired";
    private static final String PARAM_DESCRIPTION_COLUMN = "DiscoverersView_ParamDescription";
    private static final int NAME_COLUMN_WIDTH = 200;
    private static final int TYPE_COLUMN_WIDTH = 150;
    private static final int DECLARING_BUNDLE_COLUMN_WIDTH = 400;
    private static final int INPUT_TYPE_COLUMN_WIDTH = 150;
    private static final int PARAM_NAME_COLUMN_WIDTH = 160;
    private static final int PARAM_TYPE_COLUMN_WIDTH = 100;
    private static final int PARAM_DIRECTION_COLUMN_WIDTH = 60;
    private static final int PARAM_REQUIRED_COLUMN_WIDTH = 60;
    private static final int PARAM_DESCRIPTION_COLUMN_WIDTH = 400;
    private static final String SASH_POSITION1 = "sashPosition1";
    private static final String SASH_POSITION2 = "sashPosition2";
    private static final String LAYOUT_ORIENTATION = "orientation";
    private static LayoutStyle layoutStyle = LayoutStyle.Vertical;
    private PersistableColumn nameColumn;
    private PersistableColumn implClassColumn;
    private PersistableColumn paramNameColumn;
    private PersistableColumn paramTypeColumn;
    private PersistableColumn paramDirectionColumn;
    private PersistableColumn paramRequiredColumn;
    private PersistableColumn paramDescColumn;
    private PersistableColumn inputTypeColumn;
    private PersistableColumn declaringBundleColumn;
    private SashForm sashForm;
    private static Integer sashPosition1;
    private static Integer sashPosition2;
    private final Action horizontalLayoutAction = new Action(Messages.DiscoverersView_horizontal, 8){

        public ImageDescriptor getImageDescriptor() {
            return Activator.getImageDescriptor("icons/th_horizontal.gif");
        }

        public void run() {
            DiscoverersView.this.changeLayoutStyle(LayoutStyle.Horizontal);
        }
    };
    private final Action verticalLayoutAction = new Action(Messages.DiscoverersView_vertical, 8){

        public ImageDescriptor getImageDescriptor() {
            return Activator.getImageDescriptor("icons/th_vertical.gif");
        }

        public void run() {
            DiscoverersView.this.changeLayoutStyle(LayoutStyle.Vertical);
        }
    };

    protected static LayoutStyle getLayoutStyle() {
        return layoutStyle;
    }

    protected void changeLayoutStyle(LayoutStyle newLayoutStyle) {
        if (newLayoutStyle == layoutStyle) {
            return;
        }
        layoutStyle = newLayoutStyle;
        this.createMainComposite();
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        parent.setLayout((Layout)DiscoverersView.gridLayoutWithNoMargins());
        this.createMainComposite();
    }

    private void createMainComposite() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        this.mainComposite = new Composite(this.parentComposite, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)DiscoverersView.gridLayoutWithNoMargins());
        int direction = layoutStyle == LayoutStyle.Horizontal ? 256 : 512;
        this.sashForm = new SashForm(this.mainComposite, 0x10000 | direction);
        this.sashForm.setLayout((Layout)new FillLayout());
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Group discoverersGroup = this.createDiscoverersGroup((Composite)this.sashForm);
        this.createParametersGroup((Composite)this.sashForm);
        discoverersGroup.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                sashPosition1 = new Integer(DiscoverersView.this.sashForm.getWeights()[0]);
                sashPosition2 = new Integer(DiscoverersView.this.sashForm.getWeights()[1]);
            }
        });
        if (sashPosition1 != null && sashPosition2 != null) {
            this.sashForm.setWeights(new int[]{sashPosition1, sashPosition2});
        }
        this.parentComposite.layout();
    }

    private Group createDiscoverersGroup(Composite parent) {
        Group contextGroup = new Group(parent, 0);
        contextGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        contextGroup.setText(Messages.DiscoverersView_title);
        GridLayout groupLayout = new GridLayout();
        contextGroup.setLayout((Layout)groupLayout);
        this.createDiscoverersViewer(contextGroup);
        return contextGroup;
    }

    private void createDiscoverersViewer(Group contextGroup) {
        this.discoverersViewer = new TableViewer((Composite)contextGroup, 68356);
        this.discoverersViewer.getTable().setLinesVisible(true);
        this.discoverersViewer.getTable().setHeaderVisible(true);
        this.discoverersViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.discoverersViewer.setContentProvider(DiscoverersView.getDiscoverersContentProvider());
        this.createDiscovererNameColumn(this.discoverersViewer);
        this.createDiscovererInputTypeColumn(this.discoverersViewer);
        this.createDiscovererImplClassColumn(this.discoverersViewer);
        this.createDiscovererDeclaringBundleColumn(this.discoverersViewer);
        this.discoverersViewer.setInput(DiscoverersView.getDiscoverersInput());
        this.discoverersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DiscoverersView.this.discovererSelectionChanged();
            }
        });
    }

    private void discovererSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.discoverersViewer.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof DiscovererDescription) {
            DiscovererDescription discovererDescription = (DiscovererDescription)firstElement;
            this.parametersViewer.setInput((Object)discovererDescription);
        }
    }

    private void createParametersGroup(Composite parent) {
        Group contextGroup = new Group(parent, 0);
        contextGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        contextGroup.setText(Messages.DiscoverersView_params);
        GridLayout groupLayout = new GridLayout();
        contextGroup.setLayout((Layout)groupLayout);
        this.createParametersViewer(contextGroup);
    }

    private void createParametersViewer(Group contextGroup) {
        this.parametersViewer = new TableViewer((Composite)contextGroup, 68356);
        this.parametersViewer.getTable().setLinesVisible(true);
        this.parametersViewer.getTable().setHeaderVisible(true);
        this.parametersViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.parametersViewer.setContentProvider(DiscoverersView.getParametersContentProvider());
        this.createParameterNameColumn(this.parametersViewer);
        this.createParameterTypeColumn(this.parametersViewer);
        this.createParameterDirectionColumn(this.parametersViewer);
        this.createParameterRequiredColumn(this.parametersViewer);
        this.createParameterDescriptionColumn(this.parametersViewer);
    }

    private static IContentProvider getParametersContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                DiscovererDescription discovererDescription = (DiscovererDescription)inputElement;
                EList parameterDefinitions = discovererDescription.getParameterDefinitions();
                return parameterDefinitions.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
    }

    private static GridLayout gridLayoutWithNoMargins() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    public void setFocus() {
    }

    private void createDiscovererNameColumn(TableViewer viewer) {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){
            private Image discovererImage;

            public String getText(Object element) {
                DiscovererDescription discovererDescription = (DiscovererDescription)element;
                return discovererDescription.getId();
            }

            public Image getImage(Object element) {
                if (this.discovererImage == null) {
                    this.discovererImage = Activator.getImageDescriptor("icons/discoverer16x16.png").createImage();
                }
                return this.discovererImage;
            }

            public void dispose() {
                super.dispose();
                if (this.discovererImage != null) {
                    this.discovererImage.dispose();
                }
            }
        };
        this.nameColumn = new PersistableColumn(Messages.DiscoverersView_name, NAME_COLUMN, 200, columnLabelProvider, viewer);
    }

    private void createDiscovererImplClassColumn(TableViewer viewer) {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                DiscovererDescription discovererDescription = (DiscovererDescription)element;
                return discovererDescription.getImplementationType().getName();
            }
        };
        this.implClassColumn = new PersistableColumn(Messages.DiscoverersView_implClass, TYPE_COLUMN, 150, columnLabelProvider, viewer);
    }

    private void createDiscovererDeclaringBundleColumn(TableViewer viewer) {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                DiscovererDescription discovererDescription = (DiscovererDescription)element;
                return discovererDescription.getImplementationBundle().getSymbolicName();
            }
        };
        this.declaringBundleColumn = new PersistableColumn(Messages.DiscoverersView_declaringBundle, DECLARING_BUNDLE_COLUMN, 400, columnLabelProvider, viewer);
    }

    private void createDiscovererInputTypeColumn(TableViewer viewer) {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                DiscovererDescription discovererDescription = (DiscovererDescription)element;
                return discovererDescription.getSourceType().getName();
            }
        };
        this.inputTypeColumn = new PersistableColumn(Messages.DiscoverersView_inputType, INPUT_TYPE_COLUMN, 150, columnLabelProvider, viewer);
    }

    private void createParameterNameColumn(TableViewer viewer) {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                DiscovererParameter discoveryParameter = (DiscovererParameter)element;
                return discoveryParameter.getId();
            }
        };
        this.paramNameColumn = new PersistableColumn(Messages.DiscoverersView_name, PARAM_NAME_COLUMN, 160, columnLabelProvider, viewer);
    }

    private void createParameterTypeColumn(TableViewer viewer) {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                DiscovererParameter discoveryParameter = (DiscovererParameter)element;
                return discoveryParameter.getType().getSimpleName();
            }
        };
        this.paramTypeColumn = new PersistableColumn(Messages.DiscoverersView_type, PARAM_TYPE_COLUMN, 100, columnLabelProvider, viewer);
    }

    private void createParameterDirectionColumn(TableViewer viewer) {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                DiscovererParameter discoveryParameter = (DiscovererParameter)element;
                return discoveryParameter.getDirection().toString();
            }
        };
        this.paramDirectionColumn = new PersistableColumn(Messages.DiscoverersView_direction, PARAM_DIRECTION_COLUMN, 60, columnLabelProvider, viewer);
    }

    private void createParameterRequiredColumn(TableViewer viewer) {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                DiscovererParameter discoveryParameter = (DiscovererParameter)element;
                return Boolean.toString(discoveryParameter.isRequiredInput());
            }
        };
        this.paramRequiredColumn = new PersistableColumn(Messages.DiscoverersView_required, PARAM_REQUIRED_COLUMN, 60, columnLabelProvider, viewer);
    }

    private void createParameterDescriptionColumn(TableViewer viewer) {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                DiscovererParameter discoveryParameter = (DiscovererParameter)element;
                return discoveryParameter.getDescription();
            }
        };
        this.paramDescColumn = new PersistableColumn(Messages.DiscoverersView_description, PARAM_DESCRIPTION_COLUMN, 400, columnLabelProvider, viewer);
    }

    protected static IContentProvider getDiscoverersContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Collection discovererDescription = (Collection)inputElement;
                return discovererDescription.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
    }

    protected static Object getDiscoverersInput() {
        return IDiscoveryManager.INSTANCE.getDiscoverers();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        site.getActionBars().getToolBarManager().add((IAction)this.horizontalLayoutAction);
        site.getActionBars().getToolBarManager().add((IAction)this.verticalLayoutAction);
        if (memento != null) {
            PersistableColumn.loadState((IMemento)memento, (String)NAME_COLUMN);
            PersistableColumn.loadState((IMemento)memento, (String)TYPE_COLUMN);
            PersistableColumn.loadState((IMemento)memento, (String)INPUT_TYPE_COLUMN);
            PersistableColumn.loadState((IMemento)memento, (String)DECLARING_BUNDLE_COLUMN);
            PersistableColumn.loadState((IMemento)memento, (String)PARAM_NAME_COLUMN);
            PersistableColumn.loadState((IMemento)memento, (String)PARAM_TYPE_COLUMN);
            PersistableColumn.loadState((IMemento)memento, (String)PARAM_DIRECTION_COLUMN);
            PersistableColumn.loadState((IMemento)memento, (String)PARAM_REQUIRED_COLUMN);
            PersistableColumn.loadState((IMemento)memento, (String)PARAM_DESCRIPTION_COLUMN);
            sashPosition1 = memento.getInteger(SASH_POSITION1);
            sashPosition2 = memento.getInteger(SASH_POSITION2);
            String layout = memento.getString(LAYOUT_ORIENTATION);
            if (layout != null) {
                layoutStyle = LayoutStyle.valueOf(layout);
            }
        }
        if (layoutStyle == LayoutStyle.Horizontal) {
            this.horizontalLayoutAction.setChecked(true);
        } else {
            this.verticalLayoutAction.setChecked(true);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.nameColumn.saveState(memento);
        this.implClassColumn.saveState(memento);
        this.inputTypeColumn.saveState(memento);
        this.declaringBundleColumn.saveState(memento);
        this.paramNameColumn.saveState(memento);
        this.paramTypeColumn.saveState(memento);
        this.paramDirectionColumn.saveState(memento);
        this.paramRequiredColumn.saveState(memento);
        this.paramDescColumn.saveState(memento);
        memento.putInteger(SASH_POSITION1, this.sashForm.getWeights()[0]);
        memento.putInteger(SASH_POSITION2, this.sashForm.getWeights()[1]);
        memento.putString(LAYOUT_ORIENTATION, layoutStyle.name());
    }

    private static enum LayoutStyle {
        Horizontal,
        Vertical;

    }
}

