/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.AbstractCompilerStep;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.GenModelCompilerStep;
import org.eclipse.qvtd.compiler.internal.qvtc2qvtu.QVTuConfiguration;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.runtime.evaluation.Transformer;

public class QVTrCompilerChain
extends AbstractCompilerChain {
    protected final @NonNull Xtext2QVTrCompilerStep xtext2qvtrCompilerStep = this.createXtext2QVTrCompilerStep();
    protected final @NonNull QVTr2QVTcCompilerStep qvtr2qvtcCompilerStep = this.createQVTr2QVTcCompilerStep();
    protected final @NonNull GenModelCompilerStep genmodelCompilerStep = this.createGenModelCompilerStep();
    protected final @NonNull TraceCompilerStep traceCompilerStep = this.createTraceCompilerStep();

    public QVTrCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull URI prefixURI, @NonNull CompilerOptions options) {
        super(environmentFactory, txURI, prefixURI, options);
    }

    @Override
    public @NonNull ImperativeTransformation compile(@NonNull String enforcedOutputName) throws IOException {
        Resource rResource = this.xtext2qvtrCompilerStep.execute(this.txURI);
        return this.compileQVTrAS(rResource, enforcedOutputName);
    }

    protected @NonNull ImperativeTransformation compileQVTrAS(@NonNull Resource rResource, @NonNull String enforcedOutputName) throws IOException {
        QVTr2QVTc t = new QVTr2QVTc((EnvironmentFactory)this.environmentFactory, rResource);
        t.analyze();
        Resource traceResource = this.traceCompilerStep.execute(t);
        Resource cResource = this.qvtr2qvtcCompilerStep.execute(t, rResource);
        QVTuConfiguration qvtuConfiguration = this.createQVTuConfiguration(cResource, QVTuConfiguration.Mode.ENFORCE, enforcedOutputName);
        Resource pResource = this.qvtc2qvtm(cResource, qvtuConfiguration);
        return this.qvtm2qvti(pResource);
    }

    protected @NonNull GenModelCompilerStep createGenModelCompilerStep() {
        return new GenModelCompilerStep(this);
    }

    protected @NonNull QVTr2QVTcCompilerStep createQVTr2QVTcCompilerStep() {
        return new QVTr2QVTcCompilerStep(this);
    }

    protected @NonNull TraceCompilerStep createTraceCompilerStep() {
        return new TraceCompilerStep(this);
    }

    protected @NonNull Xtext2QVTrCompilerStep createXtext2QVTrCompilerStep() {
        return new Xtext2QVTrCompilerStep(this);
    }

    @Override
    public @NonNull Class<? extends Transformer> generate(@NonNull ImperativeTransformation asTransformation, String ... genModelFiles) throws Exception {
        this.genmodelCompilerStep.execute();
        return super.generate(asTransformation, genModelFiles);
    }

    protected static class QVTr2QVTcCompilerStep
    extends AbstractCompilerStep {
        public QVTr2QVTcCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTc");
        }

        protected void doQVTcSerializeAndLoad(@NonNull URI asURI, @NonNull URI csURI) throws IOException {
        }

        public @NonNull Resource execute(@NonNull QVTr2QVTc t, @NonNull Resource rResource) throws IOException {
            QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = this.environmentFactory.setCreateStrategy(QVTrEnvironmentFactory.CREATE_STRATEGY);
            try {
                URI txURI;
                URI qvtcURI = this.compilerChain.getURI("QVTc", URI_KEY);
                t.transformToCoreTransformations();
                Map saveOptions = (Map)this.compilerChain.basicGetOption("QVTc", SAVE_OPTIONS_KEY);
                if (saveOptions == null) {
                    saveOptions = XMIUtil.createSaveOptions();
                }
                Resource cResource = this.compilerChain.createResource(qvtcURI);
                t.saveCore(cResource, saveOptions);
                QVTrCompilerChain.assertNoResourceSetErrors("Core save", cResource);
                this.compiled(cResource);
                if (this.basicGetOption(DEBUG_KEY) == Boolean.TRUE && (txURI = cResource.getURI()) != null) {
                    URI inputURI = txURI;
                    URI serializedURI = txURI.trimFileExtension().appendFileExtension("serialized.qvtc");
                    this.doQVTcSerializeAndLoad(inputURI, serializedURI);
                }
                Resource resource = cResource;
                return resource;
            }
            finally {
                this.environmentFactory.setCreateStrategy(savedStrategy);
            }
        }
    }

    protected static class TraceCompilerStep
    extends AbstractCompilerStep {
        public TraceCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "Trace");
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Resource execute(@NonNull QVTr2QVTc t) throws IOException {
            QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = this.environmentFactory.setCreateStrategy(QVTrEnvironmentFactory.CREATE_STRATEGY);
            try {
                URI traceURI = this.compilerChain.getURI("Trace", URI_KEY);
                @NonNull @Nullable Map traceOptions = (Map)this.compilerChain.basicGetOption("Trace", TRACE_OPTIONS_KEY);
                String traceNsURI = traceOptions != null ? (String)traceOptions.get("traceNsURI") : null;
                Resource traceResource = this.createResource(PivotUtilInternal.getASURI((URI)traceURI));
                if (traceNsURI != null) {
                    t.setTraceNsURI(traceNsURI);
                }
                t.transformToTracePackages();
                Map saveOptions = (Map)this.compilerChain.basicGetOption("Trace", SAVE_OPTIONS_KEY);
                if (saveOptions == null) {
                    saveOptions = XMIUtil.createSaveOptions();
                }
                t.saveTrace(traceResource, traceURI, traceOptions, saveOptions);
                QVTrCompilerChain.assertNoResourceSetErrors("Trace save", traceResource);
                this.compiled(traceResource);
                URI genModelURI = this.compilerChain.basicGetURI("GenModel", URI_KEY);
                if (genModelURI != null) {
                    saveOptions = (Map)this.compilerChain.basicGetOption("GenModel", SAVE_OPTIONS_KEY);
                    if (saveOptions == null) {
                        saveOptions = XMIUtil.createSaveOptions();
                    }
                    saveOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                    String modelDirectory = (String)this.compilerChain.basicGetOption("GenModel", GENMODEL_MODEL_DIRECTORY_KEY);
                    @NonNull @Nullable Map genmodelOptions = (Map)this.compilerChain.basicGetOption("GenModel", GENMODEL_OPTIONS_KEY);
                    @NonNull Collection usedGenPackages = (Collection)this.compilerChain.basicGetOption("GenModel", GENMODEL_USED_GENPACKAGES_KEY);
                    t.saveGenModel(this, traceResource, traceURI, genModelURI, modelDirectory, genmodelOptions, saveOptions, usedGenPackages);
                }
                Resource resource = traceResource;
                return resource;
            }
            finally {
                this.environmentFactory.setCreateStrategy(savedStrategy);
            }
        }
    }

    protected static class Xtext2QVTrCompilerStep
    extends AbstractCompilerStep {
        public Xtext2QVTrCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTr");
        }

        public @NonNull Resource execute(@NonNull URI txURI) throws IOException {
            ASResource rResource = QVTrelationUtil.loadTransformations((QVTbaseEnvironmentFactory)this.environmentFactory, (URI)txURI, (boolean)false);
            rResource.setURI(this.getURI());
            List missingOperationCallSources = QVTbaseUtil.rewriteMissingOperationCallSources((EnvironmentFactory)this.environmentFactory, (Resource)rResource);
            if (missingOperationCallSources != null) {
                System.err.println("Missing OperationCallExp sources were fixed up for '" + txURI + "'");
            }
            QVTrCompilerChain.checkForProxyURIs((Resource)rResource);
            this.saveResource((Resource)rResource);
            return rResource;
        }
    }
}

