/**
 * Copyright (c) 2015, 2018 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   E.D.Willink - Initial API and implementation
 */
package org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.trace_ATL2QVTrFactory
 * @model kind="package"
 * @generated
 */
public interface trace_ATL2QVTrPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "trace_ATL2QVTr";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/qvtd-example/org/eclipse/qvtd/atl/atl2qvtr/ATL2QVTr";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "PATL2QVTr";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	trace_ATL2QVTrPackage eINSTANCE = org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapBindingImpl <em>TC map Binding</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapBindingImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapBinding()
	 * @generated
	 */
	int TC_MAP_BINDING = 0;

	/**
	 * The feature id for the '<em><b>Atl atl Binding</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BINDING__ATL_ATL_BINDING = 0;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BINDING__ATL_ATL_EXPRESSION = 1;

	/**
	 * The feature id for the '<em><b>Atl atl Out Pattern Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BINDING__ATL_ATL_OUT_PATTERN_ELEMENT = 2;

	/**
	 * The feature id for the '<em><b>Primitive property Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BINDING__PRIMITIVE_PROPERTY_NAME = 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BINDING__QVTR_QVTR_EXPRESSION = 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Part</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BINDING__QVTR_QVTR_PART = 5;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Template</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BINDING__QVTR_QVTR_TEMPLATE = 6;

	/**
	 * The number of structural features of the '<em>TC map Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BINDING_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>TC map Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BINDING_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOclExpressionImpl <em>TI map Ocl Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOclExpressionImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapOclExpression()
	 * @generated
	 */
	int TI_MAP_OCL_EXPRESSION = 43;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OCL_EXPRESSION__ATL_ATL_EXPRESSION = 0;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OCL_EXPRESSION__QVTR_QVTR_EXPRESSION = 1;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OCL_EXPRESSION__STATUS = 2;

	/**
	 * The number of structural features of the '<em>TI map Ocl Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OCL_EXPRESSION_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>TI map Ocl Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OCL_EXPRESSION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapBooleanExpImpl <em>TI map Boolean Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapBooleanExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapBooleanExp()
	 * @generated
	 */
	int TI_MAP_BOOLEAN_EXP = 34;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_BOOLEAN_EXP__ATL_ATL_EXPRESSION = TI_MAP_OCL_EXPRESSION__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_BOOLEAN_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_OCL_EXPRESSION__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_BOOLEAN_EXP__STATUS = TI_MAP_OCL_EXPRESSION__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Boolean Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_BOOLEAN_EXP_FEATURE_COUNT = TI_MAP_OCL_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Boolean Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_BOOLEAN_EXP_OPERATION_COUNT = TI_MAP_OCL_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapBooleanExpImpl <em>TC map Boolean Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapBooleanExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapBooleanExp()
	 * @generated
	 */
	int TC_MAP_BOOLEAN_EXP = 1;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BOOLEAN_EXP__ATL_ATL_EXPRESSION = TI_MAP_BOOLEAN_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BOOLEAN_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_BOOLEAN_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BOOLEAN_EXP__STATUS = TI_MAP_BOOLEAN_EXP__STATUS;

	/**
	 * The feature id for the '<em><b>Primitive symbol</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BOOLEAN_EXP__PRIMITIVE_SYMBOL = TI_MAP_BOOLEAN_EXP_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>TC map Boolean Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BOOLEAN_EXP_FEATURE_COUNT = TI_MAP_BOOLEAN_EXP_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>TC map Boolean Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_BOOLEAN_EXP_OPERATION_COUNT = TI_MAP_BOOLEAN_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapHelperImpl <em>TI map Helper</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapHelperImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapHelper()
	 * @generated
	 */
	int TI_MAP_HELPER = 35;

	/**
	 * The feature id for the '<em><b>Atl atl Helper</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER__ATL_ATL_HELPER = 0;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER__QVTR_QVTR_FUNCTION = 1;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER__STATUS = 2;

	/**
	 * The number of structural features of the '<em>TI map Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>TI map Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelperImpl <em>TC map Helper</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelperImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapHelper()
	 * @generated
	 */
	int TC_MAP_HELPER = 2;

	/**
	 * The feature id for the '<em><b>Atl atl Helper</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER__ATL_ATL_HELPER = TI_MAP_HELPER__ATL_ATL_HELPER;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER__QVTR_QVTR_FUNCTION = TI_MAP_HELPER__QVTR_QVTR_FUNCTION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER__STATUS = TI_MAP_HELPER__STATUS;

	/**
	 * The number of structural features of the '<em>TC map Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_FEATURE_COUNT = TI_MAP_HELPER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TC map Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION_COUNT = TI_MAP_HELPER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapHelper_AttributeImpl <em>TI map Helper Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapHelper_AttributeImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapHelper_Attribute()
	 * @generated
	 */
	int TI_MAP_HELPER_ATTRIBUTE = 36;

	/**
	 * The feature id for the '<em><b>Atl atl Helper</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER_ATTRIBUTE__ATL_ATL_HELPER = TI_MAP_HELPER__ATL_ATL_HELPER;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER_ATTRIBUTE__QVTR_QVTR_FUNCTION = TI_MAP_HELPER__QVTR_QVTR_FUNCTION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER_ATTRIBUTE__STATUS = TI_MAP_HELPER__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Helper Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER_ATTRIBUTE_FEATURE_COUNT = TI_MAP_HELPER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Helper Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER_ATTRIBUTE_OPERATION_COUNT = TI_MAP_HELPER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelper_AttributeImpl <em>TC map Helper Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelper_AttributeImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapHelper_Attribute()
	 * @generated
	 */
	int TC_MAP_HELPER_ATTRIBUTE = 3;

	/**
	 * The feature id for the '<em><b>Atl atl Helper</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE__ATL_ATL_HELPER = TI_MAP_HELPER_ATTRIBUTE__ATL_ATL_HELPER;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE__QVTR_QVTR_FUNCTION = TI_MAP_HELPER_ATTRIBUTE__QVTR_QVTR_FUNCTION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE__STATUS = TI_MAP_HELPER_ATTRIBUTE__STATUS;

	/**
	 * The feature id for the '<em><b>Atl atl Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE__ATL_ATL_DEFINITION = TI_MAP_HELPER_ATTRIBUTE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE__ATL_ATL_EXPRESSION = TI_MAP_HELPER_ATTRIBUTE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Atl atl Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE__ATL_ATL_FEATURE = TI_MAP_HELPER_ATTRIBUTE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE__ATL_ATL_MODULE = TI_MAP_HELPER_ATTRIBUTE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Atl atl Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE__ATL_ATL_TYPE = TI_MAP_HELPER_ATTRIBUTE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Invocation map Helper Context</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE__INVOCATION_MAP_HELPER_CONTEXT = TI_MAP_HELPER_ATTRIBUTE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Primitive attribute Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE__PRIMITIVE_ATTRIBUTE_NAME = TI_MAP_HELPER_ATTRIBUTE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE__QVTR_QVTR_EXPRESSION = TI_MAP_HELPER_ATTRIBUTE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Transformation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE__QVTR_QVTR_TRANSFORMATION = TI_MAP_HELPER_ATTRIBUTE_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>TC map Helper Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE_FEATURE_COUNT = TI_MAP_HELPER_ATTRIBUTE_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>TC map Helper Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_ATTRIBUTE_OPERATION_COUNT = TI_MAP_HELPER_ATTRIBUTE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelper_ContextImpl <em>TC map Helper Context</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelper_ContextImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapHelper_Context()
	 * @generated
	 */
	int TC_MAP_HELPER_CONTEXT = 4;

	/**
	 * The feature id for the '<em><b>Atl atl Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_CONTEXT__ATL_ATL_CONTEXT = 0;

	/**
	 * The feature id for the '<em><b>Atl atl Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_CONTEXT__ATL_ATL_DEFINITION = 1;

	/**
	 * The feature id for the '<em><b>Atl atl Helper</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_CONTEXT__ATL_ATL_HELPER = 2;

	/**
	 * The feature id for the '<em><b>Atl atl Return Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_CONTEXT__ATL_ATL_RETURN_TYPE = 3;

	/**
	 * The feature id for the '<em><b>Invocation map Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_CONTEXT__INVOCATION_MAP_VARIABLE = 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_CONTEXT__QVTR_QVTR_FUNCTION = 5;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_CONTEXT__QVTR_QVTR_PARAMETER = 6;

	/**
	 * The number of structural features of the '<em>TC map Helper Context</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_CONTEXT_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>TC map Helper Context</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_CONTEXT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapHelper_OperationImpl <em>TI map Helper Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapHelper_OperationImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapHelper_Operation()
	 * @generated
	 */
	int TI_MAP_HELPER_OPERATION = 37;

	/**
	 * The feature id for the '<em><b>Atl atl Helper</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER_OPERATION__ATL_ATL_HELPER = TI_MAP_HELPER__ATL_ATL_HELPER;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER_OPERATION__QVTR_QVTR_FUNCTION = TI_MAP_HELPER__QVTR_QVTR_FUNCTION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER_OPERATION__STATUS = TI_MAP_HELPER__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Helper Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER_OPERATION_FEATURE_COUNT = TI_MAP_HELPER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Helper Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_HELPER_OPERATION_OPERATION_COUNT = TI_MAP_HELPER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelper_OperationImpl <em>TC map Helper Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelper_OperationImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapHelper_Operation()
	 * @generated
	 */
	int TC_MAP_HELPER_OPERATION = 5;

	/**
	 * The feature id for the '<em><b>Atl atl Helper</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION__ATL_ATL_HELPER = TI_MAP_HELPER_OPERATION__ATL_ATL_HELPER;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION__QVTR_QVTR_FUNCTION = TI_MAP_HELPER_OPERATION__QVTR_QVTR_FUNCTION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION__STATUS = TI_MAP_HELPER_OPERATION__STATUS;

	/**
	 * The feature id for the '<em><b>Atl atl Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION__ATL_ATL_DEFINITION = TI_MAP_HELPER_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION__ATL_ATL_EXPRESSION = TI_MAP_HELPER_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Atl atl Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION__ATL_ATL_FEATURE = TI_MAP_HELPER_OPERATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION__ATL_ATL_MODULE = TI_MAP_HELPER_OPERATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Atl atl Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION__ATL_ATL_TYPE = TI_MAP_HELPER_OPERATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Invocation map Helper Context</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION__INVOCATION_MAP_HELPER_CONTEXT = TI_MAP_HELPER_OPERATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Primitive operation Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION__PRIMITIVE_OPERATION_NAME = TI_MAP_HELPER_OPERATION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION__QVTR_QVTR_EXPRESSION = TI_MAP_HELPER_OPERATION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Transformation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION__QVTR_QVTR_TRANSFORMATION = TI_MAP_HELPER_OPERATION_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>TC map Helper Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION_FEATURE_COUNT = TI_MAP_HELPER_OPERATION_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>TC map Helper Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_HELPER_OPERATION_OPERATION_COUNT = TI_MAP_HELPER_OPERATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapIfExpImpl <em>TI map If Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapIfExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapIfExp()
	 * @generated
	 */
	int TI_MAP_IF_EXP = 38;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_IF_EXP__ATL_ATL_EXPRESSION = TI_MAP_OCL_EXPRESSION__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_IF_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_OCL_EXPRESSION__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_IF_EXP__STATUS = TI_MAP_OCL_EXPRESSION__STATUS;

	/**
	 * The number of structural features of the '<em>TI map If Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_IF_EXP_FEATURE_COUNT = TI_MAP_OCL_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map If Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_IF_EXP_OPERATION_COUNT = TI_MAP_OCL_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapIfExpImpl <em>TC map If Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapIfExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapIfExp()
	 * @generated
	 */
	int TC_MAP_IF_EXP = 6;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IF_EXP__ATL_ATL_EXPRESSION = TI_MAP_IF_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IF_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_IF_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IF_EXP__STATUS = TI_MAP_IF_EXP__STATUS;

	/**
	 * The feature id for the '<em><b>Atl atl Condition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IF_EXP__ATL_ATL_CONDITION = TI_MAP_IF_EXP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Atl atl Else</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IF_EXP__ATL_ATL_ELSE = TI_MAP_IF_EXP_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Atl atl Then</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IF_EXP__ATL_ATL_THEN = TI_MAP_IF_EXP_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Condition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IF_EXP__QVTR_QVTR_CONDITION = TI_MAP_IF_EXP_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Else</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IF_EXP__QVTR_QVTR_ELSE = TI_MAP_IF_EXP_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Then</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IF_EXP__QVTR_QVTR_THEN = TI_MAP_IF_EXP_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>TC map If Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IF_EXP_FEATURE_COUNT = TI_MAP_IF_EXP_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>TC map If Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IF_EXP_OPERATION_COUNT = TI_MAP_IF_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapInPatternImpl <em>TC map In Pattern</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapInPatternImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapInPattern()
	 * @generated
	 */
	int TC_MAP_IN_PATTERN = 7;

	/**
	 * The feature id for the '<em><b>Atl atl Model</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN__ATL_ATL_MODEL = 0;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN__ATL_ATL_MODULE = 1;

	/**
	 * The feature id for the '<em><b>Atl atl Pattern</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN__ATL_ATL_PATTERN = 2;

	/**
	 * The feature id for the '<em><b>Atl atl Rule</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN__ATL_ATL_RULE = 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN__QVTR_QVTR_DOMAIN = 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Relation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN__QVTR_QVTR_RELATION = 5;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Typed Model</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN__QVTR_QVTR_TYPED_MODEL = 6;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN__STATUS = 7;

	/**
	 * The number of structural features of the '<em>TC map In Pattern</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>TC map In Pattern</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapInPattern_filterImpl <em>TC map In Pattern filter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapInPattern_filterImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapInPattern_filter()
	 * @generated
	 */
	int TC_MAP_IN_PATTERN_FILTER = 8;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN_FILTER__ATL_ATL_EXPRESSION = 0;

	/**
	 * The feature id for the '<em><b>Atl atl Pattern</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN_FILTER__ATL_ATL_PATTERN = 1;

	/**
	 * The feature id for the '<em><b>Atl atl Rule</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN_FILTER__ATL_ATL_RULE = 2;

	/**
	 * The feature id for the '<em><b>Qvtr p</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN_FILTER__QVTR_P = 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN_FILTER__QVTR_QVTR_DOMAIN = 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN_FILTER__QVTR_QVTR_EXPRESSION = 5;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Relation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN_FILTER__QVTR_QVTR_RELATION = 6;

	/**
	 * The feature id for the '<em><b>Qvtr w</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN_FILTER__QVTR_W = 7;

	/**
	 * The number of structural features of the '<em>TC map In Pattern filter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN_FILTER_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>TC map In Pattern filter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_IN_PATTERN_FILTER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapIntegerExpImpl <em>TI map Integer Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapIntegerExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapIntegerExp()
	 * @generated
	 */
	int TI_MAP_INTEGER_EXP = 39;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_INTEGER_EXP__ATL_ATL_EXPRESSION = TI_MAP_OCL_EXPRESSION__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_INTEGER_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_OCL_EXPRESSION__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_INTEGER_EXP__STATUS = TI_MAP_OCL_EXPRESSION__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Integer Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_INTEGER_EXP_FEATURE_COUNT = TI_MAP_OCL_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Integer Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_INTEGER_EXP_OPERATION_COUNT = TI_MAP_OCL_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapIntegerExpImpl <em>TC map Integer Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapIntegerExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapIntegerExp()
	 * @generated
	 */
	int TC_MAP_INTEGER_EXP = 9;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_INTEGER_EXP__ATL_ATL_EXPRESSION = TI_MAP_INTEGER_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_INTEGER_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_INTEGER_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_INTEGER_EXP__STATUS = TI_MAP_INTEGER_EXP__STATUS;

	/**
	 * The feature id for the '<em><b>Primitive symbol</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_INTEGER_EXP__PRIMITIVE_SYMBOL = TI_MAP_INTEGER_EXP_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>TC map Integer Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_INTEGER_EXP_FEATURE_COUNT = TI_MAP_INTEGER_EXP_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>TC map Integer Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_INTEGER_EXP_OPERATION_COUNT = TI_MAP_INTEGER_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapMatchedRuleImpl <em>TC map Matched Rule</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapMatchedRuleImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapMatchedRule()
	 * @generated
	 */
	int TC_MAP_MATCHED_RULE = 10;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE__ATL_ATL_MODULE = 0;

	/**
	 * The feature id for the '<em><b>Atl matched Rule</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE__ATL_MATCHED_RULE = 1;

	/**
	 * The feature id for the '<em><b>Primitive rule Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE__PRIMITIVE_RULE_NAME = 2;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Relation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE__QVTR_QVTR_RELATION = 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Transformation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE__QVTR_QVTR_TRANSFORMATION = 4;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE__STATUS = 5;

	/**
	 * The number of structural features of the '<em>TC map Matched Rule</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>TC map Matched Rule</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapMatchedRule_superImpl <em>TC map Matched Rule super</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapMatchedRule_superImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapMatchedRule_super()
	 * @generated
	 */
	int TC_MAP_MATCHED_RULE_SUPER = 11;

	/**
	 * The feature id for the '<em><b>Atl atl Child Rule</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE_SUPER__ATL_ATL_CHILD_RULE = 0;

	/**
	 * The feature id for the '<em><b>Atl atl Super Rule</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE_SUPER__ATL_ATL_SUPER_RULE = 1;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Overridden Relation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE_SUPER__QVTR_QVTR_OVERRIDDEN_RELATION = 2;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Overrides Relation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE_SUPER__QVTR_QVTR_OVERRIDES_RELATION = 3;

	/**
	 * The number of structural features of the '<em>TC map Matched Rule super</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE_SUPER_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>TC map Matched Rule super</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MATCHED_RULE_SUPER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapModuleImpl <em>TC map Module</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapModuleImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapModule()
	 * @generated
	 */
	int TC_MAP_MODULE = 12;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MODULE__ATL_ATL_MODULE = 0;

	/**
	 * The feature id for the '<em><b>Primitive tx Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MODULE__PRIMITIVE_TX_NAME = 1;

	/**
	 * The feature id for the '<em><b>Qvtr 3</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MODULE__QVTR_3 = 2;

	/**
	 * The feature id for the '<em><b>Qvtr 4</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MODULE__QVTR_4 = 3;

	/**
	 * The feature id for the '<em><b>Qvtr 5</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MODULE__QVTR_5 = 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Transformation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MODULE__QVTR_QVTR_TRANSFORMATION = 5;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MODULE__STATUS = 6;

	/**
	 * The number of structural features of the '<em>TC map Module</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MODULE_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>TC map Module</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_MODULE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapNavigationOrAttributeCallExpImpl <em>TI map Navigation Or Attribute Call Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapNavigationOrAttributeCallExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapNavigationOrAttributeCallExp()
	 * @generated
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP = 40;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__ATL_ATL_EXPRESSION = TI_MAP_OCL_EXPRESSION__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_OCL_EXPRESSION__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__STATUS = TI_MAP_OCL_EXPRESSION__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Navigation Or Attribute Call Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_FEATURE_COUNT = TI_MAP_OCL_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Navigation Or Attribute Call Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_OPERATION_COUNT = TI_MAP_OCL_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapNavigationOrAttributeCallExpImpl <em>TC map Navigation Or Attribute Call Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapNavigationOrAttributeCallExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapNavigationOrAttributeCallExp()
	 * @generated
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP = 13;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__ATL_ATL_EXPRESSION = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__STATUS = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__STATUS;

	/**
	 * The number of structural features of the '<em>TC map Navigation Or Attribute Call Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_FEATURE_COUNT = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TC map Navigation Or Attribute Call Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_OPERATION_COUNT = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapNavigationOrAttributeCallExp_HelperImpl <em>TI map Navigation Or Attribute Call Exp Helper</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapNavigationOrAttributeCallExp_HelperImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapNavigationOrAttributeCallExp_Helper()
	 * @generated
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER = 41;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__ATL_ATL_EXPRESSION = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_EXPRESSION = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__STATUS = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Navigation Or Attribute Call Exp Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_FEATURE_COUNT = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Navigation Or Attribute Call Exp Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_OPERATION_COUNT = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapNavigationOrAttributeCallExp_HelperImpl <em>TC map Navigation Or Attribute Call Exp Helper</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapNavigationOrAttributeCallExp_HelperImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapNavigationOrAttributeCallExp_Helper()
	 * @generated
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER = 14;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__ATL_ATL_EXPRESSION = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_EXPRESSION = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__STATUS = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__STATUS;

	/**
	 * The feature id for the '<em><b>Atl atl Attributes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__ATL_ATL_ATTRIBUTES = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__ATL_ATL_MODULE = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Atl atl Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__ATL_ATL_SOURCE = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Primitive property Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__PRIMITIVE_PROPERTY_NAME = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_OPERATION = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_SOURCE = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Source Argument</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_SOURCE_ARGUMENT = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr This Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_THIS_VARIABLE = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Transformation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_TRANSFORMATION = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>TC map Navigation Or Attribute Call Exp Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_FEATURE_COUNT = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>TC map Navigation Or Attribute Call Exp Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_OPERATION_COUNT = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapNavigationOrAttributeCallExp_PropertyImpl <em>TI map Navigation Or Attribute Call Exp Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapNavigationOrAttributeCallExp_PropertyImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapNavigationOrAttributeCallExp_Property()
	 * @generated
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY = 42;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__ATL_ATL_EXPRESSION = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__QVTR_QVTR_EXPRESSION = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__STATUS = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Navigation Or Attribute Call Exp Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY_FEATURE_COUNT = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Navigation Or Attribute Call Exp Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY_OPERATION_COUNT = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapNavigationOrAttributeCallExp_PropertyImpl <em>TC map Navigation Or Attribute Call Exp Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapNavigationOrAttributeCallExp_PropertyImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapNavigationOrAttributeCallExp_Property()
	 * @generated
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY = 15;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__ATL_ATL_EXPRESSION = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__QVTR_QVTR_EXPRESSION = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__STATUS = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__STATUS;

	/**
	 * The feature id for the '<em><b>Atl atl Attributes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__ATL_ATL_ATTRIBUTES = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__ATL_ATL_MODULE = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Atl atl Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__ATL_ATL_SOURCE = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Primitive property Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__PRIMITIVE_PROPERTY_NAME = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__QVTR_QVTR_PROPERTY = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__QVTR_QVTR_SOURCE = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>TC map Navigation Or Attribute Call Exp Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY_FEATURE_COUNT = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>TC map Navigation Or Attribute Call Exp Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY_OPERATION_COUNT = TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclExpressionImpl <em>TC map Ocl Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclExpressionImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOclExpression()
	 * @generated
	 */
	int TC_MAP_OCL_EXPRESSION = 16;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_EXPRESSION__ATL_ATL_EXPRESSION = TI_MAP_OCL_EXPRESSION__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_EXPRESSION__QVTR_QVTR_EXPRESSION = TI_MAP_OCL_EXPRESSION__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_EXPRESSION__STATUS = TI_MAP_OCL_EXPRESSION__STATUS;

	/**
	 * The number of structural features of the '<em>TC map Ocl Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_EXPRESSION_FEATURE_COUNT = TI_MAP_OCL_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TC map Ocl Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_EXPRESSION_OPERATION_COUNT = TI_MAP_OCL_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclMetamodelImpl <em>TC map Ocl Metamodel</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclMetamodelImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOclMetamodel()
	 * @generated
	 */
	int TC_MAP_OCL_METAMODEL = 17;

	/**
	 * The feature id for the '<em><b>Atl ocl Metamodel</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_METAMODEL__ATL_OCL_METAMODEL = 0;

	/**
	 * The feature id for the '<em><b>Primitive tm Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_METAMODEL__PRIMITIVE_TM_NAME = 1;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Typed Model</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_METAMODEL__QVTR_QVTR_TYPED_MODEL = 2;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_METAMODEL__STATUS = 3;

	/**
	 * The number of structural features of the '<em>TC map Ocl Metamodel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_METAMODEL_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>TC map Ocl Metamodel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_METAMODEL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclModel_INImpl <em>TC map Ocl Model IN</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclModel_INImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOclModel_IN()
	 * @generated
	 */
	int TC_MAP_OCL_MODEL_IN = 18;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_IN__ATL_ATL_MODULE = 0;

	/**
	 * The feature id for the '<em><b>Atl ocl Metamodel</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_IN__ATL_OCL_METAMODEL = 1;

	/**
	 * The feature id for the '<em><b>Atl ocl Model</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_IN__ATL_OCL_MODEL = 2;

	/**
	 * The feature id for the '<em><b>Primitive tm Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_IN__PRIMITIVE_TM_NAME = 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Transformation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_IN__QVTR_QVTR_TRANSFORMATION = 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Typed Model</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_IN__QVTR_QVTR_TYPED_MODEL = 5;

	/**
	 * The number of structural features of the '<em>TC map Ocl Model IN</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_IN_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>TC map Ocl Model IN</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_IN_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclModel_OUTImpl <em>TC map Ocl Model OUT</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclModel_OUTImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOclModel_OUT()
	 * @generated
	 */
	int TC_MAP_OCL_MODEL_OUT = 19;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_OUT__ATL_ATL_MODULE = 0;

	/**
	 * The feature id for the '<em><b>Atl ocl Metamodel</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_OUT__ATL_OCL_METAMODEL = 1;

	/**
	 * The feature id for the '<em><b>Atl ocl Model</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_OUT__ATL_OCL_MODEL = 2;

	/**
	 * The feature id for the '<em><b>Primitive tm Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_OUT__PRIMITIVE_TM_NAME = 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Transformation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_OUT__QVTR_QVTR_TRANSFORMATION = 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Typed Model</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_OUT__QVTR_QVTR_TYPED_MODEL = 5;

	/**
	 * The number of structural features of the '<em>TC map Ocl Model OUT</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_OUT_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>TC map Ocl Model OUT</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OCL_MODEL_OUT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperationCallExpImpl <em>TI map Operation Call Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperationCallExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapOperationCallExp()
	 * @generated
	 */
	int TI_MAP_OPERATION_CALL_EXP = 44;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP__ATL_ATL_EXPRESSION = TI_MAP_OCL_EXPRESSION__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_OCL_EXPRESSION__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP__STATUS = TI_MAP_OCL_EXPRESSION__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Operation Call Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP_FEATURE_COUNT = TI_MAP_OCL_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Operation Call Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP_OPERATION_COUNT = TI_MAP_OCL_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExpImpl <em>TC map Operation Call Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOperationCallExp()
	 * @generated
	 */
	int TC_MAP_OPERATION_CALL_EXP = 20;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP__ATL_ATL_EXPRESSION = TI_MAP_OPERATION_CALL_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_OPERATION_CALL_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP__STATUS = TI_MAP_OPERATION_CALL_EXP__STATUS;

	/**
	 * The number of structural features of the '<em>TC map Operation Call Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_FEATURE_COUNT = TI_MAP_OPERATION_CALL_EXP_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TC map Operation Call Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION_COUNT = TI_MAP_OPERATION_CALL_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperationCallExp_HelperImpl <em>TI map Operation Call Exp Helper</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperationCallExp_HelperImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapOperationCallExp_Helper()
	 * @generated
	 */
	int TI_MAP_OPERATION_CALL_EXP_HELPER = 45;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP_HELPER__ATL_ATL_EXPRESSION = TI_MAP_OPERATION_CALL_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_EXPRESSION = TI_MAP_OPERATION_CALL_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP_HELPER__STATUS = TI_MAP_OPERATION_CALL_EXP__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Operation Call Exp Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP_HELPER_FEATURE_COUNT = TI_MAP_OPERATION_CALL_EXP_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Operation Call Exp Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP_HELPER_OPERATION_COUNT = TI_MAP_OPERATION_CALL_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExp_HelperImpl <em>TC map Operation Call Exp Helper</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExp_HelperImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOperationCallExp_Helper()
	 * @generated
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER = 21;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER__ATL_ATL_EXPRESSION = TI_MAP_OPERATION_CALL_EXP_HELPER__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_EXPRESSION = TI_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER__STATUS = TI_MAP_OPERATION_CALL_EXP_HELPER__STATUS;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER__ATL_ATL_MODULE = TI_MAP_OPERATION_CALL_EXP_HELPER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Atl atl Operations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER__ATL_ATL_OPERATIONS = TI_MAP_OPERATION_CALL_EXP_HELPER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Atl atl Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER__ATL_ATL_SOURCE = TI_MAP_OPERATION_CALL_EXP_HELPER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Primitive operation Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER__PRIMITIVE_OPERATION_NAME = TI_MAP_OPERATION_CALL_EXP_HELPER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_OPERATION = TI_MAP_OPERATION_CALL_EXP_HELPER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_SOURCE = TI_MAP_OPERATION_CALL_EXP_HELPER_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Source Argument</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_SOURCE_ARGUMENT = TI_MAP_OPERATION_CALL_EXP_HELPER_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr This Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_THIS_VARIABLE = TI_MAP_OPERATION_CALL_EXP_HELPER_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Transformation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_TRANSFORMATION = TI_MAP_OPERATION_CALL_EXP_HELPER_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>TC map Operation Call Exp Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER_FEATURE_COUNT = TI_MAP_OPERATION_CALL_EXP_HELPER_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>TC map Operation Call Exp Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_HELPER_OPERATION_COUNT = TI_MAP_OPERATION_CALL_EXP_HELPER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperationCallExp_OperationImpl <em>TI map Operation Call Exp Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperationCallExp_OperationImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapOperationCallExp_Operation()
	 * @generated
	 */
	int TI_MAP_OPERATION_CALL_EXP_OPERATION = 46;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP_OPERATION__ATL_ATL_EXPRESSION = TI_MAP_OPERATION_CALL_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP_OPERATION__QVTR_QVTR_EXPRESSION = TI_MAP_OPERATION_CALL_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP_OPERATION__STATUS = TI_MAP_OPERATION_CALL_EXP__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Operation Call Exp Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP_OPERATION_FEATURE_COUNT = TI_MAP_OPERATION_CALL_EXP_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Operation Call Exp Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATION_CALL_EXP_OPERATION_OPERATION_COUNT = TI_MAP_OPERATION_CALL_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExp_OperationImpl <em>TC map Operation Call Exp Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExp_OperationImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOperationCallExp_Operation()
	 * @generated
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION = 22;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION__ATL_ATL_EXPRESSION = TI_MAP_OPERATION_CALL_EXP_OPERATION__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION__QVTR_QVTR_EXPRESSION = TI_MAP_OPERATION_CALL_EXP_OPERATION__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION__STATUS = TI_MAP_OPERATION_CALL_EXP_OPERATION__STATUS;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION__ATL_ATL_MODULE = TI_MAP_OPERATION_CALL_EXP_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Atl atl Operations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION__ATL_ATL_OPERATIONS = TI_MAP_OPERATION_CALL_EXP_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Atl atl Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION__ATL_ATL_SOURCE = TI_MAP_OPERATION_CALL_EXP_OPERATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Primitive operation Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION__PRIMITIVE_OPERATION_NAME = TI_MAP_OPERATION_CALL_EXP_OPERATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION__QVTR_QVTR_OPERATION = TI_MAP_OPERATION_CALL_EXP_OPERATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION__QVTR_QVTR_SOURCE = TI_MAP_OPERATION_CALL_EXP_OPERATION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>TC map Operation Call Exp Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION_FEATURE_COUNT = TI_MAP_OPERATION_CALL_EXP_OPERATION_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>TC map Operation Call Exp Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_OPERATION_OPERATION_COUNT = TI_MAP_OPERATION_CALL_EXP_OPERATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExp_argumentImpl <em>TC map Operation Call Exp argument</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExp_argumentImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOperationCallExp_argument()
	 * @generated
	 */
	int TC_MAP_OPERATION_CALL_EXP_ARGUMENT = 23;

	/**
	 * The feature id for the '<em><b>Atl atl Argument</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_ARGUMENT__ATL_ATL_ARGUMENT = 0;

	/**
	 * The feature id for the '<em><b>Atl atl Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_ARGUMENT__ATL_ATL_PARENT = 1;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Argument</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_ARGUMENT__QVTR_QVTR_ARGUMENT = 2;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_ARGUMENT__QVTR_QVTR_PARENT = 3;

	/**
	 * The number of structural features of the '<em>TC map Operation Call Exp argument</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_ARGUMENT_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>TC map Operation Call Exp argument</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATION_CALL_EXP_ARGUMENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperatorCallExpImpl <em>TI map Operator Call Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperatorCallExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapOperatorCallExp()
	 * @generated
	 */
	int TI_MAP_OPERATOR_CALL_EXP = 47;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATOR_CALL_EXP__ATL_ATL_EXPRESSION = TI_MAP_OPERATION_CALL_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATOR_CALL_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_OPERATION_CALL_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATOR_CALL_EXP__STATUS = TI_MAP_OPERATION_CALL_EXP__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Operator Call Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATOR_CALL_EXP_FEATURE_COUNT = TI_MAP_OPERATION_CALL_EXP_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Operator Call Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_OPERATOR_CALL_EXP_OPERATION_COUNT = TI_MAP_OPERATION_CALL_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperatorCallExpImpl <em>TC map Operator Call Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperatorCallExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOperatorCallExp()
	 * @generated
	 */
	int TC_MAP_OPERATOR_CALL_EXP = 24;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATOR_CALL_EXP__ATL_ATL_EXPRESSION = TI_MAP_OPERATOR_CALL_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATOR_CALL_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_OPERATOR_CALL_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATOR_CALL_EXP__STATUS = TI_MAP_OPERATOR_CALL_EXP__STATUS;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATOR_CALL_EXP__ATL_ATL_MODULE = TI_MAP_OPERATOR_CALL_EXP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Atl atl Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATOR_CALL_EXP__ATL_ATL_SOURCE = TI_MAP_OPERATOR_CALL_EXP_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Primitive operation Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATOR_CALL_EXP__PRIMITIVE_OPERATION_NAME = TI_MAP_OPERATOR_CALL_EXP_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATOR_CALL_EXP__QVTR_QVTR_OPERATION = TI_MAP_OPERATOR_CALL_EXP_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATOR_CALL_EXP__QVTR_QVTR_SOURCE = TI_MAP_OPERATOR_CALL_EXP_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Transformation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATOR_CALL_EXP__QVTR_QVTR_TRANSFORMATION = TI_MAP_OPERATOR_CALL_EXP_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>TC map Operator Call Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATOR_CALL_EXP_FEATURE_COUNT = TI_MAP_OPERATOR_CALL_EXP_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>TC map Operator Call Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OPERATOR_CALL_EXP_OPERATION_COUNT = TI_MAP_OPERATOR_CALL_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOutPatternImpl <em>TC map Out Pattern</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOutPatternImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOutPattern()
	 * @generated
	 */
	int TC_MAP_OUT_PATTERN = 25;

	/**
	 * The feature id for the '<em><b>Atl atl Module</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OUT_PATTERN__ATL_ATL_MODULE = 0;

	/**
	 * The feature id for the '<em><b>Atl atl Pattern</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OUT_PATTERN__ATL_ATL_PATTERN = 1;

	/**
	 * The feature id for the '<em><b>Atl atl Rule</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OUT_PATTERN__ATL_ATL_RULE = 2;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OUT_PATTERN__QVTR_QVTR_DOMAIN = 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Relation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OUT_PATTERN__QVTR_QVTR_RELATION = 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Typed Model</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OUT_PATTERN__QVTR_QVTR_TYPED_MODEL = 5;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OUT_PATTERN__STATUS = 6;

	/**
	 * The number of structural features of the '<em>TC map Out Pattern</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OUT_PATTERN_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>TC map Out Pattern</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_OUT_PATTERN_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapSimpleInPatternElementImpl <em>TC map Simple In Pattern Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapSimpleInPatternElementImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapSimpleInPatternElement()
	 * @generated
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT = 26;

	/**
	 * The feature id for the '<em><b>Atl atl Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__ATL_ATL_ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Atl atl Pattern</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__ATL_ATL_PATTERN = 1;

	/**
	 * The feature id for the '<em><b>Atl atl Rule</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__ATL_ATL_RULE = 2;

	/**
	 * The feature id for the '<em><b>Invocation map Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__INVOCATION_MAP_VARIABLE = 3;

	/**
	 * The feature id for the '<em><b>Primitive element Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__PRIMITIVE_ELEMENT_NAME = 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__QVTR_QVTR_DOMAIN = 5;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Domain1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__QVTR_QVTR_DOMAIN1 = 6;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Pattern</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__QVTR_QVTR_PATTERN = 7;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Relation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__QVTR_QVTR_RELATION = 8;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Template</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__QVTR_QVTR_TEMPLATE = 9;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__QVTR_QVTR_VARIABLE = 10;

	/**
	 * The number of structural features of the '<em>TC map Simple In Pattern Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>TC map Simple In Pattern Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_IN_PATTERN_ELEMENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapSimpleOutPatternElementImpl <em>TC map Simple Out Pattern Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapSimpleOutPatternElementImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT = 27;

	/**
	 * The feature id for the '<em><b>Atl atl Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__ATL_ATL_ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Atl atl Pattern</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__ATL_ATL_PATTERN = 1;

	/**
	 * The feature id for the '<em><b>Atl atl Rule</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__ATL_ATL_RULE = 2;

	/**
	 * The feature id for the '<em><b>Invocation map Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__INVOCATION_MAP_VARIABLE = 3;

	/**
	 * The feature id for the '<em><b>Primitive element Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__PRIMITIVE_ELEMENT_NAME = 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__QVTR_QVTR_DOMAIN = 5;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Domain1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__QVTR_QVTR_DOMAIN1 = 6;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Pattern</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__QVTR_QVTR_PATTERN = 7;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Relation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__QVTR_QVTR_RELATION = 8;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Template</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__QVTR_QVTR_TEMPLATE = 9;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__QVTR_QVTR_VARIABLE = 10;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__STATUS = 11;

	/**
	 * The number of structural features of the '<em>TC map Simple Out Pattern Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>TC map Simple Out Pattern Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapStringExpImpl <em>TI map String Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapStringExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapStringExp()
	 * @generated
	 */
	int TI_MAP_STRING_EXP = 48;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_STRING_EXP__ATL_ATL_EXPRESSION = TI_MAP_OCL_EXPRESSION__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_STRING_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_OCL_EXPRESSION__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_STRING_EXP__STATUS = TI_MAP_OCL_EXPRESSION__STATUS;

	/**
	 * The number of structural features of the '<em>TI map String Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_STRING_EXP_FEATURE_COUNT = TI_MAP_OCL_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map String Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_STRING_EXP_OPERATION_COUNT = TI_MAP_OCL_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapStringExpImpl <em>TC map String Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapStringExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapStringExp()
	 * @generated
	 */
	int TC_MAP_STRING_EXP = 28;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_STRING_EXP__ATL_ATL_EXPRESSION = TI_MAP_STRING_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_STRING_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_STRING_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_STRING_EXP__STATUS = TI_MAP_STRING_EXP__STATUS;

	/**
	 * The feature id for the '<em><b>Primitive symbol</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_STRING_EXP__PRIMITIVE_SYMBOL = TI_MAP_STRING_EXP_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>TC map String Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_STRING_EXP_FEATURE_COUNT = TI_MAP_STRING_EXP_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>TC map String Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_STRING_EXP_OPERATION_COUNT = TI_MAP_STRING_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableImpl <em>TC map Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapVariable()
	 * @generated
	 */
	int TC_MAP_VARIABLE = 29;

	/**
	 * The feature id for the '<em><b>Atl atl Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE__ATL_ATL_VARIABLE = 0;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE__QVTR_QVTR_VARIABLE = 1;

	/**
	 * The number of structural features of the '<em>TC map Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>TC map Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExpImpl <em>TI map Variable Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapVariableExp()
	 * @generated
	 */
	int TI_MAP_VARIABLE_EXP = 49;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP__ATL_ATL_EXPRESSION = TI_MAP_OCL_EXPRESSION__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_OCL_EXPRESSION__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP__STATUS = TI_MAP_OCL_EXPRESSION__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Variable Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP_FEATURE_COUNT = TI_MAP_OCL_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Variable Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP_OPERATION_COUNT = TI_MAP_OCL_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExpImpl <em>TC map Variable Exp</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExpImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapVariableExp()
	 * @generated
	 */
	int TC_MAP_VARIABLE_EXP = 30;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP__ATL_ATL_EXPRESSION = TI_MAP_VARIABLE_EXP__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP__QVTR_QVTR_EXPRESSION = TI_MAP_VARIABLE_EXP__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP__STATUS = TI_MAP_VARIABLE_EXP__STATUS;

	/**
	 * The feature id for the '<em><b>Atl atl Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP__ATL_ATL_VARIABLE = TI_MAP_VARIABLE_EXP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Invocation map Variable Exp referred Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP__INVOCATION_MAP_VARIABLE_EXP_REFERRED_VARIABLE = TI_MAP_VARIABLE_EXP_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Primitive var Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP__PRIMITIVE_VAR_NAME = TI_MAP_VARIABLE_EXP_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>TC map Variable Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_FEATURE_COUNT = TI_MAP_VARIABLE_EXP_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>TC map Variable Exp</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_OPERATION_COUNT = TI_MAP_VARIABLE_EXP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExp_referredVariableImpl <em>TI map Variable Exp referred Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExp_referredVariableImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapVariableExp_referredVariable()
	 * @generated
	 */
	int TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE = 50;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__STATUS = 0;

	/**
	 * The number of structural features of the '<em>TI map Variable Exp referred Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>TI map Variable Exp referred Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExp_referredVariableImpl <em>TC map Variable Exp referred Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExp_referredVariableImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapVariableExp_referredVariable()
	 * @generated
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE = 31;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE__STATUS = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__STATUS;

	/**
	 * The feature id for the '<em><b>Atl atl Expression1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE__ATL_ATL_EXPRESSION1 = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE__QVTR_QVTR_EXPRESSION1 = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>TC map Variable Exp referred Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_FEATURE_COUNT = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>TC map Variable Exp referred Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_OPERATION_COUNT = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExp_referredVariable_HelperImpl <em>TI map Variable Exp referred Variable Helper</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExp_referredVariable_HelperImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapVariableExp_referredVariable_Helper()
	 * @generated
	 */
	int TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER = 51;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__STATUS = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Variable Exp referred Variable Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_FEATURE_COUNT = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Variable Exp referred Variable Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_OPERATION_COUNT = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExp_referredVariable_HelperImpl <em>TC map Variable Exp referred Variable Helper</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExp_referredVariable_HelperImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapVariableExp_referredVariable_Helper()
	 * @generated
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER = 32;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__STATUS = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__STATUS;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__ATL_ATL_EXPRESSION = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Atl atl Helper</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__ATL_ATL_HELPER = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Atl atl Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__ATL_ATL_VARIABLE = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Invocation map Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__INVOCATION_MAP_VARIABLE = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__QVTR_QVTR_EXPRESSION = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__QVTR_QVTR_VARIABLE = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>TC map Variable Exp referred Variable Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_FEATURE_COUNT = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>TC map Variable Exp referred Variable Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_OPERATION_COUNT = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExp_referredVariable_VariableDeclarationImpl <em>TI map Variable Exp referred Variable Variable Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExp_referredVariable_VariableDeclarationImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapVariableExp_referredVariable_VariableDeclaration()
	 * @generated
	 */
	int TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION = 52;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__STATUS = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__STATUS;

	/**
	 * The number of structural features of the '<em>TI map Variable Exp referred Variable Variable Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_FEATURE_COUNT = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TI map Variable Exp referred Variable Variable Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_OPERATION_COUNT = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExp_referredVariable_VariableDeclarationImpl <em>TC map Variable Exp referred Variable Variable Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExp_referredVariable_VariableDeclarationImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapVariableExp_referredVariable_VariableDeclaration()
	 * @generated
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION = 33;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__STATUS = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__STATUS;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__ATL_ATL_EXPRESSION = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Atl atl Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__ATL_ATL_VARIABLE = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Invocation map Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__INVOCATION_MAP_VARIABLE = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__QVTR_QVTR_EXPRESSION = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__QVTR_QVTR_VARIABLE = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>TC map Variable Exp referred Variable Variable Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_FEATURE_COUNT = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>TC map Variable Exp referred Variable Variable Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_OPERATION_COUNT = TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WI_mapVariableExp_referredVariableImpl <em>WI map Variable Exp referred Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WI_mapVariableExp_referredVariableImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getWI_mapVariableExp_referredVariable()
	 * @generated
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE = 56;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__ATL_ATL_EXPRESSION = 0;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__QVTR_QVTR_EXPRESSION = 1;

	/**
	 * The feature id for the '<em><b>Result</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__RESULT = 2;

	/**
	 * The number of structural features of the '<em>WI map Variable Exp referred Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>WI map Variable Exp referred Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WC_mapVariableExp_referredVariableImpl <em>WC map Variable Exp referred Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WC_mapVariableExp_referredVariableImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getWC_mapVariableExp_referredVariable()
	 * @generated
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE = 53;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE__ATL_ATL_EXPRESSION = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE__QVTR_QVTR_EXPRESSION = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Result</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE__RESULT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__RESULT;

	/**
	 * The number of structural features of the '<em>WC map Variable Exp referred Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_FEATURE_COUNT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>WC map Variable Exp referred Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_OPERATION_COUNT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WI_mapVariableExp_referredVariable_HelperImpl <em>WI map Variable Exp referred Variable Helper</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WI_mapVariableExp_referredVariable_HelperImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getWI_mapVariableExp_referredVariable_Helper()
	 * @generated
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER = 57;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__ATL_ATL_EXPRESSION = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__QVTR_QVTR_EXPRESSION = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Result</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__RESULT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__RESULT;

	/**
	 * The number of structural features of the '<em>WI map Variable Exp referred Variable Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_FEATURE_COUNT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>WI map Variable Exp referred Variable Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_OPERATION_COUNT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WC_mapVariableExp_referredVariable_HelperImpl <em>WC map Variable Exp referred Variable Helper</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WC_mapVariableExp_referredVariable_HelperImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getWC_mapVariableExp_referredVariable_Helper()
	 * @generated
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER = 54;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__ATL_ATL_EXPRESSION = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__QVTR_QVTR_EXPRESSION = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Result</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__RESULT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__RESULT;

	/**
	 * The number of structural features of the '<em>WC map Variable Exp referred Variable Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_FEATURE_COUNT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>WC map Variable Exp referred Variable Helper</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_OPERATION_COUNT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WI_mapVariableExp_referredVariable_VariableDeclarationImpl <em>WI map Variable Exp referred Variable Variable Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WI_mapVariableExp_referredVariable_VariableDeclarationImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getWI_mapVariableExp_referredVariable_VariableDeclaration()
	 * @generated
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION = 58;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__ATL_ATL_EXPRESSION = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__QVTR_QVTR_EXPRESSION = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Result</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__RESULT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__RESULT;

	/**
	 * The number of structural features of the '<em>WI map Variable Exp referred Variable Variable Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_FEATURE_COUNT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>WI map Variable Exp referred Variable Variable Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_OPERATION_COUNT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WC_mapVariableExp_referredVariable_VariableDeclarationImpl <em>WC map Variable Exp referred Variable Variable Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WC_mapVariableExp_referredVariable_VariableDeclarationImpl
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getWC_mapVariableExp_referredVariable_VariableDeclaration()
	 * @generated
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION = 55;

	/**
	 * The feature id for the '<em><b>Atl atl Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__ATL_ATL_EXPRESSION = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__ATL_ATL_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Qvtr qvtr Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__QVTR_QVTR_EXPRESSION = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__QVTR_QVTR_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Result</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__RESULT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__RESULT;

	/**
	 * The number of structural features of the '<em>WC map Variable Exp referred Variable Variable Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_FEATURE_COUNT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>WC map Variable Exp referred Variable Variable Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_OPERATION_COUNT = WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION_OPERATION_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding <em>TC map Binding</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Binding</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding
	 * @generated
	 */
	EClass getTC_mapBinding();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getAtl_atlBinding <em>Atl atl Binding</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Binding</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getAtl_atlBinding()
	 * @see #getTC_mapBinding()
	 * @generated
	 */
	EReference getTC_mapBinding_Atl_atlBinding();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getAtl_atlExpression <em>Atl atl Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getAtl_atlExpression()
	 * @see #getTC_mapBinding()
	 * @generated
	 */
	EReference getTC_mapBinding_Atl_atlExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getAtl_atlOutPatternElement <em>Atl atl Out Pattern Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Out Pattern Element</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getAtl_atlOutPatternElement()
	 * @see #getTC_mapBinding()
	 * @generated
	 */
	EReference getTC_mapBinding_Atl_atlOutPatternElement();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getPrimitive_propertyName <em>Primitive property Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive property Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getPrimitive_propertyName()
	 * @see #getTC_mapBinding()
	 * @generated
	 */
	EAttribute getTC_mapBinding_Primitive_propertyName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getQvtr_qvtrExpression <em>Qvtr qvtr Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getQvtr_qvtrExpression()
	 * @see #getTC_mapBinding()
	 * @generated
	 */
	EReference getTC_mapBinding_Qvtr_qvtrExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getQvtr_qvtrPart <em>Qvtr qvtr Part</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Part</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getQvtr_qvtrPart()
	 * @see #getTC_mapBinding()
	 * @generated
	 */
	EReference getTC_mapBinding_Qvtr_qvtrPart();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getQvtr_qvtrTemplate <em>Qvtr qvtr Template</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Template</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBinding#getQvtr_qvtrTemplate()
	 * @see #getTC_mapBinding()
	 * @generated
	 */
	EReference getTC_mapBinding_Qvtr_qvtrTemplate();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBooleanExp <em>TC map Boolean Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Boolean Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBooleanExp
	 * @generated
	 */
	EClass getTC_mapBooleanExp();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBooleanExp#isPrimitive_symbol <em>Primitive symbol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive symbol</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapBooleanExp#isPrimitive_symbol()
	 * @see #getTC_mapBooleanExp()
	 * @generated
	 */
	EAttribute getTC_mapBooleanExp_Primitive_symbol();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper <em>TC map Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper
	 * @generated
	 */
	EClass getTC_mapHelper();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute <em>TC map Helper Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Helper Attribute</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute
	 * @generated
	 */
	EClass getTC_mapHelper_Attribute();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getAtl_atlDefinition <em>Atl atl Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Definition</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getAtl_atlDefinition()
	 * @see #getTC_mapHelper_Attribute()
	 * @generated
	 */
	EReference getTC_mapHelper_Attribute_Atl_atlDefinition();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getAtl_atlExpression <em>Atl atl Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getAtl_atlExpression()
	 * @see #getTC_mapHelper_Attribute()
	 * @generated
	 */
	EReference getTC_mapHelper_Attribute_Atl_atlExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getAtl_atlFeature <em>Atl atl Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Feature</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getAtl_atlFeature()
	 * @see #getTC_mapHelper_Attribute()
	 * @generated
	 */
	EReference getTC_mapHelper_Attribute_Atl_atlFeature();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getAtl_atlModule()
	 * @see #getTC_mapHelper_Attribute()
	 * @generated
	 */
	EReference getTC_mapHelper_Attribute_Atl_atlModule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getAtl_atlType <em>Atl atl Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Type</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getAtl_atlType()
	 * @see #getTC_mapHelper_Attribute()
	 * @generated
	 */
	EReference getTC_mapHelper_Attribute_Atl_atlType();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getInvocation_mapHelper_Context <em>Invocation map Helper Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Invocation map Helper Context</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getInvocation_mapHelper_Context()
	 * @see #getTC_mapHelper_Attribute()
	 * @generated
	 */
	EReference getTC_mapHelper_Attribute_Invocation_mapHelper_Context();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getPrimitive_attributeName <em>Primitive attribute Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive attribute Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getPrimitive_attributeName()
	 * @see #getTC_mapHelper_Attribute()
	 * @generated
	 */
	EAttribute getTC_mapHelper_Attribute_Primitive_attributeName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getQvtr_qvtrExpression <em>Qvtr qvtr Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getQvtr_qvtrExpression()
	 * @see #getTC_mapHelper_Attribute()
	 * @generated
	 */
	EReference getTC_mapHelper_Attribute_Qvtr_qvtrExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getQvtr_qvtrTransformation <em>Qvtr qvtr Transformation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Transformation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Attribute#getQvtr_qvtrTransformation()
	 * @see #getTC_mapHelper_Attribute()
	 * @generated
	 */
	EReference getTC_mapHelper_Attribute_Qvtr_qvtrTransformation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context <em>TC map Helper Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Helper Context</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context
	 * @generated
	 */
	EClass getTC_mapHelper_Context();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getAtl_atlContext <em>Atl atl Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Context</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getAtl_atlContext()
	 * @see #getTC_mapHelper_Context()
	 * @generated
	 */
	EReference getTC_mapHelper_Context_Atl_atlContext();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getAtl_atlDefinition <em>Atl atl Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Definition</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getAtl_atlDefinition()
	 * @see #getTC_mapHelper_Context()
	 * @generated
	 */
	EReference getTC_mapHelper_Context_Atl_atlDefinition();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getAtl_atlHelper <em>Atl atl Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getAtl_atlHelper()
	 * @see #getTC_mapHelper_Context()
	 * @generated
	 */
	EReference getTC_mapHelper_Context_Atl_atlHelper();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getAtl_atlReturnType <em>Atl atl Return Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Return Type</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getAtl_atlReturnType()
	 * @see #getTC_mapHelper_Context()
	 * @generated
	 */
	EReference getTC_mapHelper_Context_Atl_atlReturnType();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getInvocation_mapVariable <em>Invocation map Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Invocation map Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getInvocation_mapVariable()
	 * @see #getTC_mapHelper_Context()
	 * @generated
	 */
	EReference getTC_mapHelper_Context_Invocation_mapVariable();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getQvtr_qvtrFunction <em>Qvtr qvtr Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Function</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getQvtr_qvtrFunction()
	 * @see #getTC_mapHelper_Context()
	 * @generated
	 */
	EReference getTC_mapHelper_Context_Qvtr_qvtrFunction();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getQvtr_qvtrParameter <em>Qvtr qvtr Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Parameter</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Context#getQvtr_qvtrParameter()
	 * @see #getTC_mapHelper_Context()
	 * @generated
	 */
	EReference getTC_mapHelper_Context_Qvtr_qvtrParameter();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation <em>TC map Helper Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Helper Operation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation
	 * @generated
	 */
	EClass getTC_mapHelper_Operation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getAtl_atlDefinition <em>Atl atl Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Definition</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getAtl_atlDefinition()
	 * @see #getTC_mapHelper_Operation()
	 * @generated
	 */
	EReference getTC_mapHelper_Operation_Atl_atlDefinition();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getAtl_atlExpression <em>Atl atl Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getAtl_atlExpression()
	 * @see #getTC_mapHelper_Operation()
	 * @generated
	 */
	EReference getTC_mapHelper_Operation_Atl_atlExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getAtl_atlFeature <em>Atl atl Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Feature</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getAtl_atlFeature()
	 * @see #getTC_mapHelper_Operation()
	 * @generated
	 */
	EReference getTC_mapHelper_Operation_Atl_atlFeature();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getAtl_atlModule()
	 * @see #getTC_mapHelper_Operation()
	 * @generated
	 */
	EReference getTC_mapHelper_Operation_Atl_atlModule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getAtl_atlType <em>Atl atl Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Type</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getAtl_atlType()
	 * @see #getTC_mapHelper_Operation()
	 * @generated
	 */
	EReference getTC_mapHelper_Operation_Atl_atlType();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getInvocation_mapHelper_Context <em>Invocation map Helper Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Invocation map Helper Context</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getInvocation_mapHelper_Context()
	 * @see #getTC_mapHelper_Operation()
	 * @generated
	 */
	EReference getTC_mapHelper_Operation_Invocation_mapHelper_Context();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getPrimitive_operationName <em>Primitive operation Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive operation Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getPrimitive_operationName()
	 * @see #getTC_mapHelper_Operation()
	 * @generated
	 */
	EAttribute getTC_mapHelper_Operation_Primitive_operationName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getQvtr_qvtrExpression <em>Qvtr qvtr Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getQvtr_qvtrExpression()
	 * @see #getTC_mapHelper_Operation()
	 * @generated
	 */
	EReference getTC_mapHelper_Operation_Qvtr_qvtrExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getQvtr_qvtrTransformation <em>Qvtr qvtr Transformation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Transformation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapHelper_Operation#getQvtr_qvtrTransformation()
	 * @see #getTC_mapHelper_Operation()
	 * @generated
	 */
	EReference getTC_mapHelper_Operation_Qvtr_qvtrTransformation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp <em>TC map If Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map If Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp
	 * @generated
	 */
	EClass getTC_mapIfExp();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp#getAtl_atlCondition <em>Atl atl Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Condition</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp#getAtl_atlCondition()
	 * @see #getTC_mapIfExp()
	 * @generated
	 */
	EReference getTC_mapIfExp_Atl_atlCondition();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp#getAtl_atlElse <em>Atl atl Else</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Else</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp#getAtl_atlElse()
	 * @see #getTC_mapIfExp()
	 * @generated
	 */
	EReference getTC_mapIfExp_Atl_atlElse();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp#getAtl_atlThen <em>Atl atl Then</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Then</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp#getAtl_atlThen()
	 * @see #getTC_mapIfExp()
	 * @generated
	 */
	EReference getTC_mapIfExp_Atl_atlThen();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp#getQvtr_qvtrCondition <em>Qvtr qvtr Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Condition</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp#getQvtr_qvtrCondition()
	 * @see #getTC_mapIfExp()
	 * @generated
	 */
	EReference getTC_mapIfExp_Qvtr_qvtrCondition();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp#getQvtr_qvtrElse <em>Qvtr qvtr Else</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Else</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp#getQvtr_qvtrElse()
	 * @see #getTC_mapIfExp()
	 * @generated
	 */
	EReference getTC_mapIfExp_Qvtr_qvtrElse();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp#getQvtr_qvtrThen <em>Qvtr qvtr Then</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Then</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIfExp#getQvtr_qvtrThen()
	 * @see #getTC_mapIfExp()
	 * @generated
	 */
	EReference getTC_mapIfExp_Qvtr_qvtrThen();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern <em>TC map In Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map In Pattern</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern
	 * @generated
	 */
	EClass getTC_mapInPattern();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getAtl_atlModel <em>Atl atl Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Model</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getAtl_atlModel()
	 * @see #getTC_mapInPattern()
	 * @generated
	 */
	EReference getTC_mapInPattern_Atl_atlModel();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getAtl_atlModule()
	 * @see #getTC_mapInPattern()
	 * @generated
	 */
	EReference getTC_mapInPattern_Atl_atlModule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getAtl_atlPattern <em>Atl atl Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Pattern</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getAtl_atlPattern()
	 * @see #getTC_mapInPattern()
	 * @generated
	 */
	EReference getTC_mapInPattern_Atl_atlPattern();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getAtl_atlRule <em>Atl atl Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Rule</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getAtl_atlRule()
	 * @see #getTC_mapInPattern()
	 * @generated
	 */
	EReference getTC_mapInPattern_Atl_atlRule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getQvtr_qvtrDomain <em>Qvtr qvtr Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Domain</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getQvtr_qvtrDomain()
	 * @see #getTC_mapInPattern()
	 * @generated
	 */
	EReference getTC_mapInPattern_Qvtr_qvtrDomain();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getQvtr_qvtrRelation <em>Qvtr qvtr Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Relation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getQvtr_qvtrRelation()
	 * @see #getTC_mapInPattern()
	 * @generated
	 */
	EReference getTC_mapInPattern_Qvtr_qvtrRelation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getQvtr_qvtrTypedModel <em>Qvtr qvtr Typed Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Typed Model</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getQvtr_qvtrTypedModel()
	 * @see #getTC_mapInPattern()
	 * @generated
	 */
	EReference getTC_mapInPattern_Qvtr_qvtrTypedModel();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern#getStatus()
	 * @see #getTC_mapInPattern()
	 * @generated
	 */
	EAttribute getTC_mapInPattern_Status();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter <em>TC map In Pattern filter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map In Pattern filter</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter
	 * @generated
	 */
	EClass getTC_mapInPattern_filter();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getAtl_atlExpression <em>Atl atl Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getAtl_atlExpression()
	 * @see #getTC_mapInPattern_filter()
	 * @generated
	 */
	EReference getTC_mapInPattern_filter_Atl_atlExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getAtl_atlPattern <em>Atl atl Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Pattern</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getAtl_atlPattern()
	 * @see #getTC_mapInPattern_filter()
	 * @generated
	 */
	EReference getTC_mapInPattern_filter_Atl_atlPattern();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getAtl_atlRule <em>Atl atl Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Rule</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getAtl_atlRule()
	 * @see #getTC_mapInPattern_filter()
	 * @generated
	 */
	EReference getTC_mapInPattern_filter_Atl_atlRule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getQvtr_p <em>Qvtr p</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr p</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getQvtr_p()
	 * @see #getTC_mapInPattern_filter()
	 * @generated
	 */
	EReference getTC_mapInPattern_filter_Qvtr_p();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getQvtr_qvtrDomain <em>Qvtr qvtr Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Domain</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getQvtr_qvtrDomain()
	 * @see #getTC_mapInPattern_filter()
	 * @generated
	 */
	EReference getTC_mapInPattern_filter_Qvtr_qvtrDomain();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getQvtr_qvtrExpression <em>Qvtr qvtr Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getQvtr_qvtrExpression()
	 * @see #getTC_mapInPattern_filter()
	 * @generated
	 */
	EReference getTC_mapInPattern_filter_Qvtr_qvtrExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getQvtr_qvtrRelation <em>Qvtr qvtr Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Relation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getQvtr_qvtrRelation()
	 * @see #getTC_mapInPattern_filter()
	 * @generated
	 */
	EReference getTC_mapInPattern_filter_Qvtr_qvtrRelation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getQvtr_w <em>Qvtr w</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr w</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapInPattern_filter#getQvtr_w()
	 * @see #getTC_mapInPattern_filter()
	 * @generated
	 */
	EReference getTC_mapInPattern_filter_Qvtr_w();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIntegerExp <em>TC map Integer Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Integer Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIntegerExp
	 * @generated
	 */
	EClass getTC_mapIntegerExp();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIntegerExp#getPrimitive_symbol <em>Primitive symbol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive symbol</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapIntegerExp#getPrimitive_symbol()
	 * @see #getTC_mapIntegerExp()
	 * @generated
	 */
	EAttribute getTC_mapIntegerExp_Primitive_symbol();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule <em>TC map Matched Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Matched Rule</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule
	 * @generated
	 */
	EClass getTC_mapMatchedRule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule#getAtl_atlModule()
	 * @see #getTC_mapMatchedRule()
	 * @generated
	 */
	EReference getTC_mapMatchedRule_Atl_atlModule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule#getAtl_matchedRule <em>Atl matched Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl matched Rule</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule#getAtl_matchedRule()
	 * @see #getTC_mapMatchedRule()
	 * @generated
	 */
	EReference getTC_mapMatchedRule_Atl_matchedRule();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule#getPrimitive_ruleName <em>Primitive rule Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive rule Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule#getPrimitive_ruleName()
	 * @see #getTC_mapMatchedRule()
	 * @generated
	 */
	EAttribute getTC_mapMatchedRule_Primitive_ruleName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule#getQvtr_qvtrRelation <em>Qvtr qvtr Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Relation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule#getQvtr_qvtrRelation()
	 * @see #getTC_mapMatchedRule()
	 * @generated
	 */
	EReference getTC_mapMatchedRule_Qvtr_qvtrRelation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule#getQvtr_qvtrTransformation <em>Qvtr qvtr Transformation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Transformation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule#getQvtr_qvtrTransformation()
	 * @see #getTC_mapMatchedRule()
	 * @generated
	 */
	EReference getTC_mapMatchedRule_Qvtr_qvtrTransformation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule#getStatus()
	 * @see #getTC_mapMatchedRule()
	 * @generated
	 */
	EAttribute getTC_mapMatchedRule_Status();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule_super <em>TC map Matched Rule super</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Matched Rule super</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule_super
	 * @generated
	 */
	EClass getTC_mapMatchedRule_super();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule_super#getAtl_atlChildRule <em>Atl atl Child Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Child Rule</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule_super#getAtl_atlChildRule()
	 * @see #getTC_mapMatchedRule_super()
	 * @generated
	 */
	EReference getTC_mapMatchedRule_super_Atl_atlChildRule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule_super#getAtl_atlSuperRule <em>Atl atl Super Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Super Rule</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule_super#getAtl_atlSuperRule()
	 * @see #getTC_mapMatchedRule_super()
	 * @generated
	 */
	EReference getTC_mapMatchedRule_super_Atl_atlSuperRule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule_super#getQvtr_qvtrOverriddenRelation <em>Qvtr qvtr Overridden Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Overridden Relation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule_super#getQvtr_qvtrOverriddenRelation()
	 * @see #getTC_mapMatchedRule_super()
	 * @generated
	 */
	EReference getTC_mapMatchedRule_super_Qvtr_qvtrOverriddenRelation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule_super#getQvtr_qvtrOverridesRelation <em>Qvtr qvtr Overrides Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Overrides Relation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapMatchedRule_super#getQvtr_qvtrOverridesRelation()
	 * @see #getTC_mapMatchedRule_super()
	 * @generated
	 */
	EReference getTC_mapMatchedRule_super_Qvtr_qvtrOverridesRelation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule <em>TC map Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule
	 * @generated
	 */
	EClass getTC_mapModule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getAtl_atlModule()
	 * @see #getTC_mapModule()
	 * @generated
	 */
	EReference getTC_mapModule_Atl_atlModule();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getPrimitive_txName <em>Primitive tx Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive tx Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getPrimitive_txName()
	 * @see #getTC_mapModule()
	 * @generated
	 */
	EAttribute getTC_mapModule_Primitive_txName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getQvtr__3 <em>Qvtr 3</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr 3</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getQvtr__3()
	 * @see #getTC_mapModule()
	 * @generated
	 */
	EReference getTC_mapModule_Qvtr__3();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getQvtr__4 <em>Qvtr 4</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr 4</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getQvtr__4()
	 * @see #getTC_mapModule()
	 * @generated
	 */
	EReference getTC_mapModule_Qvtr__4();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getQvtr__5 <em>Qvtr 5</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr 5</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getQvtr__5()
	 * @see #getTC_mapModule()
	 * @generated
	 */
	EReference getTC_mapModule_Qvtr__5();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getQvtr_qvtrTransformation <em>Qvtr qvtr Transformation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Transformation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getQvtr_qvtrTransformation()
	 * @see #getTC_mapModule()
	 * @generated
	 */
	EReference getTC_mapModule_Qvtr_qvtrTransformation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapModule#getStatus()
	 * @see #getTC_mapModule()
	 * @generated
	 */
	EAttribute getTC_mapModule_Status();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp <em>TC map Navigation Or Attribute Call Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Navigation Or Attribute Call Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp
	 * @generated
	 */
	EClass getTC_mapNavigationOrAttributeCallExp();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper <em>TC map Navigation Or Attribute Call Exp Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Navigation Or Attribute Call Exp Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper
	 * @generated
	 */
	EClass getTC_mapNavigationOrAttributeCallExp_Helper();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getAtl_atlAttributes <em>Atl atl Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Atl atl Attributes</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getAtl_atlAttributes()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Helper_Atl_atlAttributes();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getAtl_atlModule()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Helper_Atl_atlModule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getAtl_atlSource <em>Atl atl Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Source</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getAtl_atlSource()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Helper_Atl_atlSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getPrimitive_propertyName <em>Primitive property Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive property Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getPrimitive_propertyName()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Helper()
	 * @generated
	 */
	EAttribute getTC_mapNavigationOrAttributeCallExp_Helper_Primitive_propertyName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getQvtr_qvtrOperation <em>Qvtr qvtr Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Operation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getQvtr_qvtrOperation()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Helper_Qvtr_qvtrOperation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getQvtr_qvtrSource <em>Qvtr qvtr Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Source</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getQvtr_qvtrSource()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Helper_Qvtr_qvtrSource();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getQvtr_qvtrSourceArgument <em>Qvtr qvtr Source Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Source Argument</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getQvtr_qvtrSourceArgument()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Helper_Qvtr_qvtrSourceArgument();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getQvtr_qvtrThisVariable <em>Qvtr qvtr This Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr This Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getQvtr_qvtrThisVariable()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Helper_Qvtr_qvtrThisVariable();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getQvtr_qvtrTransformation <em>Qvtr qvtr Transformation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Transformation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Helper#getQvtr_qvtrTransformation()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Helper_Qvtr_qvtrTransformation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property <em>TC map Navigation Or Attribute Call Exp Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Navigation Or Attribute Call Exp Property</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property
	 * @generated
	 */
	EClass getTC_mapNavigationOrAttributeCallExp_Property();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property#getAtl_atlAttributes <em>Atl atl Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Atl atl Attributes</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property#getAtl_atlAttributes()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Property()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Property_Atl_atlAttributes();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property#getAtl_atlModule()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Property()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Property_Atl_atlModule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property#getAtl_atlSource <em>Atl atl Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Source</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property#getAtl_atlSource()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Property()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Property_Atl_atlSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property#getPrimitive_propertyName <em>Primitive property Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive property Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property#getPrimitive_propertyName()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Property()
	 * @generated
	 */
	EAttribute getTC_mapNavigationOrAttributeCallExp_Property_Primitive_propertyName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property#getQvtr_qvtrProperty <em>Qvtr qvtr Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Property</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property#getQvtr_qvtrProperty()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Property()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Property_Qvtr_qvtrProperty();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property#getQvtr_qvtrSource <em>Qvtr qvtr Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Source</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapNavigationOrAttributeCallExp_Property#getQvtr_qvtrSource()
	 * @see #getTC_mapNavigationOrAttributeCallExp_Property()
	 * @generated
	 */
	EReference getTC_mapNavigationOrAttributeCallExp_Property_Qvtr_qvtrSource();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclExpression <em>TC map Ocl Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Ocl Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclExpression
	 * @generated
	 */
	EClass getTC_mapOclExpression();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclMetamodel <em>TC map Ocl Metamodel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Ocl Metamodel</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclMetamodel
	 * @generated
	 */
	EClass getTC_mapOclMetamodel();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclMetamodel#getAtl_oclMetamodel <em>Atl ocl Metamodel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl ocl Metamodel</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclMetamodel#getAtl_oclMetamodel()
	 * @see #getTC_mapOclMetamodel()
	 * @generated
	 */
	EReference getTC_mapOclMetamodel_Atl_oclMetamodel();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclMetamodel#getPrimitive_tmName <em>Primitive tm Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive tm Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclMetamodel#getPrimitive_tmName()
	 * @see #getTC_mapOclMetamodel()
	 * @generated
	 */
	EAttribute getTC_mapOclMetamodel_Primitive_tmName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclMetamodel#getQvtr_qvtrTypedModel <em>Qvtr qvtr Typed Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Typed Model</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclMetamodel#getQvtr_qvtrTypedModel()
	 * @see #getTC_mapOclMetamodel()
	 * @generated
	 */
	EReference getTC_mapOclMetamodel_Qvtr_qvtrTypedModel();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclMetamodel#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclMetamodel#getStatus()
	 * @see #getTC_mapOclMetamodel()
	 * @generated
	 */
	EAttribute getTC_mapOclMetamodel_Status();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN <em>TC map Ocl Model IN</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Ocl Model IN</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN
	 * @generated
	 */
	EClass getTC_mapOclModel_IN();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN#getAtl_atlModule()
	 * @see #getTC_mapOclModel_IN()
	 * @generated
	 */
	EReference getTC_mapOclModel_IN_Atl_atlModule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN#getAtl_oclMetamodel <em>Atl ocl Metamodel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl ocl Metamodel</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN#getAtl_oclMetamodel()
	 * @see #getTC_mapOclModel_IN()
	 * @generated
	 */
	EReference getTC_mapOclModel_IN_Atl_oclMetamodel();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN#getAtl_oclModel <em>Atl ocl Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl ocl Model</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN#getAtl_oclModel()
	 * @see #getTC_mapOclModel_IN()
	 * @generated
	 */
	EReference getTC_mapOclModel_IN_Atl_oclModel();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN#getPrimitive_tmName <em>Primitive tm Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive tm Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN#getPrimitive_tmName()
	 * @see #getTC_mapOclModel_IN()
	 * @generated
	 */
	EAttribute getTC_mapOclModel_IN_Primitive_tmName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN#getQvtr_qvtrTransformation <em>Qvtr qvtr Transformation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Transformation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN#getQvtr_qvtrTransformation()
	 * @see #getTC_mapOclModel_IN()
	 * @generated
	 */
	EReference getTC_mapOclModel_IN_Qvtr_qvtrTransformation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN#getQvtr_qvtrTypedModel <em>Qvtr qvtr Typed Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Typed Model</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_IN#getQvtr_qvtrTypedModel()
	 * @see #getTC_mapOclModel_IN()
	 * @generated
	 */
	EReference getTC_mapOclModel_IN_Qvtr_qvtrTypedModel();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT <em>TC map Ocl Model OUT</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Ocl Model OUT</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT
	 * @generated
	 */
	EClass getTC_mapOclModel_OUT();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT#getAtl_atlModule()
	 * @see #getTC_mapOclModel_OUT()
	 * @generated
	 */
	EReference getTC_mapOclModel_OUT_Atl_atlModule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT#getAtl_oclMetamodel <em>Atl ocl Metamodel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl ocl Metamodel</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT#getAtl_oclMetamodel()
	 * @see #getTC_mapOclModel_OUT()
	 * @generated
	 */
	EReference getTC_mapOclModel_OUT_Atl_oclMetamodel();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT#getAtl_oclModel <em>Atl ocl Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl ocl Model</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT#getAtl_oclModel()
	 * @see #getTC_mapOclModel_OUT()
	 * @generated
	 */
	EReference getTC_mapOclModel_OUT_Atl_oclModel();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT#getPrimitive_tmName <em>Primitive tm Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive tm Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT#getPrimitive_tmName()
	 * @see #getTC_mapOclModel_OUT()
	 * @generated
	 */
	EAttribute getTC_mapOclModel_OUT_Primitive_tmName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT#getQvtr_qvtrTransformation <em>Qvtr qvtr Transformation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Transformation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT#getQvtr_qvtrTransformation()
	 * @see #getTC_mapOclModel_OUT()
	 * @generated
	 */
	EReference getTC_mapOclModel_OUT_Qvtr_qvtrTransformation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT#getQvtr_qvtrTypedModel <em>Qvtr qvtr Typed Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Typed Model</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOclModel_OUT#getQvtr_qvtrTypedModel()
	 * @see #getTC_mapOclModel_OUT()
	 * @generated
	 */
	EReference getTC_mapOclModel_OUT_Qvtr_qvtrTypedModel();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp <em>TC map Operation Call Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Operation Call Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp
	 * @generated
	 */
	EClass getTC_mapOperationCallExp();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper <em>TC map Operation Call Exp Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Operation Call Exp Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper
	 * @generated
	 */
	EClass getTC_mapOperationCallExp_Helper();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getAtl_atlModule()
	 * @see #getTC_mapOperationCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Helper_Atl_atlModule();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getAtl_atlOperations <em>Atl atl Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Atl atl Operations</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getAtl_atlOperations()
	 * @see #getTC_mapOperationCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Helper_Atl_atlOperations();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getAtl_atlSource <em>Atl atl Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Source</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getAtl_atlSource()
	 * @see #getTC_mapOperationCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Helper_Atl_atlSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getPrimitive_operationName <em>Primitive operation Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive operation Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getPrimitive_operationName()
	 * @see #getTC_mapOperationCallExp_Helper()
	 * @generated
	 */
	EAttribute getTC_mapOperationCallExp_Helper_Primitive_operationName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getQvtr_qvtrOperation <em>Qvtr qvtr Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Operation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getQvtr_qvtrOperation()
	 * @see #getTC_mapOperationCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Helper_Qvtr_qvtrOperation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getQvtr_qvtrSource <em>Qvtr qvtr Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Source</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getQvtr_qvtrSource()
	 * @see #getTC_mapOperationCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Helper_Qvtr_qvtrSource();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getQvtr_qvtrSourceArgument <em>Qvtr qvtr Source Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Source Argument</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getQvtr_qvtrSourceArgument()
	 * @see #getTC_mapOperationCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Helper_Qvtr_qvtrSourceArgument();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getQvtr_qvtrThisVariable <em>Qvtr qvtr This Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr This Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getQvtr_qvtrThisVariable()
	 * @see #getTC_mapOperationCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Helper_Qvtr_qvtrThisVariable();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getQvtr_qvtrTransformation <em>Qvtr qvtr Transformation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Transformation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Helper#getQvtr_qvtrTransformation()
	 * @see #getTC_mapOperationCallExp_Helper()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Helper_Qvtr_qvtrTransformation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation <em>TC map Operation Call Exp Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Operation Call Exp Operation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation
	 * @generated
	 */
	EClass getTC_mapOperationCallExp_Operation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation#getAtl_atlModule()
	 * @see #getTC_mapOperationCallExp_Operation()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Operation_Atl_atlModule();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation#getAtl_atlOperations <em>Atl atl Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Atl atl Operations</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation#getAtl_atlOperations()
	 * @see #getTC_mapOperationCallExp_Operation()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Operation_Atl_atlOperations();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation#getAtl_atlSource <em>Atl atl Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Source</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation#getAtl_atlSource()
	 * @see #getTC_mapOperationCallExp_Operation()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Operation_Atl_atlSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation#getPrimitive_operationName <em>Primitive operation Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive operation Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation#getPrimitive_operationName()
	 * @see #getTC_mapOperationCallExp_Operation()
	 * @generated
	 */
	EAttribute getTC_mapOperationCallExp_Operation_Primitive_operationName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation#getQvtr_qvtrOperation <em>Qvtr qvtr Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Operation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation#getQvtr_qvtrOperation()
	 * @see #getTC_mapOperationCallExp_Operation()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Operation_Qvtr_qvtrOperation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation#getQvtr_qvtrSource <em>Qvtr qvtr Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Source</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_Operation#getQvtr_qvtrSource()
	 * @see #getTC_mapOperationCallExp_Operation()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_Operation_Qvtr_qvtrSource();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_argument <em>TC map Operation Call Exp argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Operation Call Exp argument</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_argument
	 * @generated
	 */
	EClass getTC_mapOperationCallExp_argument();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_argument#getAtl_atlArgument <em>Atl atl Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Argument</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_argument#getAtl_atlArgument()
	 * @see #getTC_mapOperationCallExp_argument()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_argument_Atl_atlArgument();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_argument#getAtl_atlParent <em>Atl atl Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Parent</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_argument#getAtl_atlParent()
	 * @see #getTC_mapOperationCallExp_argument()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_argument_Atl_atlParent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_argument#getQvtr_qvtrArgument <em>Qvtr qvtr Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Argument</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_argument#getQvtr_qvtrArgument()
	 * @see #getTC_mapOperationCallExp_argument()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_argument_Qvtr_qvtrArgument();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_argument#getQvtr_qvtrParent <em>Qvtr qvtr Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Parent</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperationCallExp_argument#getQvtr_qvtrParent()
	 * @see #getTC_mapOperationCallExp_argument()
	 * @generated
	 */
	EReference getTC_mapOperationCallExp_argument_Qvtr_qvtrParent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp <em>TC map Operator Call Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Operator Call Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp
	 * @generated
	 */
	EClass getTC_mapOperatorCallExp();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp#getAtl_atlModule()
	 * @see #getTC_mapOperatorCallExp()
	 * @generated
	 */
	EReference getTC_mapOperatorCallExp_Atl_atlModule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp#getAtl_atlSource <em>Atl atl Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Source</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp#getAtl_atlSource()
	 * @see #getTC_mapOperatorCallExp()
	 * @generated
	 */
	EReference getTC_mapOperatorCallExp_Atl_atlSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp#getPrimitive_operationName <em>Primitive operation Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive operation Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp#getPrimitive_operationName()
	 * @see #getTC_mapOperatorCallExp()
	 * @generated
	 */
	EAttribute getTC_mapOperatorCallExp_Primitive_operationName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp#getQvtr_qvtrOperation <em>Qvtr qvtr Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Operation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp#getQvtr_qvtrOperation()
	 * @see #getTC_mapOperatorCallExp()
	 * @generated
	 */
	EReference getTC_mapOperatorCallExp_Qvtr_qvtrOperation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp#getQvtr_qvtrSource <em>Qvtr qvtr Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Source</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp#getQvtr_qvtrSource()
	 * @see #getTC_mapOperatorCallExp()
	 * @generated
	 */
	EReference getTC_mapOperatorCallExp_Qvtr_qvtrSource();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp#getQvtr_qvtrTransformation <em>Qvtr qvtr Transformation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Transformation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOperatorCallExp#getQvtr_qvtrTransformation()
	 * @see #getTC_mapOperatorCallExp()
	 * @generated
	 */
	EReference getTC_mapOperatorCallExp_Qvtr_qvtrTransformation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern <em>TC map Out Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Out Pattern</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern
	 * @generated
	 */
	EClass getTC_mapOutPattern();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getAtl_atlModule <em>Atl atl Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Module</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getAtl_atlModule()
	 * @see #getTC_mapOutPattern()
	 * @generated
	 */
	EReference getTC_mapOutPattern_Atl_atlModule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getAtl_atlPattern <em>Atl atl Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Pattern</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getAtl_atlPattern()
	 * @see #getTC_mapOutPattern()
	 * @generated
	 */
	EReference getTC_mapOutPattern_Atl_atlPattern();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getAtl_atlRule <em>Atl atl Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Rule</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getAtl_atlRule()
	 * @see #getTC_mapOutPattern()
	 * @generated
	 */
	EReference getTC_mapOutPattern_Atl_atlRule();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getQvtr_qvtrDomain <em>Qvtr qvtr Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Domain</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getQvtr_qvtrDomain()
	 * @see #getTC_mapOutPattern()
	 * @generated
	 */
	EReference getTC_mapOutPattern_Qvtr_qvtrDomain();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getQvtr_qvtrRelation <em>Qvtr qvtr Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Relation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getQvtr_qvtrRelation()
	 * @see #getTC_mapOutPattern()
	 * @generated
	 */
	EReference getTC_mapOutPattern_Qvtr_qvtrRelation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getQvtr_qvtrTypedModel <em>Qvtr qvtr Typed Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Typed Model</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getQvtr_qvtrTypedModel()
	 * @see #getTC_mapOutPattern()
	 * @generated
	 */
	EReference getTC_mapOutPattern_Qvtr_qvtrTypedModel();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapOutPattern#getStatus()
	 * @see #getTC_mapOutPattern()
	 * @generated
	 */
	EAttribute getTC_mapOutPattern_Status();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement <em>TC map Simple In Pattern Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Simple In Pattern Element</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement
	 * @generated
	 */
	EClass getTC_mapSimpleInPatternElement();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getAtl_atlElement <em>Atl atl Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Element</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getAtl_atlElement()
	 * @see #getTC_mapSimpleInPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleInPatternElement_Atl_atlElement();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getAtl_atlPattern <em>Atl atl Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Pattern</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getAtl_atlPattern()
	 * @see #getTC_mapSimpleInPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleInPatternElement_Atl_atlPattern();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getAtl_atlRule <em>Atl atl Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Rule</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getAtl_atlRule()
	 * @see #getTC_mapSimpleInPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleInPatternElement_Atl_atlRule();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getInvocation_mapVariable <em>Invocation map Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Invocation map Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getInvocation_mapVariable()
	 * @see #getTC_mapSimpleInPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleInPatternElement_Invocation_mapVariable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getPrimitive_elementName <em>Primitive element Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive element Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getPrimitive_elementName()
	 * @see #getTC_mapSimpleInPatternElement()
	 * @generated
	 */
	EAttribute getTC_mapSimpleInPatternElement_Primitive_elementName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getQvtr_qvtrDomain <em>Qvtr qvtr Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Domain</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getQvtr_qvtrDomain()
	 * @see #getTC_mapSimpleInPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleInPatternElement_Qvtr_qvtrDomain();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getQvtr_qvtrDomain1 <em>Qvtr qvtr Domain1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Domain1</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getQvtr_qvtrDomain1()
	 * @see #getTC_mapSimpleInPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleInPatternElement_Qvtr_qvtrDomain1();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getQvtr_qvtrPattern <em>Qvtr qvtr Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Pattern</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getQvtr_qvtrPattern()
	 * @see #getTC_mapSimpleInPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleInPatternElement_Qvtr_qvtrPattern();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getQvtr_qvtrRelation <em>Qvtr qvtr Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Relation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getQvtr_qvtrRelation()
	 * @see #getTC_mapSimpleInPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleInPatternElement_Qvtr_qvtrRelation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getQvtr_qvtrTemplate <em>Qvtr qvtr Template</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Template</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getQvtr_qvtrTemplate()
	 * @see #getTC_mapSimpleInPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleInPatternElement_Qvtr_qvtrTemplate();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getQvtr_qvtrVariable <em>Qvtr qvtr Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleInPatternElement#getQvtr_qvtrVariable()
	 * @see #getTC_mapSimpleInPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleInPatternElement_Qvtr_qvtrVariable();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement <em>TC map Simple Out Pattern Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Simple Out Pattern Element</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement
	 * @generated
	 */
	EClass getTC_mapSimpleOutPatternElement();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getAtl_atlElement <em>Atl atl Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Element</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getAtl_atlElement()
	 * @see #getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleOutPatternElement_Atl_atlElement();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getAtl_atlPattern <em>Atl atl Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Pattern</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getAtl_atlPattern()
	 * @see #getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleOutPatternElement_Atl_atlPattern();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getAtl_atlRule <em>Atl atl Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Rule</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getAtl_atlRule()
	 * @see #getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleOutPatternElement_Atl_atlRule();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getInvocation_mapVariable <em>Invocation map Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Invocation map Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getInvocation_mapVariable()
	 * @see #getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleOutPatternElement_Invocation_mapVariable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getPrimitive_elementName <em>Primitive element Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive element Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getPrimitive_elementName()
	 * @see #getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	EAttribute getTC_mapSimpleOutPatternElement_Primitive_elementName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getQvtr_qvtrDomain <em>Qvtr qvtr Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Domain</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getQvtr_qvtrDomain()
	 * @see #getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleOutPatternElement_Qvtr_qvtrDomain();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getQvtr_qvtrDomain1 <em>Qvtr qvtr Domain1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Domain1</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getQvtr_qvtrDomain1()
	 * @see #getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleOutPatternElement_Qvtr_qvtrDomain1();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getQvtr_qvtrPattern <em>Qvtr qvtr Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Pattern</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getQvtr_qvtrPattern()
	 * @see #getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleOutPatternElement_Qvtr_qvtrPattern();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getQvtr_qvtrRelation <em>Qvtr qvtr Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Relation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getQvtr_qvtrRelation()
	 * @see #getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleOutPatternElement_Qvtr_qvtrRelation();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getQvtr_qvtrTemplate <em>Qvtr qvtr Template</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Template</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getQvtr_qvtrTemplate()
	 * @see #getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleOutPatternElement_Qvtr_qvtrTemplate();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getQvtr_qvtrVariable <em>Qvtr qvtr Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getQvtr_qvtrVariable()
	 * @see #getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	EReference getTC_mapSimpleOutPatternElement_Qvtr_qvtrVariable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapSimpleOutPatternElement#getStatus()
	 * @see #getTC_mapSimpleOutPatternElement()
	 * @generated
	 */
	EAttribute getTC_mapSimpleOutPatternElement_Status();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapStringExp <em>TC map String Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map String Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapStringExp
	 * @generated
	 */
	EClass getTC_mapStringExp();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapStringExp#getPrimitive_symbol <em>Primitive symbol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive symbol</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapStringExp#getPrimitive_symbol()
	 * @see #getTC_mapStringExp()
	 * @generated
	 */
	EAttribute getTC_mapStringExp_Primitive_symbol();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariable <em>TC map Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariable
	 * @generated
	 */
	EClass getTC_mapVariable();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariable#getAtl_atlVariable <em>Atl atl Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariable#getAtl_atlVariable()
	 * @see #getTC_mapVariable()
	 * @generated
	 */
	EReference getTC_mapVariable_Atl_atlVariable();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariable#getQvtr_qvtrVariable <em>Qvtr qvtr Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariable#getQvtr_qvtrVariable()
	 * @see #getTC_mapVariable()
	 * @generated
	 */
	EReference getTC_mapVariable_Qvtr_qvtrVariable();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp <em>TC map Variable Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Variable Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp
	 * @generated
	 */
	EClass getTC_mapVariableExp();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp#getAtl_atlVariable <em>Atl atl Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp#getAtl_atlVariable()
	 * @see #getTC_mapVariableExp()
	 * @generated
	 */
	EReference getTC_mapVariableExp_Atl_atlVariable();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp#getInvocation_mapVariableExp_referredVariable <em>Invocation map Variable Exp referred Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Invocation map Variable Exp referred Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp#getInvocation_mapVariableExp_referredVariable()
	 * @see #getTC_mapVariableExp()
	 * @generated
	 */
	EReference getTC_mapVariableExp_Invocation_mapVariableExp_referredVariable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp#getPrimitive_varName <em>Primitive var Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive var Name</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp#getPrimitive_varName()
	 * @see #getTC_mapVariableExp()
	 * @generated
	 */
	EAttribute getTC_mapVariableExp_Primitive_varName();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable <em>TC map Variable Exp referred Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Variable Exp referred Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable
	 * @generated
	 */
	EClass getTC_mapVariableExp_referredVariable();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable#getAtl_atlExpression1 <em>Atl atl Expression1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Expression1</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable#getAtl_atlExpression1()
	 * @see #getTC_mapVariableExp_referredVariable()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_Atl_atlExpression1();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable#getQvtr_qvtrExpression1 <em>Qvtr qvtr Expression1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Expression1</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable#getQvtr_qvtrExpression1()
	 * @see #getTC_mapVariableExp_referredVariable()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_Qvtr_qvtrExpression1();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper <em>TC map Variable Exp referred Variable Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Variable Exp referred Variable Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper
	 * @generated
	 */
	EClass getTC_mapVariableExp_referredVariable_Helper();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper#getAtl_atlExpression <em>Atl atl Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper#getAtl_atlExpression()
	 * @see #getTC_mapVariableExp_referredVariable_Helper()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_Helper_Atl_atlExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper#getAtl_atlHelper <em>Atl atl Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper#getAtl_atlHelper()
	 * @see #getTC_mapVariableExp_referredVariable_Helper()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_Helper_Atl_atlHelper();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper#getAtl_atlVariable <em>Atl atl Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper#getAtl_atlVariable()
	 * @see #getTC_mapVariableExp_referredVariable_Helper()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_Helper_Atl_atlVariable();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper#getInvocation_mapVariable <em>Invocation map Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Invocation map Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper#getInvocation_mapVariable()
	 * @see #getTC_mapVariableExp_referredVariable_Helper()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_Helper_Invocation_mapVariable();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper#getQvtr_qvtrExpression <em>Qvtr qvtr Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper#getQvtr_qvtrExpression()
	 * @see #getTC_mapVariableExp_referredVariable_Helper()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_Helper_Qvtr_qvtrExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper#getQvtr_qvtrVariable <em>Qvtr qvtr Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_Helper#getQvtr_qvtrVariable()
	 * @see #getTC_mapVariableExp_referredVariable_Helper()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_Helper_Qvtr_qvtrVariable();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_VariableDeclaration <em>TC map Variable Exp referred Variable Variable Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TC map Variable Exp referred Variable Variable Declaration</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_VariableDeclaration
	 * @generated
	 */
	EClass getTC_mapVariableExp_referredVariable_VariableDeclaration();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_VariableDeclaration#getAtl_atlExpression <em>Atl atl Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_VariableDeclaration#getAtl_atlExpression()
	 * @see #getTC_mapVariableExp_referredVariable_VariableDeclaration()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_VariableDeclaration_Atl_atlExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_VariableDeclaration#getAtl_atlVariable <em>Atl atl Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_VariableDeclaration#getAtl_atlVariable()
	 * @see #getTC_mapVariableExp_referredVariable_VariableDeclaration()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_VariableDeclaration_Atl_atlVariable();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_VariableDeclaration#getInvocation_mapVariable <em>Invocation map Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Invocation map Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_VariableDeclaration#getInvocation_mapVariable()
	 * @see #getTC_mapVariableExp_referredVariable_VariableDeclaration()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_VariableDeclaration_Invocation_mapVariable();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_VariableDeclaration#getQvtr_qvtrExpression <em>Qvtr qvtr Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_VariableDeclaration#getQvtr_qvtrExpression()
	 * @see #getTC_mapVariableExp_referredVariable_VariableDeclaration()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_VariableDeclaration_Qvtr_qvtrExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_VariableDeclaration#getQvtr_qvtrVariable <em>Qvtr qvtr Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TC_mapVariableExp_referredVariable_VariableDeclaration#getQvtr_qvtrVariable()
	 * @see #getTC_mapVariableExp_referredVariable_VariableDeclaration()
	 * @generated
	 */
	EReference getTC_mapVariableExp_referredVariable_VariableDeclaration_Qvtr_qvtrVariable();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapBooleanExp <em>TI map Boolean Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Boolean Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapBooleanExp
	 * @generated
	 */
	EClass getTI_mapBooleanExp();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapHelper <em>TI map Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapHelper
	 * @generated
	 */
	EClass getTI_mapHelper();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapHelper#getAtl_atlHelper <em>Atl atl Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapHelper#getAtl_atlHelper()
	 * @see #getTI_mapHelper()
	 * @generated
	 */
	EReference getTI_mapHelper_Atl_atlHelper();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapHelper#getQvtr_qvtrFunction <em>Qvtr qvtr Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Function</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapHelper#getQvtr_qvtrFunction()
	 * @see #getTI_mapHelper()
	 * @generated
	 */
	EReference getTI_mapHelper_Qvtr_qvtrFunction();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapHelper#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapHelper#getStatus()
	 * @see #getTI_mapHelper()
	 * @generated
	 */
	EAttribute getTI_mapHelper_Status();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapHelper_Attribute <em>TI map Helper Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Helper Attribute</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapHelper_Attribute
	 * @generated
	 */
	EClass getTI_mapHelper_Attribute();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapHelper_Operation <em>TI map Helper Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Helper Operation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapHelper_Operation
	 * @generated
	 */
	EClass getTI_mapHelper_Operation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapIfExp <em>TI map If Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map If Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapIfExp
	 * @generated
	 */
	EClass getTI_mapIfExp();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapIntegerExp <em>TI map Integer Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Integer Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapIntegerExp
	 * @generated
	 */
	EClass getTI_mapIntegerExp();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapNavigationOrAttributeCallExp <em>TI map Navigation Or Attribute Call Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Navigation Or Attribute Call Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapNavigationOrAttributeCallExp
	 * @generated
	 */
	EClass getTI_mapNavigationOrAttributeCallExp();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapNavigationOrAttributeCallExp_Helper <em>TI map Navigation Or Attribute Call Exp Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Navigation Or Attribute Call Exp Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapNavigationOrAttributeCallExp_Helper
	 * @generated
	 */
	EClass getTI_mapNavigationOrAttributeCallExp_Helper();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapNavigationOrAttributeCallExp_Property <em>TI map Navigation Or Attribute Call Exp Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Navigation Or Attribute Call Exp Property</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapNavigationOrAttributeCallExp_Property
	 * @generated
	 */
	EClass getTI_mapNavigationOrAttributeCallExp_Property();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOclExpression <em>TI map Ocl Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Ocl Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOclExpression
	 * @generated
	 */
	EClass getTI_mapOclExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOclExpression#getAtl_atlExpression <em>Atl atl Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOclExpression#getAtl_atlExpression()
	 * @see #getTI_mapOclExpression()
	 * @generated
	 */
	EReference getTI_mapOclExpression_Atl_atlExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOclExpression#getQvtr_qvtrExpression <em>Qvtr qvtr Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOclExpression#getQvtr_qvtrExpression()
	 * @see #getTI_mapOclExpression()
	 * @generated
	 */
	EReference getTI_mapOclExpression_Qvtr_qvtrExpression();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOclExpression#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOclExpression#getStatus()
	 * @see #getTI_mapOclExpression()
	 * @generated
	 */
	EAttribute getTI_mapOclExpression_Status();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOperationCallExp <em>TI map Operation Call Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Operation Call Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOperationCallExp
	 * @generated
	 */
	EClass getTI_mapOperationCallExp();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOperationCallExp_Helper <em>TI map Operation Call Exp Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Operation Call Exp Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOperationCallExp_Helper
	 * @generated
	 */
	EClass getTI_mapOperationCallExp_Helper();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOperationCallExp_Operation <em>TI map Operation Call Exp Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Operation Call Exp Operation</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOperationCallExp_Operation
	 * @generated
	 */
	EClass getTI_mapOperationCallExp_Operation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOperatorCallExp <em>TI map Operator Call Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Operator Call Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapOperatorCallExp
	 * @generated
	 */
	EClass getTI_mapOperatorCallExp();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapStringExp <em>TI map String Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map String Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapStringExp
	 * @generated
	 */
	EClass getTI_mapStringExp();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapVariableExp <em>TI map Variable Exp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Variable Exp</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapVariableExp
	 * @generated
	 */
	EClass getTI_mapVariableExp();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapVariableExp_referredVariable <em>TI map Variable Exp referred Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Variable Exp referred Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapVariableExp_referredVariable
	 * @generated
	 */
	EClass getTI_mapVariableExp_referredVariable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapVariableExp_referredVariable#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapVariableExp_referredVariable#getStatus()
	 * @see #getTI_mapVariableExp_referredVariable()
	 * @generated
	 */
	EAttribute getTI_mapVariableExp_referredVariable_Status();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapVariableExp_referredVariable_Helper <em>TI map Variable Exp referred Variable Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Variable Exp referred Variable Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapVariableExp_referredVariable_Helper
	 * @generated
	 */
	EClass getTI_mapVariableExp_referredVariable_Helper();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapVariableExp_referredVariable_VariableDeclaration <em>TI map Variable Exp referred Variable Variable Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TI map Variable Exp referred Variable Variable Declaration</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.TI_mapVariableExp_referredVariable_VariableDeclaration
	 * @generated
	 */
	EClass getTI_mapVariableExp_referredVariable_VariableDeclaration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WC_mapVariableExp_referredVariable <em>WC map Variable Exp referred Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>WC map Variable Exp referred Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WC_mapVariableExp_referredVariable
	 * @generated
	 */
	EClass getWC_mapVariableExp_referredVariable();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WC_mapVariableExp_referredVariable_Helper <em>WC map Variable Exp referred Variable Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>WC map Variable Exp referred Variable Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WC_mapVariableExp_referredVariable_Helper
	 * @generated
	 */
	EClass getWC_mapVariableExp_referredVariable_Helper();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WC_mapVariableExp_referredVariable_VariableDeclaration <em>WC map Variable Exp referred Variable Variable Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>WC map Variable Exp referred Variable Variable Declaration</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WC_mapVariableExp_referredVariable_VariableDeclaration
	 * @generated
	 */
	EClass getWC_mapVariableExp_referredVariable_VariableDeclaration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WI_mapVariableExp_referredVariable <em>WI map Variable Exp referred Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>WI map Variable Exp referred Variable</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WI_mapVariableExp_referredVariable
	 * @generated
	 */
	EClass getWI_mapVariableExp_referredVariable();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WI_mapVariableExp_referredVariable#getAtl_atlExpression <em>Atl atl Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Atl atl Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WI_mapVariableExp_referredVariable#getAtl_atlExpression()
	 * @see #getWI_mapVariableExp_referredVariable()
	 * @generated
	 */
	EReference getWI_mapVariableExp_referredVariable_Atl_atlExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WI_mapVariableExp_referredVariable#getQvtr_qvtrExpression <em>Qvtr qvtr Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Qvtr qvtr Expression</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WI_mapVariableExp_referredVariable#getQvtr_qvtrExpression()
	 * @see #getWI_mapVariableExp_referredVariable()
	 * @generated
	 */
	EReference getWI_mapVariableExp_referredVariable_Qvtr_qvtrExpression();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WI_mapVariableExp_referredVariable#getResult <em>Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Result</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WI_mapVariableExp_referredVariable#getResult()
	 * @see #getWI_mapVariableExp_referredVariable()
	 * @generated
	 */
	EReference getWI_mapVariableExp_referredVariable_Result();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WI_mapVariableExp_referredVariable_Helper <em>WI map Variable Exp referred Variable Helper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>WI map Variable Exp referred Variable Helper</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WI_mapVariableExp_referredVariable_Helper
	 * @generated
	 */
	EClass getWI_mapVariableExp_referredVariable_Helper();

	/**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WI_mapVariableExp_referredVariable_VariableDeclaration <em>WI map Variable Exp referred Variable Variable Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>WI map Variable Exp referred Variable Variable Declaration</em>'.
	 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.WI_mapVariableExp_referredVariable_VariableDeclaration
	 * @generated
	 */
	EClass getWI_mapVariableExp_referredVariable_VariableDeclaration();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	trace_ATL2QVTrFactory gettrace_ATL2QVTrFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapBindingImpl <em>TC map Binding</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapBindingImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapBinding()
		 * @generated
		 */
		EClass TC_MAP_BINDING = eINSTANCE.getTC_mapBinding();

		/**
		 * The meta object literal for the '<em><b>Atl atl Binding</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_BINDING__ATL_ATL_BINDING = eINSTANCE.getTC_mapBinding_Atl_atlBinding();

		/**
		 * The meta object literal for the '<em><b>Atl atl Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_BINDING__ATL_ATL_EXPRESSION = eINSTANCE.getTC_mapBinding_Atl_atlExpression();

		/**
		 * The meta object literal for the '<em><b>Atl atl Out Pattern Element</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_BINDING__ATL_ATL_OUT_PATTERN_ELEMENT = eINSTANCE.getTC_mapBinding_Atl_atlOutPatternElement();

		/**
		 * The meta object literal for the '<em><b>Primitive property Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_BINDING__PRIMITIVE_PROPERTY_NAME = eINSTANCE.getTC_mapBinding_Primitive_propertyName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_BINDING__QVTR_QVTR_EXPRESSION = eINSTANCE.getTC_mapBinding_Qvtr_qvtrExpression();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Part</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_BINDING__QVTR_QVTR_PART = eINSTANCE.getTC_mapBinding_Qvtr_qvtrPart();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Template</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_BINDING__QVTR_QVTR_TEMPLATE = eINSTANCE.getTC_mapBinding_Qvtr_qvtrTemplate();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapBooleanExpImpl <em>TC map Boolean Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapBooleanExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapBooleanExp()
		 * @generated
		 */
		EClass TC_MAP_BOOLEAN_EXP = eINSTANCE.getTC_mapBooleanExp();

		/**
		 * The meta object literal for the '<em><b>Primitive symbol</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_BOOLEAN_EXP__PRIMITIVE_SYMBOL = eINSTANCE.getTC_mapBooleanExp_Primitive_symbol();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelperImpl <em>TC map Helper</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelperImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapHelper()
		 * @generated
		 */
		EClass TC_MAP_HELPER = eINSTANCE.getTC_mapHelper();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelper_AttributeImpl <em>TC map Helper Attribute</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelper_AttributeImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapHelper_Attribute()
		 * @generated
		 */
		EClass TC_MAP_HELPER_ATTRIBUTE = eINSTANCE.getTC_mapHelper_Attribute();

		/**
		 * The meta object literal for the '<em><b>Atl atl Definition</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_ATTRIBUTE__ATL_ATL_DEFINITION = eINSTANCE.getTC_mapHelper_Attribute_Atl_atlDefinition();

		/**
		 * The meta object literal for the '<em><b>Atl atl Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_ATTRIBUTE__ATL_ATL_EXPRESSION = eINSTANCE.getTC_mapHelper_Attribute_Atl_atlExpression();

		/**
		 * The meta object literal for the '<em><b>Atl atl Feature</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_ATTRIBUTE__ATL_ATL_FEATURE = eINSTANCE.getTC_mapHelper_Attribute_Atl_atlFeature();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_ATTRIBUTE__ATL_ATL_MODULE = eINSTANCE.getTC_mapHelper_Attribute_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Atl atl Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_ATTRIBUTE__ATL_ATL_TYPE = eINSTANCE.getTC_mapHelper_Attribute_Atl_atlType();

		/**
		 * The meta object literal for the '<em><b>Invocation map Helper Context</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_ATTRIBUTE__INVOCATION_MAP_HELPER_CONTEXT = eINSTANCE.getTC_mapHelper_Attribute_Invocation_mapHelper_Context();

		/**
		 * The meta object literal for the '<em><b>Primitive attribute Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_HELPER_ATTRIBUTE__PRIMITIVE_ATTRIBUTE_NAME = eINSTANCE.getTC_mapHelper_Attribute_Primitive_attributeName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_ATTRIBUTE__QVTR_QVTR_EXPRESSION = eINSTANCE.getTC_mapHelper_Attribute_Qvtr_qvtrExpression();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Transformation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_ATTRIBUTE__QVTR_QVTR_TRANSFORMATION = eINSTANCE.getTC_mapHelper_Attribute_Qvtr_qvtrTransformation();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelper_ContextImpl <em>TC map Helper Context</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelper_ContextImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapHelper_Context()
		 * @generated
		 */
		EClass TC_MAP_HELPER_CONTEXT = eINSTANCE.getTC_mapHelper_Context();

		/**
		 * The meta object literal for the '<em><b>Atl atl Context</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_CONTEXT__ATL_ATL_CONTEXT = eINSTANCE.getTC_mapHelper_Context_Atl_atlContext();

		/**
		 * The meta object literal for the '<em><b>Atl atl Definition</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_CONTEXT__ATL_ATL_DEFINITION = eINSTANCE.getTC_mapHelper_Context_Atl_atlDefinition();

		/**
		 * The meta object literal for the '<em><b>Atl atl Helper</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_CONTEXT__ATL_ATL_HELPER = eINSTANCE.getTC_mapHelper_Context_Atl_atlHelper();

		/**
		 * The meta object literal for the '<em><b>Atl atl Return Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_CONTEXT__ATL_ATL_RETURN_TYPE = eINSTANCE.getTC_mapHelper_Context_Atl_atlReturnType();

		/**
		 * The meta object literal for the '<em><b>Invocation map Variable</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_CONTEXT__INVOCATION_MAP_VARIABLE = eINSTANCE.getTC_mapHelper_Context_Invocation_mapVariable();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Function</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_CONTEXT__QVTR_QVTR_FUNCTION = eINSTANCE.getTC_mapHelper_Context_Qvtr_qvtrFunction();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Parameter</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_CONTEXT__QVTR_QVTR_PARAMETER = eINSTANCE.getTC_mapHelper_Context_Qvtr_qvtrParameter();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelper_OperationImpl <em>TC map Helper Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapHelper_OperationImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapHelper_Operation()
		 * @generated
		 */
		EClass TC_MAP_HELPER_OPERATION = eINSTANCE.getTC_mapHelper_Operation();

		/**
		 * The meta object literal for the '<em><b>Atl atl Definition</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_OPERATION__ATL_ATL_DEFINITION = eINSTANCE.getTC_mapHelper_Operation_Atl_atlDefinition();

		/**
		 * The meta object literal for the '<em><b>Atl atl Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_OPERATION__ATL_ATL_EXPRESSION = eINSTANCE.getTC_mapHelper_Operation_Atl_atlExpression();

		/**
		 * The meta object literal for the '<em><b>Atl atl Feature</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_OPERATION__ATL_ATL_FEATURE = eINSTANCE.getTC_mapHelper_Operation_Atl_atlFeature();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_OPERATION__ATL_ATL_MODULE = eINSTANCE.getTC_mapHelper_Operation_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Atl atl Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_OPERATION__ATL_ATL_TYPE = eINSTANCE.getTC_mapHelper_Operation_Atl_atlType();

		/**
		 * The meta object literal for the '<em><b>Invocation map Helper Context</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_OPERATION__INVOCATION_MAP_HELPER_CONTEXT = eINSTANCE.getTC_mapHelper_Operation_Invocation_mapHelper_Context();

		/**
		 * The meta object literal for the '<em><b>Primitive operation Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_HELPER_OPERATION__PRIMITIVE_OPERATION_NAME = eINSTANCE.getTC_mapHelper_Operation_Primitive_operationName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_OPERATION__QVTR_QVTR_EXPRESSION = eINSTANCE.getTC_mapHelper_Operation_Qvtr_qvtrExpression();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Transformation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_HELPER_OPERATION__QVTR_QVTR_TRANSFORMATION = eINSTANCE.getTC_mapHelper_Operation_Qvtr_qvtrTransformation();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapIfExpImpl <em>TC map If Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapIfExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapIfExp()
		 * @generated
		 */
		EClass TC_MAP_IF_EXP = eINSTANCE.getTC_mapIfExp();

		/**
		 * The meta object literal for the '<em><b>Atl atl Condition</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IF_EXP__ATL_ATL_CONDITION = eINSTANCE.getTC_mapIfExp_Atl_atlCondition();

		/**
		 * The meta object literal for the '<em><b>Atl atl Else</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IF_EXP__ATL_ATL_ELSE = eINSTANCE.getTC_mapIfExp_Atl_atlElse();

		/**
		 * The meta object literal for the '<em><b>Atl atl Then</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IF_EXP__ATL_ATL_THEN = eINSTANCE.getTC_mapIfExp_Atl_atlThen();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Condition</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IF_EXP__QVTR_QVTR_CONDITION = eINSTANCE.getTC_mapIfExp_Qvtr_qvtrCondition();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Else</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IF_EXP__QVTR_QVTR_ELSE = eINSTANCE.getTC_mapIfExp_Qvtr_qvtrElse();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Then</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IF_EXP__QVTR_QVTR_THEN = eINSTANCE.getTC_mapIfExp_Qvtr_qvtrThen();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapInPatternImpl <em>TC map In Pattern</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapInPatternImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapInPattern()
		 * @generated
		 */
		EClass TC_MAP_IN_PATTERN = eINSTANCE.getTC_mapInPattern();

		/**
		 * The meta object literal for the '<em><b>Atl atl Model</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN__ATL_ATL_MODEL = eINSTANCE.getTC_mapInPattern_Atl_atlModel();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN__ATL_ATL_MODULE = eINSTANCE.getTC_mapInPattern_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Atl atl Pattern</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN__ATL_ATL_PATTERN = eINSTANCE.getTC_mapInPattern_Atl_atlPattern();

		/**
		 * The meta object literal for the '<em><b>Atl atl Rule</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN__ATL_ATL_RULE = eINSTANCE.getTC_mapInPattern_Atl_atlRule();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Domain</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN__QVTR_QVTR_DOMAIN = eINSTANCE.getTC_mapInPattern_Qvtr_qvtrDomain();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Relation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN__QVTR_QVTR_RELATION = eINSTANCE.getTC_mapInPattern_Qvtr_qvtrRelation();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Typed Model</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN__QVTR_QVTR_TYPED_MODEL = eINSTANCE.getTC_mapInPattern_Qvtr_qvtrTypedModel();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_IN_PATTERN__STATUS = eINSTANCE.getTC_mapInPattern_Status();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapInPattern_filterImpl <em>TC map In Pattern filter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapInPattern_filterImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapInPattern_filter()
		 * @generated
		 */
		EClass TC_MAP_IN_PATTERN_FILTER = eINSTANCE.getTC_mapInPattern_filter();

		/**
		 * The meta object literal for the '<em><b>Atl atl Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN_FILTER__ATL_ATL_EXPRESSION = eINSTANCE.getTC_mapInPattern_filter_Atl_atlExpression();

		/**
		 * The meta object literal for the '<em><b>Atl atl Pattern</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN_FILTER__ATL_ATL_PATTERN = eINSTANCE.getTC_mapInPattern_filter_Atl_atlPattern();

		/**
		 * The meta object literal for the '<em><b>Atl atl Rule</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN_FILTER__ATL_ATL_RULE = eINSTANCE.getTC_mapInPattern_filter_Atl_atlRule();

		/**
		 * The meta object literal for the '<em><b>Qvtr p</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN_FILTER__QVTR_P = eINSTANCE.getTC_mapInPattern_filter_Qvtr_p();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Domain</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN_FILTER__QVTR_QVTR_DOMAIN = eINSTANCE.getTC_mapInPattern_filter_Qvtr_qvtrDomain();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN_FILTER__QVTR_QVTR_EXPRESSION = eINSTANCE.getTC_mapInPattern_filter_Qvtr_qvtrExpression();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Relation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN_FILTER__QVTR_QVTR_RELATION = eINSTANCE.getTC_mapInPattern_filter_Qvtr_qvtrRelation();

		/**
		 * The meta object literal for the '<em><b>Qvtr w</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_IN_PATTERN_FILTER__QVTR_W = eINSTANCE.getTC_mapInPattern_filter_Qvtr_w();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapIntegerExpImpl <em>TC map Integer Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapIntegerExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapIntegerExp()
		 * @generated
		 */
		EClass TC_MAP_INTEGER_EXP = eINSTANCE.getTC_mapIntegerExp();

		/**
		 * The meta object literal for the '<em><b>Primitive symbol</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_INTEGER_EXP__PRIMITIVE_SYMBOL = eINSTANCE.getTC_mapIntegerExp_Primitive_symbol();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapMatchedRuleImpl <em>TC map Matched Rule</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapMatchedRuleImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapMatchedRule()
		 * @generated
		 */
		EClass TC_MAP_MATCHED_RULE = eINSTANCE.getTC_mapMatchedRule();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MATCHED_RULE__ATL_ATL_MODULE = eINSTANCE.getTC_mapMatchedRule_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Atl matched Rule</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MATCHED_RULE__ATL_MATCHED_RULE = eINSTANCE.getTC_mapMatchedRule_Atl_matchedRule();

		/**
		 * The meta object literal for the '<em><b>Primitive rule Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_MATCHED_RULE__PRIMITIVE_RULE_NAME = eINSTANCE.getTC_mapMatchedRule_Primitive_ruleName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Relation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MATCHED_RULE__QVTR_QVTR_RELATION = eINSTANCE.getTC_mapMatchedRule_Qvtr_qvtrRelation();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Transformation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MATCHED_RULE__QVTR_QVTR_TRANSFORMATION = eINSTANCE.getTC_mapMatchedRule_Qvtr_qvtrTransformation();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_MATCHED_RULE__STATUS = eINSTANCE.getTC_mapMatchedRule_Status();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapMatchedRule_superImpl <em>TC map Matched Rule super</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapMatchedRule_superImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapMatchedRule_super()
		 * @generated
		 */
		EClass TC_MAP_MATCHED_RULE_SUPER = eINSTANCE.getTC_mapMatchedRule_super();

		/**
		 * The meta object literal for the '<em><b>Atl atl Child Rule</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MATCHED_RULE_SUPER__ATL_ATL_CHILD_RULE = eINSTANCE.getTC_mapMatchedRule_super_Atl_atlChildRule();

		/**
		 * The meta object literal for the '<em><b>Atl atl Super Rule</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MATCHED_RULE_SUPER__ATL_ATL_SUPER_RULE = eINSTANCE.getTC_mapMatchedRule_super_Atl_atlSuperRule();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Overridden Relation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MATCHED_RULE_SUPER__QVTR_QVTR_OVERRIDDEN_RELATION = eINSTANCE.getTC_mapMatchedRule_super_Qvtr_qvtrOverriddenRelation();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Overrides Relation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MATCHED_RULE_SUPER__QVTR_QVTR_OVERRIDES_RELATION = eINSTANCE.getTC_mapMatchedRule_super_Qvtr_qvtrOverridesRelation();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapModuleImpl <em>TC map Module</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapModuleImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapModule()
		 * @generated
		 */
		EClass TC_MAP_MODULE = eINSTANCE.getTC_mapModule();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MODULE__ATL_ATL_MODULE = eINSTANCE.getTC_mapModule_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Primitive tx Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_MODULE__PRIMITIVE_TX_NAME = eINSTANCE.getTC_mapModule_Primitive_txName();

		/**
		 * The meta object literal for the '<em><b>Qvtr 3</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MODULE__QVTR_3 = eINSTANCE.getTC_mapModule_Qvtr__3();

		/**
		 * The meta object literal for the '<em><b>Qvtr 4</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MODULE__QVTR_4 = eINSTANCE.getTC_mapModule_Qvtr__4();

		/**
		 * The meta object literal for the '<em><b>Qvtr 5</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MODULE__QVTR_5 = eINSTANCE.getTC_mapModule_Qvtr__5();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Transformation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_MODULE__QVTR_QVTR_TRANSFORMATION = eINSTANCE.getTC_mapModule_Qvtr_qvtrTransformation();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_MODULE__STATUS = eINSTANCE.getTC_mapModule_Status();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapNavigationOrAttributeCallExpImpl <em>TC map Navigation Or Attribute Call Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapNavigationOrAttributeCallExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapNavigationOrAttributeCallExp()
		 * @generated
		 */
		EClass TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP = eINSTANCE.getTC_mapNavigationOrAttributeCallExp();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapNavigationOrAttributeCallExp_HelperImpl <em>TC map Navigation Or Attribute Call Exp Helper</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapNavigationOrAttributeCallExp_HelperImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapNavigationOrAttributeCallExp_Helper()
		 * @generated
		 */
		EClass TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Helper();

		/**
		 * The meta object literal for the '<em><b>Atl atl Attributes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__ATL_ATL_ATTRIBUTES = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Helper_Atl_atlAttributes();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__ATL_ATL_MODULE = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Helper_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Atl atl Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__ATL_ATL_SOURCE = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Helper_Atl_atlSource();

		/**
		 * The meta object literal for the '<em><b>Primitive property Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__PRIMITIVE_PROPERTY_NAME = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Helper_Primitive_propertyName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Operation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_OPERATION = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Helper_Qvtr_qvtrOperation();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_SOURCE = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Helper_Qvtr_qvtrSource();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Source Argument</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_SOURCE_ARGUMENT = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Helper_Qvtr_qvtrSourceArgument();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr This Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_THIS_VARIABLE = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Helper_Qvtr_qvtrThisVariable();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Transformation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER__QVTR_QVTR_TRANSFORMATION = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Helper_Qvtr_qvtrTransformation();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapNavigationOrAttributeCallExp_PropertyImpl <em>TC map Navigation Or Attribute Call Exp Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapNavigationOrAttributeCallExp_PropertyImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapNavigationOrAttributeCallExp_Property()
		 * @generated
		 */
		EClass TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Property();

		/**
		 * The meta object literal for the '<em><b>Atl atl Attributes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__ATL_ATL_ATTRIBUTES = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Property_Atl_atlAttributes();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__ATL_ATL_MODULE = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Property_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Atl atl Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__ATL_ATL_SOURCE = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Property_Atl_atlSource();

		/**
		 * The meta object literal for the '<em><b>Primitive property Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__PRIMITIVE_PROPERTY_NAME = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Property_Primitive_propertyName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Property</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__QVTR_QVTR_PROPERTY = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Property_Qvtr_qvtrProperty();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY__QVTR_QVTR_SOURCE = eINSTANCE.getTC_mapNavigationOrAttributeCallExp_Property_Qvtr_qvtrSource();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclExpressionImpl <em>TC map Ocl Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclExpressionImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOclExpression()
		 * @generated
		 */
		EClass TC_MAP_OCL_EXPRESSION = eINSTANCE.getTC_mapOclExpression();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclMetamodelImpl <em>TC map Ocl Metamodel</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclMetamodelImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOclMetamodel()
		 * @generated
		 */
		EClass TC_MAP_OCL_METAMODEL = eINSTANCE.getTC_mapOclMetamodel();

		/**
		 * The meta object literal for the '<em><b>Atl ocl Metamodel</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OCL_METAMODEL__ATL_OCL_METAMODEL = eINSTANCE.getTC_mapOclMetamodel_Atl_oclMetamodel();

		/**
		 * The meta object literal for the '<em><b>Primitive tm Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_OCL_METAMODEL__PRIMITIVE_TM_NAME = eINSTANCE.getTC_mapOclMetamodel_Primitive_tmName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Typed Model</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OCL_METAMODEL__QVTR_QVTR_TYPED_MODEL = eINSTANCE.getTC_mapOclMetamodel_Qvtr_qvtrTypedModel();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_OCL_METAMODEL__STATUS = eINSTANCE.getTC_mapOclMetamodel_Status();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclModel_INImpl <em>TC map Ocl Model IN</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclModel_INImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOclModel_IN()
		 * @generated
		 */
		EClass TC_MAP_OCL_MODEL_IN = eINSTANCE.getTC_mapOclModel_IN();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OCL_MODEL_IN__ATL_ATL_MODULE = eINSTANCE.getTC_mapOclModel_IN_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Atl ocl Metamodel</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OCL_MODEL_IN__ATL_OCL_METAMODEL = eINSTANCE.getTC_mapOclModel_IN_Atl_oclMetamodel();

		/**
		 * The meta object literal for the '<em><b>Atl ocl Model</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OCL_MODEL_IN__ATL_OCL_MODEL = eINSTANCE.getTC_mapOclModel_IN_Atl_oclModel();

		/**
		 * The meta object literal for the '<em><b>Primitive tm Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_OCL_MODEL_IN__PRIMITIVE_TM_NAME = eINSTANCE.getTC_mapOclModel_IN_Primitive_tmName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Transformation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OCL_MODEL_IN__QVTR_QVTR_TRANSFORMATION = eINSTANCE.getTC_mapOclModel_IN_Qvtr_qvtrTransformation();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Typed Model</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OCL_MODEL_IN__QVTR_QVTR_TYPED_MODEL = eINSTANCE.getTC_mapOclModel_IN_Qvtr_qvtrTypedModel();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclModel_OUTImpl <em>TC map Ocl Model OUT</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOclModel_OUTImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOclModel_OUT()
		 * @generated
		 */
		EClass TC_MAP_OCL_MODEL_OUT = eINSTANCE.getTC_mapOclModel_OUT();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OCL_MODEL_OUT__ATL_ATL_MODULE = eINSTANCE.getTC_mapOclModel_OUT_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Atl ocl Metamodel</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OCL_MODEL_OUT__ATL_OCL_METAMODEL = eINSTANCE.getTC_mapOclModel_OUT_Atl_oclMetamodel();

		/**
		 * The meta object literal for the '<em><b>Atl ocl Model</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OCL_MODEL_OUT__ATL_OCL_MODEL = eINSTANCE.getTC_mapOclModel_OUT_Atl_oclModel();

		/**
		 * The meta object literal for the '<em><b>Primitive tm Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_OCL_MODEL_OUT__PRIMITIVE_TM_NAME = eINSTANCE.getTC_mapOclModel_OUT_Primitive_tmName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Transformation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OCL_MODEL_OUT__QVTR_QVTR_TRANSFORMATION = eINSTANCE.getTC_mapOclModel_OUT_Qvtr_qvtrTransformation();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Typed Model</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OCL_MODEL_OUT__QVTR_QVTR_TYPED_MODEL = eINSTANCE.getTC_mapOclModel_OUT_Qvtr_qvtrTypedModel();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExpImpl <em>TC map Operation Call Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOperationCallExp()
		 * @generated
		 */
		EClass TC_MAP_OPERATION_CALL_EXP = eINSTANCE.getTC_mapOperationCallExp();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExp_HelperImpl <em>TC map Operation Call Exp Helper</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExp_HelperImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOperationCallExp_Helper()
		 * @generated
		 */
		EClass TC_MAP_OPERATION_CALL_EXP_HELPER = eINSTANCE.getTC_mapOperationCallExp_Helper();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_HELPER__ATL_ATL_MODULE = eINSTANCE.getTC_mapOperationCallExp_Helper_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Atl atl Operations</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_HELPER__ATL_ATL_OPERATIONS = eINSTANCE.getTC_mapOperationCallExp_Helper_Atl_atlOperations();

		/**
		 * The meta object literal for the '<em><b>Atl atl Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_HELPER__ATL_ATL_SOURCE = eINSTANCE.getTC_mapOperationCallExp_Helper_Atl_atlSource();

		/**
		 * The meta object literal for the '<em><b>Primitive operation Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_OPERATION_CALL_EXP_HELPER__PRIMITIVE_OPERATION_NAME = eINSTANCE.getTC_mapOperationCallExp_Helper_Primitive_operationName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Operation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_OPERATION = eINSTANCE.getTC_mapOperationCallExp_Helper_Qvtr_qvtrOperation();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_SOURCE = eINSTANCE.getTC_mapOperationCallExp_Helper_Qvtr_qvtrSource();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Source Argument</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_SOURCE_ARGUMENT = eINSTANCE.getTC_mapOperationCallExp_Helper_Qvtr_qvtrSourceArgument();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr This Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_THIS_VARIABLE = eINSTANCE.getTC_mapOperationCallExp_Helper_Qvtr_qvtrThisVariable();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Transformation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_HELPER__QVTR_QVTR_TRANSFORMATION = eINSTANCE.getTC_mapOperationCallExp_Helper_Qvtr_qvtrTransformation();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExp_OperationImpl <em>TC map Operation Call Exp Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExp_OperationImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOperationCallExp_Operation()
		 * @generated
		 */
		EClass TC_MAP_OPERATION_CALL_EXP_OPERATION = eINSTANCE.getTC_mapOperationCallExp_Operation();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_OPERATION__ATL_ATL_MODULE = eINSTANCE.getTC_mapOperationCallExp_Operation_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Atl atl Operations</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_OPERATION__ATL_ATL_OPERATIONS = eINSTANCE.getTC_mapOperationCallExp_Operation_Atl_atlOperations();

		/**
		 * The meta object literal for the '<em><b>Atl atl Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_OPERATION__ATL_ATL_SOURCE = eINSTANCE.getTC_mapOperationCallExp_Operation_Atl_atlSource();

		/**
		 * The meta object literal for the '<em><b>Primitive operation Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_OPERATION_CALL_EXP_OPERATION__PRIMITIVE_OPERATION_NAME = eINSTANCE.getTC_mapOperationCallExp_Operation_Primitive_operationName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Operation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_OPERATION__QVTR_QVTR_OPERATION = eINSTANCE.getTC_mapOperationCallExp_Operation_Qvtr_qvtrOperation();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_OPERATION__QVTR_QVTR_SOURCE = eINSTANCE.getTC_mapOperationCallExp_Operation_Qvtr_qvtrSource();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExp_argumentImpl <em>TC map Operation Call Exp argument</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperationCallExp_argumentImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOperationCallExp_argument()
		 * @generated
		 */
		EClass TC_MAP_OPERATION_CALL_EXP_ARGUMENT = eINSTANCE.getTC_mapOperationCallExp_argument();

		/**
		 * The meta object literal for the '<em><b>Atl atl Argument</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_ARGUMENT__ATL_ATL_ARGUMENT = eINSTANCE.getTC_mapOperationCallExp_argument_Atl_atlArgument();

		/**
		 * The meta object literal for the '<em><b>Atl atl Parent</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_ARGUMENT__ATL_ATL_PARENT = eINSTANCE.getTC_mapOperationCallExp_argument_Atl_atlParent();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Argument</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_ARGUMENT__QVTR_QVTR_ARGUMENT = eINSTANCE.getTC_mapOperationCallExp_argument_Qvtr_qvtrArgument();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Parent</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATION_CALL_EXP_ARGUMENT__QVTR_QVTR_PARENT = eINSTANCE.getTC_mapOperationCallExp_argument_Qvtr_qvtrParent();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperatorCallExpImpl <em>TC map Operator Call Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOperatorCallExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOperatorCallExp()
		 * @generated
		 */
		EClass TC_MAP_OPERATOR_CALL_EXP = eINSTANCE.getTC_mapOperatorCallExp();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATOR_CALL_EXP__ATL_ATL_MODULE = eINSTANCE.getTC_mapOperatorCallExp_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Atl atl Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATOR_CALL_EXP__ATL_ATL_SOURCE = eINSTANCE.getTC_mapOperatorCallExp_Atl_atlSource();

		/**
		 * The meta object literal for the '<em><b>Primitive operation Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_OPERATOR_CALL_EXP__PRIMITIVE_OPERATION_NAME = eINSTANCE.getTC_mapOperatorCallExp_Primitive_operationName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Operation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATOR_CALL_EXP__QVTR_QVTR_OPERATION = eINSTANCE.getTC_mapOperatorCallExp_Qvtr_qvtrOperation();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATOR_CALL_EXP__QVTR_QVTR_SOURCE = eINSTANCE.getTC_mapOperatorCallExp_Qvtr_qvtrSource();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Transformation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OPERATOR_CALL_EXP__QVTR_QVTR_TRANSFORMATION = eINSTANCE.getTC_mapOperatorCallExp_Qvtr_qvtrTransformation();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOutPatternImpl <em>TC map Out Pattern</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapOutPatternImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapOutPattern()
		 * @generated
		 */
		EClass TC_MAP_OUT_PATTERN = eINSTANCE.getTC_mapOutPattern();

		/**
		 * The meta object literal for the '<em><b>Atl atl Module</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OUT_PATTERN__ATL_ATL_MODULE = eINSTANCE.getTC_mapOutPattern_Atl_atlModule();

		/**
		 * The meta object literal for the '<em><b>Atl atl Pattern</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OUT_PATTERN__ATL_ATL_PATTERN = eINSTANCE.getTC_mapOutPattern_Atl_atlPattern();

		/**
		 * The meta object literal for the '<em><b>Atl atl Rule</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OUT_PATTERN__ATL_ATL_RULE = eINSTANCE.getTC_mapOutPattern_Atl_atlRule();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Domain</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OUT_PATTERN__QVTR_QVTR_DOMAIN = eINSTANCE.getTC_mapOutPattern_Qvtr_qvtrDomain();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Relation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OUT_PATTERN__QVTR_QVTR_RELATION = eINSTANCE.getTC_mapOutPattern_Qvtr_qvtrRelation();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Typed Model</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_OUT_PATTERN__QVTR_QVTR_TYPED_MODEL = eINSTANCE.getTC_mapOutPattern_Qvtr_qvtrTypedModel();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_OUT_PATTERN__STATUS = eINSTANCE.getTC_mapOutPattern_Status();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapSimpleInPatternElementImpl <em>TC map Simple In Pattern Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapSimpleInPatternElementImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapSimpleInPatternElement()
		 * @generated
		 */
		EClass TC_MAP_SIMPLE_IN_PATTERN_ELEMENT = eINSTANCE.getTC_mapSimpleInPatternElement();

		/**
		 * The meta object literal for the '<em><b>Atl atl Element</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__ATL_ATL_ELEMENT = eINSTANCE.getTC_mapSimpleInPatternElement_Atl_atlElement();

		/**
		 * The meta object literal for the '<em><b>Atl atl Pattern</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__ATL_ATL_PATTERN = eINSTANCE.getTC_mapSimpleInPatternElement_Atl_atlPattern();

		/**
		 * The meta object literal for the '<em><b>Atl atl Rule</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__ATL_ATL_RULE = eINSTANCE.getTC_mapSimpleInPatternElement_Atl_atlRule();

		/**
		 * The meta object literal for the '<em><b>Invocation map Variable</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__INVOCATION_MAP_VARIABLE = eINSTANCE.getTC_mapSimpleInPatternElement_Invocation_mapVariable();

		/**
		 * The meta object literal for the '<em><b>Primitive element Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__PRIMITIVE_ELEMENT_NAME = eINSTANCE.getTC_mapSimpleInPatternElement_Primitive_elementName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Domain</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__QVTR_QVTR_DOMAIN = eINSTANCE.getTC_mapSimpleInPatternElement_Qvtr_qvtrDomain();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Domain1</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__QVTR_QVTR_DOMAIN1 = eINSTANCE.getTC_mapSimpleInPatternElement_Qvtr_qvtrDomain1();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Pattern</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__QVTR_QVTR_PATTERN = eINSTANCE.getTC_mapSimpleInPatternElement_Qvtr_qvtrPattern();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Relation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__QVTR_QVTR_RELATION = eINSTANCE.getTC_mapSimpleInPatternElement_Qvtr_qvtrRelation();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Template</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__QVTR_QVTR_TEMPLATE = eINSTANCE.getTC_mapSimpleInPatternElement_Qvtr_qvtrTemplate();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_IN_PATTERN_ELEMENT__QVTR_QVTR_VARIABLE = eINSTANCE.getTC_mapSimpleInPatternElement_Qvtr_qvtrVariable();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapSimpleOutPatternElementImpl <em>TC map Simple Out Pattern Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapSimpleOutPatternElementImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapSimpleOutPatternElement()
		 * @generated
		 */
		EClass TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT = eINSTANCE.getTC_mapSimpleOutPatternElement();

		/**
		 * The meta object literal for the '<em><b>Atl atl Element</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__ATL_ATL_ELEMENT = eINSTANCE.getTC_mapSimpleOutPatternElement_Atl_atlElement();

		/**
		 * The meta object literal for the '<em><b>Atl atl Pattern</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__ATL_ATL_PATTERN = eINSTANCE.getTC_mapSimpleOutPatternElement_Atl_atlPattern();

		/**
		 * The meta object literal for the '<em><b>Atl atl Rule</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__ATL_ATL_RULE = eINSTANCE.getTC_mapSimpleOutPatternElement_Atl_atlRule();

		/**
		 * The meta object literal for the '<em><b>Invocation map Variable</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__INVOCATION_MAP_VARIABLE = eINSTANCE.getTC_mapSimpleOutPatternElement_Invocation_mapVariable();

		/**
		 * The meta object literal for the '<em><b>Primitive element Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__PRIMITIVE_ELEMENT_NAME = eINSTANCE.getTC_mapSimpleOutPatternElement_Primitive_elementName();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Domain</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__QVTR_QVTR_DOMAIN = eINSTANCE.getTC_mapSimpleOutPatternElement_Qvtr_qvtrDomain();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Domain1</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__QVTR_QVTR_DOMAIN1 = eINSTANCE.getTC_mapSimpleOutPatternElement_Qvtr_qvtrDomain1();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Pattern</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__QVTR_QVTR_PATTERN = eINSTANCE.getTC_mapSimpleOutPatternElement_Qvtr_qvtrPattern();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Relation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__QVTR_QVTR_RELATION = eINSTANCE.getTC_mapSimpleOutPatternElement_Qvtr_qvtrRelation();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Template</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__QVTR_QVTR_TEMPLATE = eINSTANCE.getTC_mapSimpleOutPatternElement_Qvtr_qvtrTemplate();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__QVTR_QVTR_VARIABLE = eINSTANCE.getTC_mapSimpleOutPatternElement_Qvtr_qvtrVariable();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_SIMPLE_OUT_PATTERN_ELEMENT__STATUS = eINSTANCE.getTC_mapSimpleOutPatternElement_Status();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapStringExpImpl <em>TC map String Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapStringExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapStringExp()
		 * @generated
		 */
		EClass TC_MAP_STRING_EXP = eINSTANCE.getTC_mapStringExp();

		/**
		 * The meta object literal for the '<em><b>Primitive symbol</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_STRING_EXP__PRIMITIVE_SYMBOL = eINSTANCE.getTC_mapStringExp_Primitive_symbol();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableImpl <em>TC map Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapVariable()
		 * @generated
		 */
		EClass TC_MAP_VARIABLE = eINSTANCE.getTC_mapVariable();

		/**
		 * The meta object literal for the '<em><b>Atl atl Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE__ATL_ATL_VARIABLE = eINSTANCE.getTC_mapVariable_Atl_atlVariable();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE__QVTR_QVTR_VARIABLE = eINSTANCE.getTC_mapVariable_Qvtr_qvtrVariable();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExpImpl <em>TC map Variable Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapVariableExp()
		 * @generated
		 */
		EClass TC_MAP_VARIABLE_EXP = eINSTANCE.getTC_mapVariableExp();

		/**
		 * The meta object literal for the '<em><b>Atl atl Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP__ATL_ATL_VARIABLE = eINSTANCE.getTC_mapVariableExp_Atl_atlVariable();

		/**
		 * The meta object literal for the '<em><b>Invocation map Variable Exp referred Variable</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP__INVOCATION_MAP_VARIABLE_EXP_REFERRED_VARIABLE = eINSTANCE.getTC_mapVariableExp_Invocation_mapVariableExp_referredVariable();

		/**
		 * The meta object literal for the '<em><b>Primitive var Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TC_MAP_VARIABLE_EXP__PRIMITIVE_VAR_NAME = eINSTANCE.getTC_mapVariableExp_Primitive_varName();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExp_referredVariableImpl <em>TC map Variable Exp referred Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExp_referredVariableImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapVariableExp_referredVariable()
		 * @generated
		 */
		EClass TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE = eINSTANCE.getTC_mapVariableExp_referredVariable();

		/**
		 * The meta object literal for the '<em><b>Atl atl Expression1</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE__ATL_ATL_EXPRESSION1 = eINSTANCE.getTC_mapVariableExp_referredVariable_Atl_atlExpression1();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Expression1</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE__QVTR_QVTR_EXPRESSION1 = eINSTANCE.getTC_mapVariableExp_referredVariable_Qvtr_qvtrExpression1();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExp_referredVariable_HelperImpl <em>TC map Variable Exp referred Variable Helper</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExp_referredVariable_HelperImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapVariableExp_referredVariable_Helper()
		 * @generated
		 */
		EClass TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER = eINSTANCE.getTC_mapVariableExp_referredVariable_Helper();

		/**
		 * The meta object literal for the '<em><b>Atl atl Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__ATL_ATL_EXPRESSION = eINSTANCE.getTC_mapVariableExp_referredVariable_Helper_Atl_atlExpression();

		/**
		 * The meta object literal for the '<em><b>Atl atl Helper</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__ATL_ATL_HELPER = eINSTANCE.getTC_mapVariableExp_referredVariable_Helper_Atl_atlHelper();

		/**
		 * The meta object literal for the '<em><b>Atl atl Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__ATL_ATL_VARIABLE = eINSTANCE.getTC_mapVariableExp_referredVariable_Helper_Atl_atlVariable();

		/**
		 * The meta object literal for the '<em><b>Invocation map Variable</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__INVOCATION_MAP_VARIABLE = eINSTANCE.getTC_mapVariableExp_referredVariable_Helper_Invocation_mapVariable();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__QVTR_QVTR_EXPRESSION = eINSTANCE.getTC_mapVariableExp_referredVariable_Helper_Qvtr_qvtrExpression();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER__QVTR_QVTR_VARIABLE = eINSTANCE.getTC_mapVariableExp_referredVariable_Helper_Qvtr_qvtrVariable();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExp_referredVariable_VariableDeclarationImpl <em>TC map Variable Exp referred Variable Variable Declaration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TC_mapVariableExp_referredVariable_VariableDeclarationImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTC_mapVariableExp_referredVariable_VariableDeclaration()
		 * @generated
		 */
		EClass TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION = eINSTANCE.getTC_mapVariableExp_referredVariable_VariableDeclaration();

		/**
		 * The meta object literal for the '<em><b>Atl atl Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__ATL_ATL_EXPRESSION = eINSTANCE.getTC_mapVariableExp_referredVariable_VariableDeclaration_Atl_atlExpression();

		/**
		 * The meta object literal for the '<em><b>Atl atl Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__ATL_ATL_VARIABLE = eINSTANCE.getTC_mapVariableExp_referredVariable_VariableDeclaration_Atl_atlVariable();

		/**
		 * The meta object literal for the '<em><b>Invocation map Variable</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__INVOCATION_MAP_VARIABLE = eINSTANCE.getTC_mapVariableExp_referredVariable_VariableDeclaration_Invocation_mapVariable();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__QVTR_QVTR_EXPRESSION = eINSTANCE.getTC_mapVariableExp_referredVariable_VariableDeclaration_Qvtr_qvtrExpression();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION__QVTR_QVTR_VARIABLE = eINSTANCE.getTC_mapVariableExp_referredVariable_VariableDeclaration_Qvtr_qvtrVariable();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapBooleanExpImpl <em>TI map Boolean Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapBooleanExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapBooleanExp()
		 * @generated
		 */
		EClass TI_MAP_BOOLEAN_EXP = eINSTANCE.getTI_mapBooleanExp();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapHelperImpl <em>TI map Helper</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapHelperImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapHelper()
		 * @generated
		 */
		EClass TI_MAP_HELPER = eINSTANCE.getTI_mapHelper();

		/**
		 * The meta object literal for the '<em><b>Atl atl Helper</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TI_MAP_HELPER__ATL_ATL_HELPER = eINSTANCE.getTI_mapHelper_Atl_atlHelper();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Function</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TI_MAP_HELPER__QVTR_QVTR_FUNCTION = eINSTANCE.getTI_mapHelper_Qvtr_qvtrFunction();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TI_MAP_HELPER__STATUS = eINSTANCE.getTI_mapHelper_Status();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapHelper_AttributeImpl <em>TI map Helper Attribute</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapHelper_AttributeImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapHelper_Attribute()
		 * @generated
		 */
		EClass TI_MAP_HELPER_ATTRIBUTE = eINSTANCE.getTI_mapHelper_Attribute();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapHelper_OperationImpl <em>TI map Helper Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapHelper_OperationImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapHelper_Operation()
		 * @generated
		 */
		EClass TI_MAP_HELPER_OPERATION = eINSTANCE.getTI_mapHelper_Operation();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapIfExpImpl <em>TI map If Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapIfExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapIfExp()
		 * @generated
		 */
		EClass TI_MAP_IF_EXP = eINSTANCE.getTI_mapIfExp();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapIntegerExpImpl <em>TI map Integer Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapIntegerExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapIntegerExp()
		 * @generated
		 */
		EClass TI_MAP_INTEGER_EXP = eINSTANCE.getTI_mapIntegerExp();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapNavigationOrAttributeCallExpImpl <em>TI map Navigation Or Attribute Call Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapNavigationOrAttributeCallExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapNavigationOrAttributeCallExp()
		 * @generated
		 */
		EClass TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP = eINSTANCE.getTI_mapNavigationOrAttributeCallExp();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapNavigationOrAttributeCallExp_HelperImpl <em>TI map Navigation Or Attribute Call Exp Helper</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapNavigationOrAttributeCallExp_HelperImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapNavigationOrAttributeCallExp_Helper()
		 * @generated
		 */
		EClass TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_HELPER = eINSTANCE.getTI_mapNavigationOrAttributeCallExp_Helper();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapNavigationOrAttributeCallExp_PropertyImpl <em>TI map Navigation Or Attribute Call Exp Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapNavigationOrAttributeCallExp_PropertyImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapNavigationOrAttributeCallExp_Property()
		 * @generated
		 */
		EClass TI_MAP_NAVIGATION_OR_ATTRIBUTE_CALL_EXP_PROPERTY = eINSTANCE.getTI_mapNavigationOrAttributeCallExp_Property();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOclExpressionImpl <em>TI map Ocl Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOclExpressionImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapOclExpression()
		 * @generated
		 */
		EClass TI_MAP_OCL_EXPRESSION = eINSTANCE.getTI_mapOclExpression();

		/**
		 * The meta object literal for the '<em><b>Atl atl Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TI_MAP_OCL_EXPRESSION__ATL_ATL_EXPRESSION = eINSTANCE.getTI_mapOclExpression_Atl_atlExpression();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TI_MAP_OCL_EXPRESSION__QVTR_QVTR_EXPRESSION = eINSTANCE.getTI_mapOclExpression_Qvtr_qvtrExpression();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TI_MAP_OCL_EXPRESSION__STATUS = eINSTANCE.getTI_mapOclExpression_Status();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperationCallExpImpl <em>TI map Operation Call Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperationCallExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapOperationCallExp()
		 * @generated
		 */
		EClass TI_MAP_OPERATION_CALL_EXP = eINSTANCE.getTI_mapOperationCallExp();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperationCallExp_HelperImpl <em>TI map Operation Call Exp Helper</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperationCallExp_HelperImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapOperationCallExp_Helper()
		 * @generated
		 */
		EClass TI_MAP_OPERATION_CALL_EXP_HELPER = eINSTANCE.getTI_mapOperationCallExp_Helper();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperationCallExp_OperationImpl <em>TI map Operation Call Exp Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperationCallExp_OperationImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapOperationCallExp_Operation()
		 * @generated
		 */
		EClass TI_MAP_OPERATION_CALL_EXP_OPERATION = eINSTANCE.getTI_mapOperationCallExp_Operation();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperatorCallExpImpl <em>TI map Operator Call Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapOperatorCallExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapOperatorCallExp()
		 * @generated
		 */
		EClass TI_MAP_OPERATOR_CALL_EXP = eINSTANCE.getTI_mapOperatorCallExp();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapStringExpImpl <em>TI map String Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapStringExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapStringExp()
		 * @generated
		 */
		EClass TI_MAP_STRING_EXP = eINSTANCE.getTI_mapStringExp();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExpImpl <em>TI map Variable Exp</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExpImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapVariableExp()
		 * @generated
		 */
		EClass TI_MAP_VARIABLE_EXP = eINSTANCE.getTI_mapVariableExp();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExp_referredVariableImpl <em>TI map Variable Exp referred Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExp_referredVariableImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapVariableExp_referredVariable()
		 * @generated
		 */
		EClass TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE = eINSTANCE.getTI_mapVariableExp_referredVariable();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__STATUS = eINSTANCE.getTI_mapVariableExp_referredVariable_Status();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExp_referredVariable_HelperImpl <em>TI map Variable Exp referred Variable Helper</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExp_referredVariable_HelperImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapVariableExp_referredVariable_Helper()
		 * @generated
		 */
		EClass TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER = eINSTANCE.getTI_mapVariableExp_referredVariable_Helper();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExp_referredVariable_VariableDeclarationImpl <em>TI map Variable Exp referred Variable Variable Declaration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.TI_mapVariableExp_referredVariable_VariableDeclarationImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getTI_mapVariableExp_referredVariable_VariableDeclaration()
		 * @generated
		 */
		EClass TI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION = eINSTANCE.getTI_mapVariableExp_referredVariable_VariableDeclaration();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WC_mapVariableExp_referredVariableImpl <em>WC map Variable Exp referred Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WC_mapVariableExp_referredVariableImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getWC_mapVariableExp_referredVariable()
		 * @generated
		 */
		EClass WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE = eINSTANCE.getWC_mapVariableExp_referredVariable();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WC_mapVariableExp_referredVariable_HelperImpl <em>WC map Variable Exp referred Variable Helper</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WC_mapVariableExp_referredVariable_HelperImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getWC_mapVariableExp_referredVariable_Helper()
		 * @generated
		 */
		EClass WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER = eINSTANCE.getWC_mapVariableExp_referredVariable_Helper();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WC_mapVariableExp_referredVariable_VariableDeclarationImpl <em>WC map Variable Exp referred Variable Variable Declaration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WC_mapVariableExp_referredVariable_VariableDeclarationImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getWC_mapVariableExp_referredVariable_VariableDeclaration()
		 * @generated
		 */
		EClass WC_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION = eINSTANCE.getWC_mapVariableExp_referredVariable_VariableDeclaration();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WI_mapVariableExp_referredVariableImpl <em>WI map Variable Exp referred Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WI_mapVariableExp_referredVariableImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getWI_mapVariableExp_referredVariable()
		 * @generated
		 */
		EClass WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE = eINSTANCE.getWI_mapVariableExp_referredVariable();

		/**
		 * The meta object literal for the '<em><b>Atl atl Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__ATL_ATL_EXPRESSION = eINSTANCE.getWI_mapVariableExp_referredVariable_Atl_atlExpression();

		/**
		 * The meta object literal for the '<em><b>Qvtr qvtr Expression</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__QVTR_QVTR_EXPRESSION = eINSTANCE.getWI_mapVariableExp_referredVariable_Qvtr_qvtrExpression();

		/**
		 * The meta object literal for the '<em><b>Result</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE__RESULT = eINSTANCE.getWI_mapVariableExp_referredVariable_Result();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WI_mapVariableExp_referredVariable_HelperImpl <em>WI map Variable Exp referred Variable Helper</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WI_mapVariableExp_referredVariable_HelperImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getWI_mapVariableExp_referredVariable_Helper()
		 * @generated
		 */
		EClass WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_HELPER = eINSTANCE.getWI_mapVariableExp_referredVariable_Helper();

		/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WI_mapVariableExp_referredVariable_VariableDeclarationImpl <em>WI map Variable Exp referred Variable Variable Declaration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.WI_mapVariableExp_referredVariable_VariableDeclarationImpl
		 * @see org.eclipse.qvtd.atl.atl2qvtr.trace_ATL2QVTr.impl.trace_ATL2QVTrPackageImpl#getWI_mapVariableExp_referredVariable_VariableDeclaration()
		 * @generated
		 */
		EClass WI_MAP_VARIABLE_EXP_REFERRED_VARIABLE_VARIABLE_DECLARATION = eINSTANCE.getWI_mapVariableExp_referredVariable_VariableDeclaration();

	}

} //trace_ATL2QVTrPackage
