/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtcore.tests;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.xtext.base.services.BaseLinkingService;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.QVTcCompilerChain;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.Splitter;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtschedule.impl.RuleRegionImpl;
import org.eclipse.qvtd.xtext.qvtbase.tests.AbstractTestQVT;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.qvtd.xtext.qvtcore.tests.Families2PersonsNormalizer;
import org.eclipse.qvtd.xtext.qvtcore.tests.Forward2ReverseNormalizer;
import org.eclipse.qvtd.xtext.qvtcore.tests.HSV2HSLNormalizer;
import org.eclipse.qvtd.xtext.qvtcore.tests.SimpleRDBMSNormalizer;
import org.eclipse.qvtd.xtext.qvtcore.tests.Upper2LowerNormalizer;
import org.eclipse.qvtd.xtext.qvtcore.tests.families2persons.Families.FamiliesPackage;
import org.eclipse.qvtd.xtext.qvtcore.tests.families2persons.Families2Persons.Families2PersonsPackage;
import org.eclipse.qvtd.xtext.qvtcore.tests.families2persons.Persons.PersonsPackage;
import org.eclipse.qvtd.xtext.qvtcore.tests.hsv2hsl.HSLTree.HSLTreePackage;
import org.eclipse.qvtd.xtext.qvtcore.tests.hsv2hsl.HSV2HSL.HSV2HSLPackage;
import org.eclipse.qvtd.xtext.qvtcore.tests.hsv2hsl.HSVTree.HSVTreePackage;
import org.eclipse.qvtd.xtext.qvtcore.tests.list2list.doublylinkedlist.DoublylinkedlistPackage;
import org.eclipse.qvtd.xtext.qvtcore.tests.list2list.list2list.List2listPackage;
import org.eclipse.qvtd.xtext.qvtcore.tests.uml2rdbms.simplerdbms.SimplerdbmsPackage;
import org.eclipse.qvtd.xtext.qvtcore.tests.uml2rdbms.simpleuml.SimpleumlPackage;
import org.eclipse.qvtd.xtext.qvtcore.tests.uml2rdbms.simpleuml2rdbms.Simpleuml2rdbmsPackage;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class QVTcCompilerTests
extends LoadTestCase {
    private static boolean NO_MERGES = true;

    protected @NonNull MyQVT createQVT(@NonNull String resultPrefix, @NonNull URI txURI) throws Exception {
        ProjectManager testProjectManager = this.getTestProjectManager();
        URI intermediateFileNamePrefixURI = this.getTestURI(resultPrefix);
        URI srcFileURI = this.getTestFileURI("test-src/");
        URI binFileURI = this.getTestFileURI("test-bin/");
        return new MyQVT(testProjectManager, this.getTestProject().getName(), this.getTestBundleURI(), txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI);
    }

    @Before
    public void setUp() throws Exception {
        BaseLinkingService.DEBUG_RETRY.setState(true);
        QVTm2QVTs.DEBUG_GRAPHS.setState(true);
        super.setUp();
        OCLstdlib.install();
        XtextCompilerUtil.doQVTcoreSetup();
        XtextCompilerUtil.doQVTimperativeSetup();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testQVTcCompiler_Families2Persons() throws Exception {
        MyQVT myQVT = this.createQVT("Families2Persons", this.getModelsURI("families2persons/Families2Persons.qvtc"));
        myQVT.loadEcoreFile(this.getModelsURI("families2persons/Families.ecore"), FamiliesPackage.eINSTANCE);
        myQVT.loadEcoreFile(this.getModelsURI("families2persons/Families2Persons.ecore"), Families2PersonsPackage.eINSTANCE);
        myQVT.loadEcoreFile(this.getModelsURI("families2persons/Persons.ecore"), PersonsPackage.eINSTANCE);
        try {
            ImperativeTransformation asTransformation = myQVT.compileTransformation("person");
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("family", this.getModelsURI("families2persons/samples/Families.xmi"));
            myQVT.createModel("middle", this.getTestURI("Families2Persons_trace.xmi"));
            myQVT.createModel("person", this.getTestURI("Persons_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("person", this.getTestURI("Persons_Interpreted.xmi"), this.getModelsURI("families2persons/samples/Persons_expected.xmi"), Families2PersonsNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Families");
            EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Families2Persons");
            EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Persons");
        }
    }

    @Test
    public void testQVTcCompiler_Families2Persons_CG() throws Exception {
        MyQVT myQVT = this.createQVT("Families2Persons", this.getModelsURI("families2persons/Families2Persons.qvtc"));
        try {
            Class txClass = myQVT.buildTransformation_486938("person", false, new String[]{"Families2Persons.genmodel"});
            myQVT.assertRegionCount(RuleRegionImpl.class, 2);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.loadInput("family", this.getModelsURI("families2persons/samples/Families.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("person", this.getTestURI("Persons_CG.xmi"), this.getModelsURI("families2persons/samples/Persons_expected.xmi"), Families2PersonsNormalizer.INSTANCE);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.loadInput("family", this.getModelsURI("families2persons/samples/FamiliesBig.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("person", this.getTestURI("PersonsBig_CG.xmi"), this.getModelsURI("families2persons/samples/PersonsBig_expected.xmi"), Families2PersonsNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_Forward2Reverse() throws Exception {
        MyQVT myQVT = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.qvtc"));
        myQVT.loadEcoreFile(this.getModelsURI("forward2reverse/DoublyLinkedList.ecore"), DoublylinkedlistPackage.eINSTANCE);
        myQVT.loadEcoreFile(this.getModelsURI("forward2reverse/List2List.ecore"), List2listPackage.eINSTANCE);
        try {
            ImperativeTransformation asTransformation = myQVT.compileTransformation("reverse");
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("forward", this.getModelsURI("forward2reverse/samples/EmptyList.xmi"));
            myQVT.createModel("middle", this.getTestURI("EmptyList_trace.xmi"));
            myQVT.createModel("reverse", this.getTestURI("EmptyList_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("reverse", this.getTestURI("EmptyList_Interpreted.xmi"), this.getModelsURI("forward2reverse/samples/EmptyList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("forward", this.getModelsURI("forward2reverse/samples/OneElementList.xmi"));
            myQVT.createModel("middle", this.getTestURI("OneElementList_trace.xmi"));
            myQVT.createModel("reverse", this.getTestURI("OneElementList_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("reverse", this.getTestURI("OneElementList_Interpreted.xmi"), this.getModelsURI("forward2reverse/samples/OneElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("forward", this.getModelsURI("forward2reverse/samples/TwoElementList.xmi"));
            myQVT.createModel("middle", this.getTestURI("TwoElementList_trace.xmi"));
            myQVT.createModel("reverse", this.getTestURI("TwoElementList_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("reverse", this.getTestURI("TwoElementList_Interpreted.xmi"), this.getModelsURI("forward2reverse/samples/TwoElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("forward", this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
            myQVT.createModel("middle", this.getTestURI("ThreeElementList_trace.xmi"));
            myQVT.createModel("reverse", this.getTestURI("ThreeElementList_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("reverse", this.getTestURI("ThreeElementList_Interpreted.xmi"), this.getModelsURI("forward2reverse/samples/ThreeElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/forward2reverse/1.0/DoublyLinkList");
            EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/forward2reverse/1.0/List2List");
        }
    }

    @Test
    public void testQVTcCompiler_Forward2Reverse_CG() throws Exception {
        MyQVT myQVT = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.qvtc"));
        try {
            Class txClassReverse = myQVT.buildTransformation("forward", false, new String[]{"List2List.genmodel"});
            myQVT.assertRegionCount(RuleRegionImpl.class, 0);
            myQVT.createGeneratedExecutor(txClassReverse);
            myQVT.loadInput("reverse", this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("forward", this.getTestURI("ThreeElementList_Reverse_CG.xmi"), this.getModelsURI("forward2reverse/samples/ThreeElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            Class txClass = myQVT.buildTransformation("reverse", false, new String[]{"List2List.genmodel"});
            myQVT.createGeneratedExecutor(txClass);
            myQVT.loadInput("forward", this.getModelsURI("forward2reverse/samples/EmptyList.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("reverse", this.getTestURI("EmptyList_CG.xmi"), this.getModelsURI("forward2reverse/samples/EmptyList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.loadInput("forward", this.getModelsURI("forward2reverse/samples/OneElementList.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("reverse", this.getTestURI("OneElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/OneElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.loadInput("forward", this.getModelsURI("forward2reverse/samples/TwoElementList.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("reverse", this.getTestURI("TwoElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/TwoElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.loadInput("forward", this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("reverse", this.getTestURI("ThreeElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/ThreeElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_HSVToHSL() throws Exception {
        MyQVT myQVT = this.createQVT("HSV2HSL", this.getModelsURI("hsv2hsl/HSV2HSL.qvtc"));
        myQVT.loadEcoreFile(this.getModelsURI("hsv2hsl/HSV2HSL.ecore"), HSV2HSLPackage.eINSTANCE);
        myQVT.loadEcoreFile(this.getModelsURI("hsv2hsl/HSVTree.ecore"), HSVTreePackage.eINSTANCE);
        myQVT.loadEcoreFile(this.getModelsURI("hsv2hsl/HSLTree.ecore"), HSLTreePackage.eINSTANCE);
        try {
            ImperativeTransformation asTransformation = myQVT.compileTransformation("hsl");
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("hsv", this.getModelsURI("hsv2hsl/samples/SolarizedHSV.xmi"));
            myQVT.createModel("middle", this.getTestURI("HSV2HSL_trace.xmi"));
            myQVT.createModel("hsl", this.getTestURI("SolarizedHSL_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("hsl", this.getTestURI("SolarizedHSL_Interpreted.xmi"), this.getModelsURI("hsv2hsl/samples/SolarizedHSL_expected.xmi"), HSV2HSLNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_HSVToHSL_CG() throws Exception {
        MyQVT myQVT = this.createQVT("HSV2HSL", this.getModelsURI("hsv2hsl/HSV2HSL.qvtc"));
        try {
            Class txClass = myQVT.buildTransformation("hsl", false, new String[]{"HSV2HSL.genmodel"});
            myQVT.assertRegionCount(RuleRegionImpl.class, 1);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.loadInput("hsv", this.getModelsURI("hsv2hsl/samples/SolarizedHSV.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("hsl", this.getTestURI("SolarizedHSL_CG.xmi"), this.getModelsURI("hsv2hsl/samples/SolarizedHSL_expected.xmi"), HSV2HSLNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_SimpleUML2RDBMS() throws Exception {
        MyQVT myQVT = this.createQVT("SimpleUML2RDBMS", this.getModelsURI("uml2rdbms/SimpleUML2RDBMS.qvtcas"));
        myQVT.loadEcoreFile(this.getModelsURI("uml2rdbms/SimpleUML2RDBMS.ecore"), Simpleuml2rdbmsPackage.eINSTANCE);
        myQVT.loadEcoreFile(this.getModelsURI("uml2rdbms/SimpleUML.ecore"), SimpleumlPackage.eINSTANCE);
        myQVT.loadEcoreFile(this.getModelsURI("uml2rdbms/SimpleRDBMS.ecore"), SimplerdbmsPackage.eINSTANCE);
        try {
            ImperativeTransformation asTransformation = myQVT.compileTransformation("rdbms");
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("uml", this.getModelsURI("uml2rdbms/samples/SimplerUMLPeople.xmi"));
            myQVT.createModel("middle", this.getTestURI("SimplerUML2RDBMS_trace.xmi"));
            myQVT.createModel("rdbms", this.getTestURI("SimplerRDBMSPeople_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("rdbms", this.getTestURI("SimplerRDBMSPeople_Interpreted.xmi"), this.getModelsURI("uml2rdbms/samples/SimplerRDBMSPeople_expected.xmi"), SimpleRDBMSNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("uml", this.getModelsURI("uml2rdbms/samples/SimplerUMLPeople2.xmi"));
            myQVT.createModel("middle", this.getTestURI("SimplerUML2RDBMS2_trace.xmi"));
            myQVT.createModel("rdbms", this.getTestURI("SimplerRDBMSPeople2_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("rdbms", this.getTestURI("SimplerRDBMSPeople2_Interpreted.xmi"), this.getModelsURI("uml2rdbms/samples/SimplerRDBMSPeople2_expected.xmi"), SimpleRDBMSNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("uml", this.getModelsURI("uml2rdbms/samples/SimpleUMLPeople.xmi"));
            myQVT.createModel("middle", this.getTestURI("SimpleUML2RDBMS_trace.xmi"));
            myQVT.createModel("rdbms", this.getTestURI("SimpleRDBMSPeople_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("rdbms", this.getTestURI("SimpleRDBMSPeople_Interpreted.xmi"), this.getModelsURI("uml2rdbms/samples/SimpleRDBMSPeople_expected.xmi"), SimpleRDBMSNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_SimpleUML2RDBMS_CG() throws Exception {
        Splitter.RESULT.setState(true);
        Splitter.STAGES.setState(true);
        Splitter.RESULT.setState(true);
        MyQVT myQVT = this.createQVT("SimpleUML2RDBMS", this.getModelsURI("uml2rdbms/SimpleUML2RDBMS.qvtcas"));
        myQVT.setSuppressFailureDiagnosis(true);
        try {
            Class txClass = myQVT.buildTransformation("rdbms", false, new String[]{"SimpleUML2RDBMS.genmodel"});
            myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 10 : 11);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.loadInput("uml", this.getModelsURI("uml2rdbms/samples/SimplerUMLPeople.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("rdbms", this.getTestURI("SimplerRDBMSPeople_CG.xmi"), this.getModelsURI("uml2rdbms/samples/SimplerRDBMSPeople_expected.xmi"), SimpleRDBMSNormalizer.INSTANCE);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.loadInput("uml", this.getModelsURI("uml2rdbms/samples/SimplerUMLPeople2.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("rdbms", this.getTestURI("SimplerRDBMSPeople2_CG.xmi"), this.getModelsURI("uml2rdbms/samples/SimplerRDBMSPeople2_expected.xmi"), SimpleRDBMSNormalizer.INSTANCE);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.loadInput("uml", this.getModelsURI("uml2rdbms/samples/SimpleUMLPeople.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("rdbms", this.getTestURI("SimpleRDBMSPeople_CG.xmi"), this.getModelsURI("uml2rdbms/samples/SimpleRDBMSPeople_expected.xmi"), SimpleRDBMSNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_SimpleUML2RDBMS_example_CG() throws Exception {
        Splitter.RESULT.setState(true);
        Splitter.STAGES.setState(true);
        Splitter.RESULT.setState(true);
        String exampleProjectName = "org.eclipse.qvtd.examples.qvtcore.uml2rdbms";
        URI txURI = URI.createPlatformResourceURI((String)("/" + exampleProjectName + "/model/SimpleUML2RDBMS.qvtc"), (boolean)true);
        MyQVT myQVT = this.createQVT("SimpleUML2RDBMS", txURI);
        myQVT.addClasspathProjectName(exampleProjectName);
        myQVT.setSuppressFailureDiagnosis(true);
        try {
            Class txClass = myQVT.buildTransformation("rdbms", false, new String[]{"SimpleUML2RDBMS.genmodel"});
            myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 10 : 11);
            URI inURI = URI.createPlatformResourceURI((String)("/" + exampleProjectName + "/model/in/SimpleUMLPeople.xmi"), (boolean)true);
            URI outURI = this.getTestURI("SimpleRDBMSPeople_CG.xmi");
            URI expectedURI = URI.createPlatformResourceURI((String)("/" + exampleProjectName + "/model/out/SimpleRDBMSPeople_expected.xmi"), (boolean)true);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.loadInput("uml", inURI);
            myQVT.executeTransformation();
            myQVT.saveOutput("rdbms", outURI, expectedURI, SimpleRDBMSNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_Upper2Lower() throws Exception {
        MyQVT myQVT = this.createQVT("Upper2Lower", this.getModelsURI("upper2lower/Upper2Lower.qvtcas"));
        try {
            ImperativeTransformation asTransformation = myQVT.compileTransformation("lowerGraph");
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("upperGraph", this.getModelsURI("upper2lower/samples/SimpleGraph.xmi"));
            myQVT.createModel("middle", this.getTestURI("Upper2Lower_trace.xmi"));
            myQVT.createModel("lowerGraph", this.getTestURI("SimpleGraphLower_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("lowerGraph", this.getTestURI("SimpleGraphLower_Interpreted.xmi"), this.getModelsURI("upper2lower/samples/SimpleGraphLower_expected.xmi"), Upper2LowerNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_Upper2Lower_CG() throws Exception {
        MyQVT myQVT = this.createQVT("upper2lower", this.getModelsURI("upper2lower/Upper2Lower.qvtcas"));
        try {
            Class txClass = myQVT.buildTransformation("lowerGraph", false, new String[]{"SimpleGraph2Graph.genmodel"});
            myQVT.createGeneratedExecutor(txClass);
            myQVT.loadInput("upperGraph", this.getModelsURI("upper2lower/samples/SimpleGraph.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("lowerGraph", this.getTestURI("SimpleGraphLower_CG.xmi"), this.getModelsURI("upper2lower/samples/SimpleGraphLower_expected.xmi"), Upper2LowerNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    protected class MyQVT
    extends AbstractTestQVT {
        public MyQVT(@NonNull ProjectManager projectManager, @NonNull String testProjectName, @NonNull URI testBundleURI, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull URI srcFileURI, URI binFileURI) {
            super(projectManager, testProjectName, testBundleURI, txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI);
        }

        protected @NonNull QVTcCompilerChain createCompilerChain(@NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull CompilerOptions options) {
            return new InstrumentedCompilerChain(this.getEnvironmentFactory(), txURI, intermediateFileNamePrefixURI, options);
        }

        protected @NonNull DefaultCompilerOptions createCompilerChainOptions() {
            DefaultCompilerOptions options = super.createCompilerChainOptions();
            options.setOption("QVTs", CompilerChain.SCHEDULER_NO_EARLY_MERGE, (Object)NO_MERGES);
            options.setOption("QVTs", CompilerChain.SCHEDULER_NO_LATE_CONSUMER_MERGE, (Object)NO_MERGES);
            return options;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected @NonNull List<@NonNull String> createClassProjectNames() {
            @NonNull List classProjectNames = super.createClassProjectNames();
            classProjectNames.add(0, "org.eclipse.qvtd.xtext.qvtcore.tests");
            return classProjectNames;
        }

        protected @NonNull String getBasePrefix() {
            return "org.eclipse.qvtd.xtext.qvtcore.tests";
        }

        protected @NonNull ProjectManager getTestProjectManager() throws Exception {
            return EMFPlugin.IS_ECLIPSE_RUNNING ? new ProjectMap(true) : QVTcCompilerTests.this.getTestProjectManager();
        }

        protected class InstrumentedCompilerChain
        extends QVTcCompilerChain {
            protected InstrumentedCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, CompilerOptions options) {
                super(environmentFactory, txURI, intermediateFileNamePrefixURI, options);
            }

            protected // Could not load outer class - annotation placement on inner may be incorrect
             @NonNull AbstractCompilerChain.QVTm2QVTsCompilerStep createQVTm2QVTsCompilerStep() {
                return new AbstractCompilerChain.QVTm2QVTsCompilerStep((CompilerChain)this){

                    public @NonNull ScheduleManager execute(@NonNull Resource pResource) throws IOException {
                        ScheduleManager scheduleManager = super.execute(pResource);
                        MyQVT.this.instrumentPartition(scheduleManager);
                        return scheduleManager;
                    }
                };
            }
        }
    }
}

