/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractCompilationUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.CompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContextImpl;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstanceFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBlackboxProvider {
    private static final ResolutionContext GLOBAL_RESOLUTION_CONTEXT = new ResolutionContextImpl(BlackboxUnitResolver.GLOBAL_CONTEXT);

    protected AbstractBlackboxProvider() {
    }

    protected CompilationUnit createCompilationUnit(QvtOperationalModuleEnv moduleEnv) {
        return this.createCompilationUnit(Collections.singletonList(moduleEnv));
    }

    protected CompilationUnit createCompilationUnit(final List<QvtOperationalModuleEnv> loadedModules) {
        return new CompilationUnit(){

            @Override
            public List<QvtOperationalModuleEnv> getElements() {
                return Collections.unmodifiableList(loadedModules);
            }
        };
    }

    public static void setInstanceAdapterFactory(Module module, final InstanceAdapterFactory factory) {
        ModuleInstanceFactory moduleInstanceFactory = (ModuleInstanceFactory)module.getEFactoryInstance();
        moduleInstanceFactory.addPostCreateHandler(new ModuleInstanceFactory.PostCreateHandler(){

            public void created(ModuleInstance moduleInstance) {
                Object adapterInstance = factory.createAdapter(moduleInstance);
                moduleInstance.getAdapter(ModuleInstance.Internal.class).addAdapter(adapterInstance);
            }
        });
    }

    protected void setOperationHandler(EOperation operation, final CallHandler handler, boolean adaptSource) {
        CallHandler actualHandler = handler;
        if (adaptSource) {
            actualHandler = new CallHandler(){

                public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
                    return handler.invoke(module, source, args, evalEnv);
                }
            };
        }
        CallHandlerAdapter.attach(operation, actualHandler);
    }

    public abstract Collection<AbstractCompilationUnitDescriptor> getModuleDescriptors(ResolutionContext var1);

    public abstract AbstractCompilationUnitDescriptor getModuleDescriptor(String var1, ResolutionContext var2);

    public abstract CompilationUnit loadCompilationUnit(AbstractCompilationUnitDescriptor var1, LoadContext var2) throws BlackboxException;

    private void handleBlackboxException(BlackboxException e, AbstractCompilationUnitDescriptor descriptor) {
        Diagnostic diagnostic = e.getDiagnostic();
        if (diagnostic != null) {
            QvtPlugin.logDiagnostic(diagnostic);
        } else {
            QvtPlugin.error(NLS.bind(ValidationMessages.FailedToLoadUnit, new Object[]{descriptor.getQualifiedName()}), e);
        }
    }

    public Collection<CallHandler> getBlackboxCallHandler(ImperativeOperation operation, QvtOperationalModuleEnv env) {
        List<CallHandler> result = Collections.emptyList();
        for (AbstractCompilationUnitDescriptor d : this.getModuleDescriptors(GLOBAL_RESOLUTION_CONTEXT)) {
            block5: {
                if (env.getImportedNativeLibs().isEmpty()) {
                    try {
                        this.loadCompilationUnit(d, new LoadContext(env.getEPackageRegistry()));
                        break block5;
                    }
                    catch (BlackboxException e) {
                        this.handleBlackboxException(e, d);
                        continue;
                    }
                }
                if (!env.getImportedNativeLibs().containsKey(d.getURI())) continue;
            }
            Collection<CallHandler> handlers = d.getBlackboxCallHandler(operation, env);
            if (handlers.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new LinkedList<CallHandler>();
            }
            result.addAll(handlers);
        }
        return result;
    }

    public Collection<CallHandler> getBlackboxCallHandler(OperationalTransformation transformation, QvtOperationalModuleEnv env) {
        List<CallHandler> result = Collections.emptyList();
        for (AbstractCompilationUnitDescriptor d : this.getModuleDescriptors(GLOBAL_RESOLUTION_CONTEXT)) {
            block5: {
                if (env.getImportedNativeLibs().isEmpty()) {
                    try {
                        this.loadCompilationUnit(d, new LoadContext(env.getEPackageRegistry()));
                        break block5;
                    }
                    catch (BlackboxException e) {
                        this.handleBlackboxException(e, d);
                        continue;
                    }
                }
                if (!env.getImportedNativeLibs().containsKey(d.getURI())) continue;
            }
            Collection<CallHandler> handlers = d.getBlackboxCallHandler(transformation, env);
            if (handlers.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new LinkedList<CallHandler>();
            }
            result.addAll(handlers);
        }
        return result;
    }

    public static interface InstanceAdapterFactory {
        public Object createAdapter(EObject var1);
    }
}

