/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.reflect;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.access.AbstractTypeProviderFactory;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.TypeResourceServices;
import org.eclipse.xtext.common.types.access.reflect.ReflectionTypeProvider;
import org.eclipse.xtext.resource.XtextResourceSet;

public class ReflectionTypeProviderFactory
extends AbstractTypeProviderFactory {
    private final ClassLoader classLoader;
    protected final TypeResourceServices services;

    @Inject
    public ReflectionTypeProviderFactory(ClassLoader classLoader, TypeResourceServices services) {
        this.classLoader = classLoader;
        this.services = services;
    }

    @Override
    public ReflectionTypeProvider createTypeProvider(ResourceSet resourceSet) {
        if (resourceSet == null) {
            throw new IllegalArgumentException("resourceSet may not be null.");
        }
        ReflectionTypeProvider result = this.createClasspathTypeProvider(resourceSet);
        return result;
    }

    protected ReflectionTypeProvider createClasspathTypeProvider(ResourceSet resourceSet) {
        return new ReflectionTypeProvider(this.getClassLoader(resourceSet), resourceSet, this.getIndexedJvmTypeAccess(), this.services);
    }

    public ClassLoader getClassLoader(ResourceSet resourceSet) {
        XtextResourceSet xtextResourceSet;
        Object ctx;
        if (resourceSet instanceof XtextResourceSet && (ctx = (xtextResourceSet = (XtextResourceSet)resourceSet).getClasspathURIContext()) != null) {
            if (ctx instanceof Class) {
                return ((Class)ctx).getClassLoader();
            }
            if (!(ctx instanceof ClassLoader)) {
                return ctx.getClass().getClassLoader();
            }
            return (ClassLoader)ctx;
        }
        return this.classLoader;
    }

    @Override
    public ReflectionTypeProvider createTypeProvider() {
        return (ReflectionTypeProvider)super.createTypeProvider();
    }

    @Override
    public IJvmTypeProvider findTypeProvider(ResourceSet resourceSet) {
        return super.findTypeProvider(resourceSet);
    }
}

