/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing.validation;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.EValidatorRegistryImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.xtext.testing.validation.AbstractValidatorTester;
import org.eclipse.xtext.testing.validation.AssertableDiagnostics;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class ValidatorTester<T extends AbstractDeclarativeValidator>
extends AbstractValidatorTester {
    protected T validator;
    protected boolean validatorCalled;

    public ValidatorTester(T validator, Injector injector) {
        this(validator, (EValidatorRegistrar)injector.getInstance(EValidatorRegistrar.class), (String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"languageName"))));
    }

    @Inject
    public ValidatorTester(T validator, EValidatorRegistrar registrar, final @Named(value="languageName") String languageName) {
        this.validator = validator;
        EValidator.Registry originalRegistry = registrar.getRegistry();
        EValidatorRegistryImpl newRegistry = new EValidatorRegistryImpl();
        registrar.setRegistry((EValidator.Registry)newRegistry);
        this.validator.register(registrar);
        this.diagnostician = new Diagnostician((EValidator.Registry)newRegistry){

            public Map<Object, Object> createDefaultContext() {
                Map map = super.createDefaultContext();
                map.put(AbstractInjectableValidator.CURRENT_LANGUAGE_NAME, languageName);
                return map;
            }
        };
        registrar.setRegistry(originalRegistry);
        this.validatorCalled = false;
    }

    public AssertableDiagnostics diagnose() {
        if (!this.validatorCalled) {
            throw new IllegalStateException("You have to call validator() before you call diagnose()");
        }
        this.validatorCalled = false;
        AssertableDiagnostics ad = new AssertableDiagnostics((Diagnostic)this.validator.setMessageAcceptor(this.validator).getState().chain);
        this.validator.setMessageAcceptor(this.validator).getState().chain = new BasicDiagnostic();
        return ad;
    }

    public T validator() {
        AbstractDeclarativeValidator.State s = this.validator.setMessageAcceptor(this.validator).getState();
        if (s.chain == null) {
            s.chain = new BasicDiagnostic();
        }
        this.validatorCalled = true;
        return this.validator;
    }
}

