/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.label.DefaultDescriptionLabelProvider;
import org.eclipse.xtext.xtend2.resource.DescriptionFlags;
import org.eclipse.xtext.xtend2.ui.labeling.Xtend2Images;
import org.eclipse.xtext.xtend2.xtend2.Xtend2Package;

public class Xtend2DescriptionLabelProvider
extends DefaultDescriptionLabelProvider {
    @Inject
    private Xtend2Images images;
    @Inject
    private DescriptionFlags descriptionFlags;

    public Object image(IEObjectDescription element) {
        EClass eClass = element.getEClass();
        boolean isStatic = this.descriptionFlags.isStatic(element);
        if (eClass == Xtend2Package.Literals.XTEND_FILE) {
            return this.images.forFile();
        }
        if (eClass == Xtend2Package.Literals.XTEND_IMPORT) {
            return this.images.forImport();
        }
        if (eClass == Xtend2Package.Literals.XTEND_CLASS || eClass == TypesPackage.Literals.JVM_GENERIC_TYPE) {
            return this.images.forClass(JvmVisibility.PUBLIC);
        }
        if (eClass == Xtend2Package.Literals.XTEND_FUNCTION) {
            return this.images.forFunction(JvmVisibility.PUBLIC, isStatic);
        }
        if (eClass == Xtend2Package.Literals.XTEND_FIELD) {
            return this.images.forField(JvmVisibility.PUBLIC, isStatic, false);
        }
        if (eClass == TypesPackage.Literals.JVM_OPERATION) {
            return this.descriptionFlags.isDispatcherOperation(element) ? this.images.forDispatcherFunction(JvmVisibility.PUBLIC, isStatic) : this.images.forFunction(JvmVisibility.PUBLIC, isStatic);
        }
        return super.image(element);
    }
}

