/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.compare;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class StreamContentDocumentProvider
extends AbstractDocumentProvider {
    private static final String SCHEME_REVISION = "revision:/";
    @Inject
    protected Provider<XtextDocument> documentProvider;
    @Inject
    protected Provider<IDocumentPartitioner> documentPartitioner;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private IResourceFactory resourceFactory;

    protected XtextDocument createEmptyDocument() {
        return (XtextDocument)this.documentProvider.get();
    }

    protected IDocument createDocument(Object element) throws CoreException {
        XtextDocument document = null;
        if (element instanceof IStreamContentAccessor) {
            document = this.createEmptyDocument();
            this.setupDocument(element, document);
        }
        return document;
    }

    protected void setupDocument(Object element, IDocument document) {
        String content = this.getString(element);
        document.set(content);
        IDocumentPartitioner partitioner = (IDocumentPartitioner)this.documentPartitioner.get();
        partitioner.connect(document);
        document.setDocumentPartitioner(partitioner);
        XtextResource resource = this.createResource(element);
        this.loadResource(element, (Resource)resource);
        if (resource != null) {
            ((XtextDocument)document).setInput(resource);
        }
    }

    protected XtextResource createResource(Object element) {
        IResourceProvider resourceProvider;
        IResource resource;
        XtextResource xtextResource = null;
        if (element instanceof IResourceProvider && (resource = (resourceProvider = (IResourceProvider)element).getResource()) != null) {
            ResourceSet resourceSet = this.resourceSetProvider.get(resource.getProject());
            URI uri = URI.createURI((String)(SCHEME_REVISION + resource.getName()));
            xtextResource = (XtextResource)this.resourceFactory.createResource(uri);
            xtextResource.setValidationDisabled(true);
            resourceSet.getResources().add((Object)xtextResource);
        }
        return xtextResource;
    }

    protected void loadResource(Object element, Resource resource) {
        if (resource == null) {
            return;
        }
        if (element instanceof IStreamContentAccessor) {
            IStreamContentAccessor streamContentAccessor = (IStreamContentAccessor)element;
            InputStream inputStream = null;
            try {
                try {
                    inputStream = streamContentAccessor.getContents();
                    if (inputStream != null) {
                        resource.load(inputStream, Collections.singletonMap(XtextResource.OPTION_ENCODING, this.getEncoding(element)));
                    }
                }
                catch (Exception exception) {
                    throw new WrappedException(exception);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info.fDocument instanceof XtextDocument) {
            XtextDocument document = (XtextDocument)info.fDocument;
            document.disposeInput();
        }
        super.disposeElementInfo(element, info);
    }

    protected String getEncoding(Object element) {
        String encoding = ResourcesPlugin.getEncoding();
        if (element instanceof IEncodedStreamContentAccessor) {
            try {
                encoding = ((IEncodedStreamContentAccessor)element).getCharset();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return encoding;
    }

    protected String getString(Object input) {
        if (input instanceof IStreamContentAccessor) {
            IStreamContentAccessor streamContentAccessor = (IStreamContentAccessor)input;
            try {
                return this.readString(streamContentAccessor);
            }
            catch (CoreException ex) {
                throw new WrappedException((Exception)((Object)ex));
            }
        }
        return "";
    }

    protected String readString(IStreamContentAccessor streamContentAccessor) throws CoreException {
        InputStream inputStream = streamContentAccessor.getContents();
        if (inputStream != null) {
            String encoding = this.getEncoding(streamContentAccessor);
            return this.readString(inputStream, encoding);
        }
        return null;
    }

    protected String readString(InputStream inputStream, String encoding) {
        if (inputStream == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            StringBuffer buffer = new StringBuffer();
            char[] part = new char[2048];
            int read = 0;
            reader = new BufferedReader(new InputStreamReader(inputStream, encoding));
            while ((read = reader.read(part)) != -1) {
                buffer.append(part, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

